/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.VStyledTreeCellRenderer;
import com.sun.management.viper.console.gui.deck.VBaseDeck;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class VTree
extends JTree
implements PropertyChangeListener,
VConsoleActionListener {
    protected VConsoleProperties properties = null;
    protected VScopeNode lastSelection = null;
    protected boolean doNotify = true;
    protected String treeID = null;
    protected String currentSel = null;
    protected VConsoleModel dataModel = null;
    protected TreeSelectionListener selectionListener = null;
    protected VStyledTreeCellRenderer renderer = null;

    public VTree() {
        this((VConsoleModel)null);
    }

    public VTree(VConsoleModel vConsoleModel) {
        super(vConsoleModel);
        this.dataModel = vConsoleModel;
        this.initTree();
    }

    protected void checkForPropertiesDisplay() {
        if (!this.treeID.equals(this.currentSel)) {
            return;
        }
        if (this.lastSelection == null) {
            return;
        }
        Component component = this.lastSelection.getPropsPane();
        if (component == null) {
            return;
        }
        if (component instanceof Window) {
            component.setVisible(true);
            return;
        }
        VFrame vFrame = new VFrame("");
        if (component instanceof VOptionPane) {
            ((VOptionPane)component).setContainer(vFrame);
            if (component instanceof VBaseDeck) {
                ((VBaseDeck)component).init();
            }
            vFrame.showCenter((JFrame)this.properties.getPropertyObject("vconsole.frame"));
            if (component instanceof VBaseDeck) {
                ((VBaseDeck)component).start();
            }
        } else {
            vFrame.getContentPane().setLayout(new BorderLayout());
            vFrame.getContentPane().add(component, "Center");
            Dimension dimension = component.getPreferredSize();
            ((Component)vFrame).setSize(new Dimension(dimension.width + 10, dimension.height + 50));
            vFrame.showCenter((JFrame)this.properties.getPropertyObject("vconsole.frame"));
        }
    }

    protected void checkPropertiesSetting() {
        try {
            if (!this.treeID.equals(this.currentSel)) {
                return;
            }
            this.properties.setProperty("vconsole.propertiesenabled", "false");
            if (this.lastSelection == null) {
                return;
            }
            if (this.lastSelection.getPropsPane() != null) {
                this.properties.setProperty("vconsole.propertiesenabled", "true");
            }
        }
        catch (Throwable throwable) {}
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string == null) {
            return;
        }
        if (string.equals("vconsole.scopeselected")) {
            try {
                this.doNotify = false;
                VScopeNode vScopeNode = (VScopeNode)vConsoleEvent.getPayload();
                if (vScopeNode != null && vScopeNode != this.lastSelection) {
                    TreePath treePath = new TreePath(vScopeNode.getPath());
                    this.lastSelection = vScopeNode;
                    this.setSelectionPath(treePath);
                }
                this.requestFocus();
                if (this.properties != null) {
                    this.properties.setProperty("vconsole.currentselection", this.treeID);
                }
                this.doNotify = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else if (string.equals("vconsole.displayproperties")) {
            this.checkForPropertiesDisplay();
        }
    }

    protected void expLevel() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath != null) {
            if (this.isCollapsed(treePath)) {
                this.expandPath(treePath);
            } else {
                this.collapsePath(treePath);
            }
            this.validate();
            this.repaint();
        }
    }

    protected VScopeNode getSelectedNode() {
        VScopeNode vScopeNode = null;
        try {
            vScopeNode = (VScopeNode)this.getLastSelectedPathComponent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vScopeNode;
    }

    protected void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                try {
                    TreePath treePath = VTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    VScopeNode vScopeNode = (VScopeNode)treePath.getLastPathComponent();
                    JPopupMenu jPopupMenu = vScopeNode.getPopupMenu();
                    if (jPopupMenu != null) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
                catch (Throwable throwable) {}
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }
        });
        this.selectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                try {
                    if (!VTree.this.doNotify) {
                        return;
                    }
                    VScopeNode vScopeNode = (VScopeNode)VTree.this.getLastSelectedPathComponent();
                    VTree.this.properties.setProperty("vconsole.currentselection", VTree.this.treeID);
                    VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.scopeselected", vScopeNode);
                    VTree.this.dataModel.correlateViewAction(vConsoleEvent);
                    VTree.this.lastSelection = vScopeNode;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        };
        this.addTreeSelectionListener(this.selectionListener);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                try {
                    if (!VTree.this.currentSel.equals(VTree.this.treeID)) {
                        VTree.this.currentSel = VTree.this.treeID;
                        VTree.this.checkPropertiesSetting();
                        VTree.this.properties.setProperty("vconsole.currentselection", VTree.this.treeID);
                    }
                }
                catch (Throwable throwable) {}
            }
        });
    }

    protected void initTree() {
        this.treeID = "vconsole.navigationtree";
        this.setOpaque(false);
        this.setLargeModel(true);
        this.setFont(ResourceManager.bodyFont);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setRootVisible(true);
        this.setRowHeight(-1);
        this.renderer = new VStyledTreeCellRenderer();
        this.renderer.setProperties(this.properties);
        this.renderer.setSelectedFlag(this.treeID);
        this.setCellRenderer(this.renderer);
        this.renderer.setFont(ResourceManager.bodyFont);
        this.renderer.setTextNonSelectionColor(ResourceManager.bodyColor);
        this.getSelectionModel().setSelectionMode(1);
        this.initListeners();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        try {
            if (string.equals("vconsole.currentselection")) {
                this.currentSel = (String)object;
                this.validate();
                this.repaint();
            } else if (string.equals("vconsole.bodyfont")) {
                this.setFont((Font)object);
                this.renderer.setFont((Font)object);
                this.validate();
                this.repaint();
            } else if (string.equals("vconsole.bodycolor")) {
                this.renderer.setTextNonSelectionColor((Color)object);
                this.validate();
                this.repaint();
            }
        }
        catch (Throwable throwable) {}
    }

    public void repaint(Rectangle rectangle) {
        if (rectangle != null) {
            super.repaint(rectangle);
        }
    }

    protected void selectChildNode(int n) {
        try {
            VScopeNode vScopeNode;
            VScopeNode vScopeNode2 = (VScopeNode)this.getLastSelectedPathComponent();
            if (vScopeNode2 != null && (vScopeNode = (VScopeNode)vScopeNode2.getChildAt(n)) != null) {
                this.addSelectionPath(new TreePath(vScopeNode.getPath()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
            this.renderer.setProperties(vConsoleProperties);
            this.currentSel = vConsoleProperties.getProperty("vconsole.currentselection");
        }
    }

    protected void upLevel() {
        try {
            VScopeNode vScopeNode;
            VScopeNode vScopeNode2 = (VScopeNode)this.getLastSelectedPathComponent();
            if (vScopeNode2 != null && (vScopeNode = (VScopeNode)vScopeNode2.getParent()) != null) {
                this.addSelectionPath(new TreePath(vScopeNode.getPath()));
            }
        }
        catch (Exception exception) {}
    }
}

