/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VConsoleTableModel;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VHyperLinkButton;
import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class VStyledTableCellRenderer
extends VHyperLinkButton
implements TableCellRenderer,
PropertyChangeListener {
    protected static ImageIcon smallLeaf = null;
    protected static ImageIcon largeLeaf = null;
    protected static ImageIcon smallFolder = null;
    protected static ImageIcon largeFolder = null;
    protected static Class imageClass = null;
    protected VConsoleProperties properties = null;
    protected String selectedFlag = null;
    protected String iconStyle = null;
    protected boolean webStyle = false;
    protected boolean largeView = false;
    protected boolean detailsView = false;
    protected boolean isPrimary = false;
    protected int pressedRow = -1;
    protected int pressedCol = -1;
    protected int alignment = 0;

    public VStyledTableCellRenderer() {
        super("");
        super.setOpaque(false);
        super.setFocusPainted(true);
        super.setHorizontalAlignment(2);
        this.setBorder(new EmptyBorder(1, 1, 1, 10));
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.VStyledTableCellRenderer");
                smallLeaf = ConsoleUtility.loadImageIcon("images/file16.gif", imageClass);
                largeLeaf = ConsoleUtility.loadImageIcon("images/file32.gif", imageClass);
                smallFolder = ConsoleUtility.loadImageIcon("images/folder16.gif", imageClass);
                largeFolder = ConsoleUtility.loadImageIcon("images/folder32.gif", imageClass);
            }
        }
        catch (Exception exception) {}
    }

    public void clearPressed() {
        this.pressedRow = -1;
        this.pressedCol = -1;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        VConsoleTableModel vConsoleTableModel;
        int n3;
        TableModel tableModel;
        this.setHyperLinkOn(this.webStyle);
        if (this.detailsView && n2 != 0) {
            super.setHasFocus(false);
            super.setSelected(false);
            super.setHyperLinkOn(false);
        } else {
            super.setHasFocus(bl2);
            super.setSelected(bl);
        }
        if (object == null) {
            super.setHasFocus(false);
        }
        this.setFont(jTable.getFont());
        this.setPrimarySelection(this.isPrimary);
        this.model.setPressed(n == this.pressedRow && n2 == this.pressedCol);
        this.alignment = this.largeView ? 0 : (this.detailsView ? ((tableModel = jTable.getModel()) instanceof VConsoleTableModel ? ((n3 = (vConsoleTableModel = (VConsoleTableModel)tableModel).getColumnWidth(n2)) > 20000 ? 1 : (n3 > 10000 ? 0 : -1)) : -1) : -1);
        return this.setValue(object);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.iconstyle")) {
            this.iconStyle = (String)propertyChangeEvent.getNewValue();
            this.detailsView = this.iconStyle.equals("details");
            this.largeView = this.iconStyle.equals("large");
        } else if (string.equals("vconsole.clickstyle")) {
            this.webStyle = ((String)propertyChangeEvent.getNewValue()).equals("web");
        } else if (string.equals("vconsole.currentselection")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            this.isPrimary = string2.equals(this.selectedFlag);
        }
    }

    public void setPressed(int n, int n2) {
        this.pressedRow = n;
        this.pressedCol = n2;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties == null) {
            return;
        }
        this.properties = vConsoleProperties;
        try {
            vConsoleProperties.addPropertyChangeListener(this);
            this.iconStyle = vConsoleProperties.getProperty("vconsole.iconstyle");
            this.detailsView = this.iconStyle.equals("details");
            this.largeView = this.iconStyle.equals("large");
            this.webStyle = vConsoleProperties.getProperty("vconsole.clickstyle").equals("web");
            String string = vConsoleProperties.getProperty("vconsole.currentselection");
            this.isPrimary = string.equals(this.selectedFlag);
        }
        catch (Throwable throwable) {}
    }

    public void setSelectedFlag(String string) {
        this.selectedFlag = string;
    }

    protected Component setValue(Object object) {
        if (object == null) {
            this.setText("");
            this.setIcon(null);
            this.setToolTipText(null);
            return this;
        }
        if (object instanceof VScopeNode) {
            VScopeNode vScopeNode = (VScopeNode)object;
            this.setText(vScopeNode.getText());
            if (this.iconStyle.equals("large")) {
                ImageIcon imageIcon = vScopeNode.getLargeIcon();
                Image image = null;
                if (imageIcon != null) {
                    image = imageIcon.getImage();
                }
                if (image == null || imageIcon.getIconWidth() <= 0) {
                    if (vScopeNode.getChildCount() > 0) {
                        this.setIcon(largeFolder);
                    } else {
                        this.setIcon(largeLeaf);
                    }
                } else {
                    this.setIcon(imageIcon);
                }
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
            } else if (this.detailsView) {
                ImageIcon imageIcon = vScopeNode.getSmallIcon();
                Image image = null;
                if (imageIcon != null) {
                    image = imageIcon.getImage();
                }
                if (image == null || imageIcon.getIconWidth() <= 0) {
                    if (vScopeNode.getChildCount() > 0) {
                        this.setIcon(smallFolder);
                    } else {
                        this.setIcon(smallLeaf);
                    }
                } else {
                    this.setIcon(imageIcon);
                }
                this.setHorizontalTextPosition(4);
                this.setVerticalTextPosition(0);
            } else {
                ImageIcon imageIcon = vScopeNode.getSmallIcon();
                Image image = null;
                if (imageIcon != null) {
                    image = imageIcon.getImage();
                }
                if (image == null || imageIcon.getIconWidth() <= 0) {
                    if (vScopeNode.getChildCount() > 0) {
                        this.setIcon(smallFolder);
                    } else {
                        this.setIcon(smallLeaf);
                    }
                } else {
                    this.setIcon(imageIcon);
                }
                this.setHorizontalTextPosition(4);
                this.setVerticalTextPosition(0);
            }
            this.setToolTipText(vScopeNode.getToolTipText());
            if (this.alignment == 0) {
                this.setHorizontalAlignment(0);
            } else if (this.alignment == 1) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
        if (object instanceof Component) {
            return (Component)object;
        }
        this.setText(object.toString());
        this.setIcon(null);
        this.setToolTipText(null);
        if (this.alignment == 0) {
            this.setHorizontalAlignment(0);
        } else if (this.alignment == 1) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        return this;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }
}

