/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.gui.VViewport;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class VScrollPane
extends JScrollPane {
    protected Color filterClr = null;
    protected String filterStr = null;
    protected Font filterFnt = null;
    protected boolean isFiltered = false;
    protected boolean paintImage = false;
    protected Image image = null;
    protected int imageLoc = -1;

    public VScrollPane() {
        this.setOpaque(false);
        this.filterClr = new Color(241, 241, 250);
        super.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.installStrings();
    }

    protected void installStrings() {
        this.filterStr = ResourceManager.getString("FILTERED VIEW");
        float f = 18.0f;
        this.filterFnt = ResourceManager.menuFont.deriveFont(f);
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public boolean isPaintingImage() {
        return this.paintImage;
    }

    public void paint(Graphics graphics) {
        if (this.isFiltered) {
            this.paintFilterState(graphics);
        }
        if (this.paintImage && this.image != null) {
            Rectangle rectangle = this.getViewportBorderBounds();
            int n = this.image.getWidth(this);
            int n2 = this.image.getHeight(this);
            switch (this.imageLoc) {
                case 0: {
                    graphics.drawImage(this.image, rectangle.x, rectangle.y, this);
                    break;
                }
                case 1: {
                    graphics.drawImage(this.image, (rectangle.width - n) / 2 + rectangle.x, rectangle.y, this);
                    break;
                }
                case 2: {
                    graphics.drawImage(this.image, rectangle.width - n + rectangle.x, rectangle.y, this);
                    break;
                }
                case 3: {
                    graphics.drawImage(this.image, rectangle.x, (rectangle.height - n2) / 2 + rectangle.y, this);
                    break;
                }
                case 4: {
                    graphics.drawImage(this.image, (rectangle.width - n) / 2 + rectangle.x, (rectangle.height - n2) / 2 + rectangle.y, this);
                    break;
                }
                case 5: {
                    graphics.drawImage(this.image, rectangle.width - n + rectangle.x, (rectangle.height - n2) / 2 + rectangle.y, this);
                    break;
                }
                case 6: {
                    graphics.drawImage(this.image, rectangle.x, rectangle.height - n2 + rectangle.y, this);
                    break;
                }
                case 7: {
                    graphics.drawImage(this.image, (rectangle.width - n) / 2 + rectangle.x, rectangle.height - n2 + rectangle.y, this);
                    break;
                }
                case 8: {
                    graphics.drawImage(this.image, rectangle.width - n + rectangle.x, rectangle.height - n2 + rectangle.y, this);
                    break;
                }
            }
        }
        super.paint(graphics);
    }

    protected void paintFilterState(Graphics graphics) {
        try {
            Rectangle rectangle = this.getViewportBorderBounds();
            Rectangle rectangle2 = this.getBounds();
            rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.height);
            int n = rectangle.height - 149;
            graphics.setColor(this.filterClr);
            graphics.fillRect(0, n, rectangle.width, 2);
            graphics.fillRect(0, n += 16, rectangle.width + 4, 3);
            graphics.fillRect(0, n += 13, rectangle.width + 4, 4);
            graphics.fillRect(0, n += 12, rectangle.width + 4, 6);
            graphics.fillRect(0, n += 12, rectangle.width + 4, 9);
            graphics.fillRect(0, n += 15, rectangle.width + 4, 11);
            graphics.fillRect(0, n += 16, rectangle.width + 4, 14);
            graphics.fillRect(0, n += 18, rectangle.width + 4, 19);
            graphics.fillRect(0, n += 21, rectangle.width + 4, 27);
            if (this.filterStr == null) {
                return;
            }
            graphics.setColor(Color.white);
            Font font = graphics.getFont();
            graphics.setFont(this.filterFnt);
            int n2 = graphics.getFontMetrics().stringWidth(this.filterStr);
            graphics.drawString(this.filterStr, rectangle.width / 2 - n2 / 2, n + 20);
            graphics.setFont(font);
        }
        catch (Exception exception) {}
    }

    public void setFiltered(boolean bl) {
        this.isFiltered = bl;
        this.validate();
        this.repaint();
    }

    public void setImage(Image image, int n) {
        this.image = image;
        this.imageLoc = n;
    }

    public void setPaintImage(boolean bl) {
        this.paintImage = bl;
        this.validate();
        this.repaint();
    }

    public void setView(Component component) {
        VViewport vViewport = new VViewport();
        vViewport.setOpaque(false);
        if (component != null) {
            vViewport.setView(component);
            if (component instanceof JComponent) {
                ((JComponent)component).requestDefaultFocus();
            }
        }
        this.setViewport(vViewport);
    }
}

