/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VHTMLEditorKit;
import com.sun.management.viper.console.gui.VLinkListener;
import com.sun.management.viper.console.gui.VOptionPaneContent;
import com.sun.management.viper.console.gui.VOptionPaneInfo;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class VOptionPane
extends JPanel
implements PropertyChangeListener,
VConsoleActionListener {
    protected JPanel buttonPane = null;
    protected VOptionPaneInfo infoPane = null;
    protected VOptionPaneContent contentPane = null;
    protected VLinkListener hLinkListener = null;
    protected Vector listeners = null;
    protected VConsoleProperties properties = null;
    protected JScrollPane helpPane = null;
    protected JEditorPane helpMsg = null;
    protected VHTMLEditorKit editorKit = null;
    protected JFrame parentJFrame = null;
    protected JInternalFrame parentIFrame = null;
    protected JDialog parentJDialog = null;
    protected VContainer parentContainer = null;
    protected Component container = null;
    protected String title = null;
    protected final Dimension defOpenSize = new Dimension(640, 440);
    protected final Dimension defClosedSize = new Dimension(440, 440);
    protected boolean infoOn = true;
    protected int prefInfoWidth = 0;

    public VOptionPane() {
        this(null, null, true);
    }

    public VOptionPane(String string) {
        this(null, string, true);
    }

    public VOptionPane(String string, String string2) {
        this(string, string2, true);
    }

    public VOptionPane(String string, String string2, boolean bl) {
        this(string, string2, bl, VOptionPaneInfo.DEFAULTWIDTH);
    }

    public VOptionPane(String string, String string2, boolean bl, int n) {
        this.title = string;
        this.prefInfoWidth = n;
        this.setLayout(new BorderLayout());
        this.buttonPane = new JPanel();
        this.buttonPane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(0, 0, 0, 10)));
        this.buttonPane.setLayout(new FlowLayout(2));
        this.add((Component)this.buttonPane, "South");
        this.contentPane = new VOptionPaneContent(this);
        this.contentPane.setTitle(string2);
        this.infoPane = new VOptionPaneInfo(this, n);
        this.helpPane = new JScrollPane();
        this.helpPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.helpPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.helpPane.setBackground(Color.white);
        this.infoPane.addInfoComponent("Help", this.helpPane, "Context Help");
        this.add((Component)this.infoPane, "West");
        this.add((Component)this.contentPane, "Center");
        this.infoOn = bl;
        this.toggleInfoPane(bl);
        this.validate();
        this.repaint();
        this.hLinkListener = new VLinkListener();
        this.hLinkListener.addConsoleActionListener(new VConsoleActionListener(){

            public void consoleAction(VConsoleEvent vConsoleEvent) {
                VOptionPane.this.notifyListeners(vConsoleEvent);
            }
        });
        this.setHelpHTML((URL)null);
    }

    public VOptionPane(String string, boolean bl) {
        this(null, string, bl);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    public void addInfoComponent(String string, Component component) {
        this.addInfoComponent(string, null, component, null);
    }

    public void addInfoComponent(String string, ImageIcon imageIcon, Component component) {
        this.addInfoComponent(string, imageIcon, component, null);
    }

    public void addInfoComponent(String string, ImageIcon imageIcon, Component component, String string2) {
        this.infoPane.addInfoComponent(string, imageIcon, component, string2);
    }

    public void addInfoPaneControlFocusListener(FocusListener focusListener) {
        this.contentPane.addToggleFocusListener(focusListener);
        this.infoPane.addToggleFocusListener(focusListener);
    }

    protected void buildTestPane() {
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                VOptionPane.this.setHelpHTML("<HTML><HEAD><TITLE></TITLE></HEAD><BODY BGCOLOR=\"#FFFFFF\"><H3>Dialog Help</H3>This dialog box lets you do all sorts of cool and nifty stuff. Use it to get your entire life in order.<BR><BR><A HREF=\"http://Wheres_Waldo\">Click Here</A> to learn more about why you might want to get your life in order.<ol><li>One<li>Two<li>Three</ol></BODY></HTML>");
            }
        };
        JButton jButton = new JButton("Change1");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VOptionPane.this.setHelpHTML("<HTML><HEAD><TITLE></TITLE></HEAD><BODY BGCOLOR=\"#FFFFFF\"><H3>Dialog Help</H3>This dialog box lets you do all sorts of cool and nifty stuff. Use it to get your entire life in order.<BR><BR><A HREF=\"http://Wheres_Waldo\">Click Here</A> to learn more about why you might want to get your life in order.<ol><li>Three<li>Two<li>One</ol></BODY></HTML>");
            }
        });
        this.getContentPane().add(jButton);
        this.getHelpPane().addFocusListener(focusAdapter);
    }

    protected Dimension calculatePreferredSize() {
        Dimension dimension = this.buttonPane.getPreferredSize();
        Dimension dimension2 = this.contentPane.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.infoOn) {
            Dimension dimension3 = this.infoPane.getPreferredSize();
            if (dimension2.width + dimension3.width > n) {
                n = dimension2.width + dimension3.width;
            }
            n2 = dimension3.height > dimension2.height ? (n2 += dimension3.height) : (n2 += dimension2.height);
        } else {
            n2 += dimension2.height;
            if (dimension2.width > n) {
                n = dimension2.width;
            }
        }
        return new Dimension(n += 8, n2 += 20);
    }

    protected void cancelAction() {
        if (this.container != null) {
            this.container.setVisible(false);
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
    }

    protected void constructEditorPane() {
        if (this.helpMsg == null) {
            this.helpMsg = new JEditorPane();
            this.helpMsg.setEditable(false);
            if (this.editorKit == null) {
                this.editorKit = new VHTMLEditorKit();
            }
            this.helpMsg.setEditorKitForContentType("text/html", this.editorKit);
            this.helpMsg.setContentType("text/html");
            this.hLinkListener.setEditorPane(this.helpMsg);
            this.helpMsg.addHyperlinkListener(this.hLinkListener);
            this.helpMsg.setNextFocusableComponent(this.getContentPane());
            KeyAdapter keyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    boolean bl = keyEvent.isShiftDown();
                    if (keyEvent.getKeyCode() == 9) {
                        if (bl) {
                            VOptionPane.this.infoPane.handleTab(keyEvent);
                        } else {
                            VOptionPane.this.contentPane.handleTab(keyEvent);
                        }
                    }
                }
            };
            this.helpMsg.addKeyListener(keyAdapter);
        }
    }

    protected void defaultAction() {
    }

    public JComponent getButtonPane() {
        return this.buttonPane;
    }

    public Component getContainer() {
        return this.container;
    }

    public JComponent getContentPane() {
        return this.contentPane.getContentPane();
    }

    public String getContentTitle() {
        return this.contentPane.getTitle();
    }

    public JEditorPane getHelpEditorPane() {
        if (this.helpMsg == null) {
            this.constructEditorPane();
        }
        return this.helpMsg;
    }

    public JComponent getHelpPane() {
        return (JComponent)this.helpPane.getViewport().getView();
    }

    public JComponent getInfoPane() {
        return this.infoPane;
    }

    public Dimension getPreferredSize() {
        return this.calculatePreferredSize();
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isInfoPaneVisible() {
        return this.infoOn;
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(true);
        VOptionPane vOptionPane = new VOptionPane("VOptionPane Test", "Test");
        JButton jButton = new JButton("Ok");
        jButton.setFont(ResourceManager.menuFont);
        vOptionPane.getButtonPane().add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setFont(ResourceManager.menuFont);
        vOptionPane.getButtonPane().add(jButton2);
        vOptionPane.buildTestPane();
        if (stringArray.length > 0) {
            vOptionPane.addInfoComponent("Test", new JPanel());
        }
        JFrame jFrame = new JFrame();
        JDialog jDialog = new JDialog(jFrame, "", false);
        vOptionPane.setContainer(jDialog);
        vOptionPane.setSize(new Dimension(500, 300));
        vOptionPane.setLocation(new Point(100, 100));
        vOptionPane.setVisible(true);
        vOptionPane.setInfoPaneControlHasDefaultFocus();
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void paneClosed() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void setContainer(Component component) {
        Object object;
        if (component == null) {
            return;
        }
        if (component instanceof VContainer) {
            object = (VContainer)((Object)component);
            object.setDefaultAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VOptionPane.this.defaultAction();
                }
            });
            object.setCancelAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VOptionPane.this.cancelAction();
                }
            });
            object.setComponent(this);
            try {
                this.container = component;
            }
            catch (Exception exception) {}
            this.parentContainer = object;
        }
        if (component instanceof JInternalFrame) {
            object = (JInternalFrame)component;
            if (this.title != null) {
                ((JInternalFrame)object).setTitle(this.title);
            } else {
                ((JInternalFrame)object).setTitle(" ");
            }
            InternalFrameAdapter internalFrameAdapter = new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    VOptionPane.this.paneClosed();
                }
            };
            ((JInternalFrame)object).addInternalFrameListener(internalFrameAdapter);
            ((JInternalFrame)object).setDefaultCloseOperation(2);
            ((JInternalFrame)object).getContentPane().setLayout(new BorderLayout());
            ((JInternalFrame)object).getContentPane().add((Component)this, "Center");
        } else if (component instanceof JFrame) {
            object = (JFrame)component;
            if (this.title != null) {
                ((Frame)object).setTitle(this.title);
            } else {
                ((Frame)object).setTitle(" ");
            }
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    VOptionPane.this.paneClosed();
                }
            };
            ((Window)object).addWindowListener(windowAdapter);
            ((JFrame)object).getContentPane().setLayout(new BorderLayout());
            ((JFrame)object).getContentPane().add((Component)this, "Center");
        } else if (component instanceof JDialog) {
            object = (JDialog)component;
            if (this.title != null) {
                ((Dialog)object).setTitle(this.title);
            } else {
                ((Dialog)object).setTitle(" ");
            }
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    VOptionPane.this.paneClosed();
                }
            };
            ((Window)object).addWindowListener(windowAdapter);
            ((JDialog)object).getContentPane().setLayout(new BorderLayout());
            ((JDialog)object).getContentPane().add((Component)this, "Center");
        }
        this.container = component;
    }

    public void setContentTitle(String string) {
        this.contentPane.setTitle(string);
    }

    public void setHelpHTML(String string) {
        try {
            if (this.helpMsg == null) {
                this.constructEditorPane();
            }
            JViewport jViewport = this.helpPane.getViewport();
            jViewport.add(this.helpMsg);
            this.helpMsg.removeAll();
            this.helpMsg.setDocument(this.helpMsg.getEditorKit().createDefaultDocument());
            this.helpMsg.setText(string);
            this.helpMsg.setNextFocusableComponent(this.contentPane);
            this.helpMsg.setCaretPosition(0);
        }
        catch (Exception exception) {}
    }

    public void setHelpHTML(URL uRL) {
        try {
            if (this.helpMsg == null) {
                this.constructEditorPane();
            }
            JViewport jViewport = this.helpPane.getViewport();
            jViewport.add(this.helpMsg);
            this.helpMsg.removeAll();
            this.helpMsg.setDocument(this.helpMsg.getEditorKit().createDefaultDocument());
            this.helpMsg.setPage(uRL);
            this.helpMsg.setNextFocusableComponent(this.contentPane);
            this.helpMsg.setCaretPosition(0);
        }
        catch (Exception exception) {
            String string = "<HTML><HEAD><TITLE></TITLE></HEAD><BODY></BODY></HTML>";
            this.helpMsg.removeAll();
            this.helpMsg.setText(string);
            this.helpMsg.setCaretPosition(0);
        }
    }

    public void setInfoPaneControlHasDefaultFocus() {
        this.contentPane.setToggleHasDefaultFocus();
        this.infoPane.setToggleHasDefaultFocus();
    }

    public void setLocation(int n, int n2) {
        if (this.container != null) {
            this.container.setLocation(n, n2);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.parentJFrame != null) {
            this.parentJFrame.setTitle(string);
        }
        if (this.parentIFrame != null) {
            this.parentIFrame.setTitle(string);
        }
        if (this.parentContainer != null) {
            this.parentContainer.setTitle(string);
        }
    }

    public void setVisible(boolean bl) {
        if (this.container != null) {
            this.container.setVisible(bl);
        }
    }

    public void showCenter(Component component) {
        try {
            Object object;
            if (this.container == null) {
                return;
            }
            Dimension dimension = null;
            Point point = null;
            if (component != null) {
                dimension = component.getSize();
                point = component.getLocation();
            } else {
                object = Toolkit.getDefaultToolkit();
                dimension = ((Toolkit)object).getScreenSize();
                point = new Point(0, 0);
            }
            object = this.getPreferredSize();
            int n = point.x + dimension.width / 2 - ((Dimension)object).width / 2;
            int n2 = point.y + dimension.height / 2 - ((Dimension)object).height / 2;
            if (!this.container.isShowing()) {
                this.container.setLocation(n, n2);
                this.container.setVisible(true);
            } else if (this.container instanceof Window) {
                ((Window)this.container).toFront();
            }
        }
        catch (Throwable throwable) {}
    }

    public void toggleContentTitle(boolean bl) {
        this.contentPane.setShowHeader(bl);
    }

    public void toggleInfoPane(boolean bl) {
        Point point = null;
        if (this.isShowing() && this.container != null) {
            point = this.container.getLocationOnScreen();
        }
        this.infoOn = bl;
        if (bl) {
            this.add((Component)this.infoPane, "West");
        } else {
            this.remove(this.infoPane);
        }
        this.contentPane.toggleInfo(bl ^ true);
        this.infoPane.toggleInfo(bl);
        this.validate();
        if (this.container != null) {
            this.container.setSize(this.calculatePreferredSize());
        }
        if (this.container != null && point != null) {
            point = bl ? new Point(point.x - this.prefInfoWidth / 2, point.y) : new Point(point.x + this.prefInfoWidth / 2, point.y);
            this.container.setLocation(point);
            this.container.invalidate();
            this.container.validate();
            this.container.repaint();
        }
        this.validate();
        this.repaint();
    }
}

