/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.util.Debug;
import java.awt.Cursor;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class VLinkListener
implements HyperlinkListener,
VConsoleActionListener {
    protected JEditorPane pane = null;
    protected Vector listeners = null;

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (eventType == HyperlinkEvent.EventType.ENTERED) {
            URL uRL = hyperlinkEvent.getURL();
            String string = null;
            if (uRL != null) {
                string = uRL.toString();
            }
            this.pane.setCursor(Cursor.getPredefinedCursor(12));
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.updatestatus", string);
            this.notifyListeners(vConsoleEvent);
        } else if (eventType == HyperlinkEvent.EventType.EXITED) {
            this.pane.setCursor(Cursor.getDefaultCursor());
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.updatestatus", " ");
            this.notifyListeners(vConsoleEvent);
        } else {
            try {
                String string = hyperlinkEvent.getDescription();
                URL uRL = hyperlinkEvent.getURL();
                if (uRL != null) {
                    string = uRL.toString();
                } else if (string.startsWith("helpset://")) {
                    string = string.substring(10, string.length());
                }
                VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.hyperlinkevent", string);
                this.notifyListeners(vConsoleEvent);
            }
            catch (Exception exception) {
                Debug.trace("VLinkListener", Debug.ERROR, "Problem with hyperlink", exception);
            }
        }
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void setEditorPane(JEditorPane jEditorPane) {
        this.pane = jEditorPane;
    }
}

