/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDefaultFilter;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;

public class VFilterPane
extends VOptionPane
implements PropertyChangeListener,
VConsoleActionListener {
    protected VDefaultFilter defaultFilter = null;
    protected Vector listeners = null;
    protected VFilter filter = null;
    protected Action filterAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (VFilterPane.this.filterButton != null) {
                VFilterPane.this.filterButton.doClick();
            }
        }

        public void setEnabled(boolean bl) {
            if (VFilterPane.this.filterButton != null) {
                VFilterPane.this.filterButton.setEnabled(bl);
            }
            if (VFilterPane.this.unfilterButton != null) {
                VFilterPane.this.unfilterButton.setEnabled(bl ^ true);
            }
        }
    };
    protected JButton unfilterButton = null;
    protected JButton filterButton = null;
    protected JButton clearButton = null;
    protected JButton closeButton = null;
    protected VConsoleProperties properties = null;
    protected VConsoleModel dataModel = null;
    protected VScopeNode selNode = null;

    public VFilterPane() {
        this.defaultFilter = new VDefaultFilter();
        this.defaultFilter.setFindMode(false);
        this.defaultFilter.setOptionPane(this);
        this.defaultFilter.setFilterAction(this.filterAction);
        this.filter = this.defaultFilter;
        this.unfilterButton = new JButton();
        this.unfilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VFilterPane.this.filter.setFilterEnabled(false);
                VFilterPane.this.unfilterButton.setEnabled(false);
                VFilterPane.this.filterButton.setEnabled(true);
                VFilterPane.this.selNode.setFilterControl(VFilterPane.this.filter);
                VConsoleEvent vConsoleEvent = new VConsoleEvent(VFilterPane.this, "vconsole.filter", VFilterPane.this.selNode);
                VFilterPane.this.notifyListeners(vConsoleEvent);
                if (VFilterPane.this.container != null) {
                    VFilterPane.this.container.setVisible(false);
                }
            }
        });
        this.unfilterButton.setEnabled(false);
        this.filterButton = new JButton();
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VFilterPane.this.filter.setFilterEnabled(true);
                VFilterPane.this.unfilterButton.setEnabled(true);
                VFilterPane.this.selNode.setFilterControl(VFilterPane.this.filter);
                VConsoleEvent vConsoleEvent = new VConsoleEvent(VFilterPane.this, "vconsole.filter", VFilterPane.this.selNode);
                VFilterPane.this.notifyListeners(vConsoleEvent);
                if (VFilterPane.this.container != null) {
                    VFilterPane.this.container.setVisible(false);
                }
            }
        });
        this.clearButton = new JButton();
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VFilterPane.this.filter != null) {
                    VFilterPane.this.filter.clearFilter();
                }
            }
        });
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VFilterPane.super.cancelAction();
            }
        });
        this.getButtonPane().add(this.unfilterButton);
        this.getButtonPane().add(this.filterButton);
        this.getButtonPane().add(this.clearButton);
        this.getButtonPane().add(this.closeButton);
        this.installStrings();
        this.updateFontAndColor();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        try {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.addElement(vConsoleActionListener);
            ((VDefaultFilter)this.filter).addConsoleActionListener(vConsoleActionListener);
        }
        catch (Throwable throwable) {}
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        try {
            this.defaultFilter.consoleAction(vConsoleEvent);
            String string = vConsoleEvent.getID();
            if (string.equals("vconsole.scopeselected")) {
                Object object;
                VFilter vFilter = null;
                if (this.selNode != null) {
                    vFilter = this.selNode.getFilterControl();
                }
                if (vFilter != null && vFilter == this.defaultFilter) {
                    vFilter.clearFilter();
                    if (vFilter.getFilterEnabled()) {
                        vFilter.setFilterEnabled(false);
                        object = new VConsoleEvent(this, "vconsole.updatescope", this.selNode);
                        this.notifyListeners((VConsoleEvent)object);
                    }
                }
                this.selNode = (VScopeNode)vConsoleEvent.getPayload();
                object = null;
                if (this.selNode != null) {
                    object = this.selNode.getFilterControl();
                }
                this.filter = object != null ? object : this.defaultFilter;
                this.getContentPane().removeAll();
                this.filter.setFindMode(false);
                this.filter.setOptionPane(this);
                this.filterAction.setEnabled(this.filter.getFilterEnabled() ^ true);
                this.filter.setFilterAction(this.filterAction);
                this.filter.setProperties(this.properties);
                Dimension dimension = super.calculatePreferredSize();
                this.container.setSize(new Dimension(dimension.width, dimension.height + 20));
                this.validate();
                this.repaint();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void installStrings() {
        this.unfilterButton.setText(ResourceManager.getString("UNFILTER_BUTTON"));
        AccessibleContext accessibleContext = this.unfilterButton.getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("UNFILTER_BUTTON_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("UNFILTER_BUTTON_access_desc"));
        this.filterButton.setText(ResourceManager.getString("FILTER_BUTTON"));
        accessibleContext = this.filterButton.getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("FILTER_BUTTON_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("FILTER_BUTTON_access_desc"));
        this.clearButton.setText(ResourceManager.getString("CLEAR_BUTTON"));
        accessibleContext = this.clearButton.getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("CLEAR_BUTTON_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("CLEAR_BUTTON_access_desc"));
        this.closeButton.setText(ResourceManager.getString("CLOSE_BUTTON"));
        accessibleContext = this.closeButton.getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("CLOSE_BUTTON_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("CLOSE_BUTTON_access_desc"));
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(true);
        VFrame vFrame = new VFrame();
        VFilterPane vFilterPane = new VFilterPane();
        vFilterPane.setContainer(vFrame);
        vFilterPane.showCenter(null);
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.menufont") || string.equals("vconsole.menucolor")) {
            this.updateFontAndColor();
        }
    }

    public void setModel(VConsoleModel vConsoleModel) {
        try {
            this.dataModel = vConsoleModel;
            this.defaultFilter.setModel(vConsoleModel);
        }
        catch (Throwable throwable) {}
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        this.defaultFilter.setProperties(vConsoleProperties);
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
        }
    }

    protected void updateFontAndColor() {
        this.unfilterButton.setFont(ResourceManager.menuFont);
        this.unfilterButton.setForeground(ResourceManager.menuColor);
        this.filterButton.setFont(ResourceManager.menuFont);
        this.filterButton.setForeground(ResourceManager.menuColor);
        this.clearButton.setFont(ResourceManager.menuFont);
        this.clearButton.setForeground(ResourceManager.menuColor);
        this.closeButton.setFont(ResourceManager.menuFont);
        this.closeButton.setForeground(ResourceManager.menuColor);
    }
}

