/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VLogAlarm;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VHTMLEditorKit;
import com.sun.management.viper.console.gui.VHyperLinkButton;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.VScrollPane;
import com.sun.management.viper.console.gui.VStyledTableHeaderRenderer;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VEventViewer
extends VOptionPane {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_EVENTS = 1;
    public static final int FILTER_INFO_EVENTS = 2;
    public static final int FILTER_WARN_EVENTS = 3;
    public static final int FILTER_ERR_EVENTS = 4;
    public static final int FILTER_ALARMS = 5;
    public static final int FILTER_INDT_ALARMS = 6;
    public static final int FILTER_WARN_ALARMS = 7;
    public static final int FILTER_MINR_ALARMS = 8;
    public static final int FILTER_MAJR_ALARMS = 9;
    public static final int FILTER_CRTC_ALARMS = 10;
    protected static ImageIcon infoType = null;
    protected static ImageIcon warnType = null;
    protected static ImageIcon errType = null;
    protected static ImageIcon indtSvrty = null;
    protected static ImageIcon warnSvrty = null;
    protected static ImageIcon minrSvrty = null;
    protected static ImageIcon majrSvrty = null;
    protected static ImageIcon crtcSvrty = null;
    protected static ImageIcon filterIcon = null;
    protected static ImageIcon alarmIcon = null;
    protected static Class imageClass = null;
    protected EventInfo eventInfo = null;
    protected JTable eventTable = null;
    protected Vector eventLog = new Vector();
    protected static String[] columns = null;
    protected int filterID = 0;
    protected static SimpleDateFormat dateFormatter = null;
    protected int numAlarms = 0;
    protected int numEvInfo = 0;
    protected int numEvWarn = 0;
    protected int numEvErr = 0;
    protected int numAlIndt = 0;
    protected int numAlWarn = 0;
    protected int numAlMinr = 0;
    protected int numAlMajr = 0;
    protected int numAlCrtc = 0;
    protected boolean paintFiltered = false;
    protected Color filterClr = new Color(241, 241, 250);
    protected String filterStr = null;
    protected Font filterFnt = null;
    protected VScrollPane scroller = null;
    protected JButton closeButton = null;
    protected VHyperLinkButton linkButton = null;
    protected String defaultSrc = null;

    public VEventViewer() {
        super(ResourceManager.getString("Console Log"), null, true, 200);
        float f = 18.0f;
        this.filterFnt = ResourceManager.menuFont.deriveFont(f);
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.VEventViewer");
                dateFormatter = new SimpleDateFormat("hh:mm a  d MMM yy");
                warnType = ConsoleUtility.loadImageIcon("lf/images/Event_Warn16.gif", imageClass);
                errType = ConsoleUtility.loadImageIcon("lf/images/Event_Err16.gif", imageClass);
                infoType = ConsoleUtility.loadImageIcon("lf/images/Event_Info16.gif", imageClass);
                indtSvrty = ConsoleUtility.loadImageIcon("lf/images/Event_IndtAlarm16.gif", imageClass);
                warnSvrty = ConsoleUtility.loadImageIcon("lf/images/Event_Warn16.gif", imageClass);
                minrSvrty = ConsoleUtility.loadImageIcon("lf/images/Event_MinorAlarm16.gif", imageClass);
                majrSvrty = ConsoleUtility.loadImageIcon("lf/images/Event_MajorAlarm16.gif", imageClass);
                crtcSvrty = ConsoleUtility.loadImageIcon("lf/images/Event_CrtcAlarm16.gif", imageClass);
                alarmIcon = ConsoleUtility.loadImageIcon("lf/images/Event_GenericAlarm16.gif", imageClass);
                filterIcon = ConsoleUtility.loadImageIcon("lf/images/Filter16.gif", imageClass);
                columns = new String[]{ResourceManager.getString("Type"), ResourceManager.getString("Severity"), ResourceManager.getString("Time"), ResourceManager.getString("Source"), ResourceManager.getString("Message")};
            }
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VEventViewer.this.cancelAction();
                }
            });
            this.getButtonPane().add(this.closeButton);
            this.eventInfo = new EventInfo();
            this.getHelpPane().removeAll();
            this.getHelpPane().setLayout(new BorderLayout());
            this.getHelpPane().add((Component)this.eventInfo, "Center");
            this.toggleContentTitle(false);
            AbstractTableModel abstractTableModel = new AbstractTableModel(){

                public Class getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                public int getColumnCount() {
                    return columns.length;
                }

                public String getColumnName(int n) {
                    return columns[n];
                }

                public int getRowCount() {
                    switch (VEventViewer.this.filterID) {
                        case 0: 
                        case 1: {
                            return VEventViewer.this.eventLog.size();
                        }
                        case 2: {
                            return VEventViewer.this.numEvInfo;
                        }
                        case 3: {
                            return VEventViewer.this.numEvWarn;
                        }
                        case 4: {
                            return VEventViewer.this.numEvErr;
                        }
                        case 5: {
                            return VEventViewer.this.numAlarms;
                        }
                        case 6: {
                            return VEventViewer.this.numAlIndt;
                        }
                        case 7: {
                            return VEventViewer.this.numAlWarn;
                        }
                        case 8: {
                            return VEventViewer.this.numAlMinr;
                        }
                        case 9: {
                            return VEventViewer.this.numAlMajr;
                        }
                        case 10: {
                            return VEventViewer.this.numAlCrtc;
                        }
                    }
                    return 0;
                }

                public Object getValueAt(int n, int n2) {
                    return VEventViewer.this.getFilteredEvent(n);
                }

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                public void setValueAt(Object object, int n, int n2) {
                }
            };
            int[] nArray = new int[]{100, 150, 300, 300, 600};
            this.eventTable = new JTable(abstractTableModel){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    super.valueChanged(listSelectionEvent);
                    if (listSelectionEvent == null) {
                        return;
                    }
                    try {
                        VEventViewer.this.reflectSelection(super.getSelectedRow());
                    }
                    catch (Throwable throwable) {}
                }
            };
            this.eventTable.setBackground(Color.white);
            this.eventTable.setShowGrid(false);
            this.eventTable.getTableHeader().setReorderingAllowed(false);
            this.eventTable.getSelectionModel().setSelectionMode(0);
            this.eventTable.setColumnSelectionAllowed(false);
            VStyledTableHeaderRenderer vStyledTableHeaderRenderer = new VStyledTableHeaderRenderer();
            vStyledTableHeaderRenderer.setHorizontalAlignment(2);
            TableColumnModel tableColumnModel = this.eventTable.getColumnModel();
            EventRenderer eventRenderer = new EventRenderer();
            if (tableColumnModel != null) {
                int n = 0;
                while (n < tableColumnModel.getColumnCount()) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n);
                    tableColumn.setCellRenderer(eventRenderer);
                    tableColumn.setPreferredWidth(nArray[n]);
                    tableColumn.setHeaderRenderer(vStyledTableHeaderRenderer);
                    ++n;
                }
            }
            this.scroller = new VScrollPane();
            this.scroller.setViewportView(this.eventTable);
            this.scroller.getViewport().setBackground(Color.white);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(Color.white);
            jPanel.add((Component)this.scroller, "Center");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().setBorder(new EmptyBorder(5, 10, 0, 5));
            this.getContentPane().add((Component)jPanel, "Center");
            this.installStrings();
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        Object object;
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.logevent")) {
            Object object2 = vConsoleEvent.getPayload();
            if (object2 != null && object2 instanceof VLogEvent) {
                this.eventLog.addElement((VLogEvent)object2);
                this.modifyCount((VLogEvent)object2);
                this.tableChanged();
            }
        } else if (string.equals("vconsole.logalarm")) {
            Object object3 = vConsoleEvent.getPayload();
            if (object3 != null && object3 instanceof VLogAlarm) {
                this.eventLog.addElement((VLogEvent)object3);
                this.modifyCount((VLogEvent)object3);
                this.tableChanged();
            }
        } else if (string.equals("vconsole.clearlogalarm") && (object = vConsoleEvent.getPayload()) != null && object instanceof VLogEvent && this.eventLog.contains(object)) {
            this.eventLog.remove(object);
            this.modifyCount((VLogEvent)object);
            this.tableChanged();
        }
    }

    protected void displayThrowable(VLogEvent vLogEvent) {
        if (vLogEvent == null || vLogEvent.getThrowable() == null) {
            return;
        }
        ThrowableInfo throwableInfo = new ThrowableInfo(vLogEvent);
        VFrame vFrame = new VFrame(ResourceManager.getString("Java Exception Trace"));
        vFrame.setComponent(throwableInfo);
        ((Component)vFrame).setSize(400, 200);
        vFrame.showCenter(null);
    }

    protected void generateTestEvents() {
        VScopeNode vScopeNode = new VScopeNode();
        vScopeNode.setText("test node");
        VLogEvent vLogEvent = new VLogEvent(this, 20, new Date(), "Warning Test", "Testing the Warning event", "Description of the test warning event", null, vScopeNode);
        VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.logevent", vLogEvent);
        this.consoleAction(vConsoleEvent);
        vLogEvent = new VLogEvent(this, 30, new Date(), "Error Test", "Testing the error event", "Description of the test error event", null, vScopeNode);
        vConsoleEvent = new VConsoleEvent(this, "vconsole.logevent", vLogEvent);
        this.consoleAction(vConsoleEvent);
        vLogEvent = new VLogAlarm(this, 40, new Date(), "Indt Alarm Test", "Testing the Indeterminate alarm", "Description of the Indeterminate alarm event", null, vScopeNode);
        vConsoleEvent = new VConsoleEvent(this, "vconsole.logevent", vLogEvent);
        this.consoleAction(vConsoleEvent);
        vLogEvent = new VLogAlarm(this, 50, new Date(), "Warn Alarm Test", "Testing the Warn alarm", "Description of the Warn alarm event", null, vScopeNode);
        vConsoleEvent = new VConsoleEvent(this, "vconsole.logevent", vLogEvent);
        this.consoleAction(vConsoleEvent);
        vLogEvent = new VLogAlarm(this, 60, new Date(), "Minor Alarm Test", "Testing the Indeterminate alarm", "Description of the Indeterminate alarm event", null, vScopeNode);
        vConsoleEvent = new VConsoleEvent(this, "vconsole.logevent", vLogEvent);
        this.consoleAction(vConsoleEvent);
        vLogEvent = new VLogAlarm(this, 70, new Date(), "MAJOR Alarm Test", "Testing the Indeterminate alarm", "Description of the Indeterminate alarm event", null, null);
        vConsoleEvent = new VConsoleEvent(this, "vconsole.logevent", vLogEvent);
        this.consoleAction(vConsoleEvent);
        vLogEvent = new VLogAlarm(this, 80, new Date(), "Critical Alarm Test", "Testing the Indeterminate alarm", "Description of the Indeterminate alarm event", null, vScopeNode);
        vConsoleEvent = new VConsoleEvent(this, "vconsole.logevent", vLogEvent);
        this.consoleAction(vConsoleEvent);
    }

    protected VLogEvent getFilteredAlarm(int n, int n2) {
        try {
            int n3 = -1;
            int n4 = 0;
            VLogEvent vLogEvent = null;
            while (n3 != n) {
                if ((vLogEvent = (VLogEvent)this.eventLog.elementAt(n4++)) instanceof VLogAlarm && (n2 == -1 || ((VLogAlarm)vLogEvent).getSeverity() == n2)) {
                    ++n3;
                }
                if (n3 <= this.eventLog.size() && n4 <= this.eventLog.size()) continue;
                return null;
            }
            return vLogEvent;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected VLogEvent getFilteredEvent(int n) {
        switch (this.filterID) {
            case 0: 
            case 1: {
                return (VLogEvent)this.eventLog.elementAt(n);
            }
            case 2: {
                return this.getFilteredEvent(n, 10);
            }
            case 3: {
                return this.getFilteredEvent(n, 20);
            }
            case 4: {
                return this.getFilteredEvent(n, 30);
            }
            case 5: {
                return this.getFilteredAlarm(n, -1);
            }
            case 6: {
                return this.getFilteredAlarm(n, 40);
            }
            case 7: {
                return this.getFilteredAlarm(n, 50);
            }
            case 8: {
                return this.getFilteredAlarm(n, 60);
            }
            case 9: {
                return this.getFilteredAlarm(n, 70);
            }
            case 10: {
                return this.getFilteredAlarm(n, 80);
            }
        }
        return null;
    }

    protected VLogEvent getFilteredEvent(int n, int n2) {
        try {
            int n3 = -1;
            int n4 = 0;
            VLogEvent vLogEvent = null;
            while (n3 != n) {
                if ((vLogEvent = (VLogEvent)this.eventLog.elementAt(n4++)).getType() == n2) {
                    ++n3;
                }
                if (n3 <= this.eventLog.size() && n4 <= this.eventLog.size()) continue;
                return null;
            }
            return vLogEvent;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public ImageIcon getIconForEvent(VLogEvent vLogEvent) {
        if (vLogEvent == null) {
            return null;
        }
        if (vLogEvent instanceof VLogAlarm) {
            VLogAlarm vLogAlarm = (VLogAlarm)vLogEvent;
            int n = vLogAlarm.getSeverity();
            if (n == 40) {
                return indtSvrty;
            }
            if (n == 50) {
                return warnSvrty;
            }
            if (n == 60) {
                return minrSvrty;
            }
            if (n == 70) {
                return majrSvrty;
            }
            return crtcSvrty;
        }
        int n = vLogEvent.getType();
        if (n == 10) {
            return infoType;
        }
        if (n == 20) {
            return warnType;
        }
        return errType;
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    protected void installStrings() {
        this.closeButton.setText(ResourceManager.getString("CLOSE_BUTTON"));
        this.closeButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("CLOSE_BUTTON_access_name"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("CLOSE_BUTTON_access_desc"));
        this.defaultSrc = ResourceManager.getString("Console");
        super.setTitle(ResourceManager.getString("Console Log"));
        this.filterStr = ResourceManager.getString("FILTERED VIEW");
        if (this.linkButton != null) {
            this.linkButton.setText(ResourceManager.getString("See Exception"));
        }
        columns = new String[]{ResourceManager.getString("Type"), ResourceManager.getString("Severity"), ResourceManager.getString("Time"), ResourceManager.getString("Source"), ResourceManager.getString("Message")};
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(true);
        VDialog vDialog = new VDialog(new VFrame(), "Log Viewer", true);
        VEventViewer vEventViewer = new VEventViewer();
        vEventViewer.setContainer(vDialog);
        vEventViewer.showCenter(null);
        System.exit(0);
    }

    protected void modifyCount(VLogEvent vLogEvent) {
        if (vLogEvent == null) {
            return;
        }
        if (vLogEvent instanceof VLogAlarm) {
            VLogAlarm vLogAlarm = (VLogAlarm)vLogEvent;
            ++this.numAlarms;
            int n = vLogAlarm.getSeverity();
            if (n == 40) {
                ++this.numAlIndt;
            } else if (n == 50) {
                ++this.numAlWarn;
            } else if (n == 60) {
                ++this.numAlMinr;
            } else if (n == 70) {
                ++this.numAlMajr;
            } else {
                ++this.numAlCrtc;
            }
            return;
        }
        int n = vLogEvent.getType();
        if (n == 10) {
            ++this.numEvInfo;
        } else if (n == 20) {
            ++this.numEvWarn;
        } else {
            ++this.numEvErr;
        }
    }

    public void reflectSelection(int n) {
        try {
            VLogEvent vLogEvent = this.getFilteredEvent(n);
            this.eventInfo.setSelectedEvent(vLogEvent);
        }
        catch (Exception exception) {}
    }

    public void setFilterID(int n) {
        this.filterID = n >= 0 && n <= 10 ? n : 0;
        if (this.filterID == 0 || this.filterID == 1) {
            this.scroller.setFiltered(false);
        } else {
            this.scroller.setFiltered(true);
        }
        if (this.eventTable != null) {
            this.eventTable.clearSelection();
        }
        this.eventInfo.setSelectedEvent(null);
        this.tableChanged();
        this.validate();
        this.repaint();
    }

    protected void tableChanged() {
        if (this.eventTable == null) {
            return;
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this.eventTable.getModel());
        this.eventTable.tableChanged(tableModelEvent);
    }

    class ThrowableInfo
    extends JPanel {
        public ThrowableInfo(VLogEvent vLogEvent) {
            this.setLayout(new BorderLayout());
            this.setBackground(Color.white);
            JLabel jLabel = new JLabel();
            jLabel.setText(String.valueOf(vLogEvent.getTitle()) + " : " + vLogEvent.getMessage());
            jLabel.setIcon(VEventViewer.this.getIconForEvent(vLogEvent));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalGlue());
            this.add((Component)jPanel, "North");
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.setWrapStyleWord(false);
            try {
                Throwable throwable = vLogEvent.getThrowable();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
                String string = byteArrayOutputStream.toString();
                jTextArea.setText(string);
            }
            catch (Throwable throwable) {}
            this.add((Component)new JScrollPane(jTextArea), "Center");
            this.validate();
            this.repaint();
        }
    }

    class EventInfo
    extends JPanel {
        protected VLogEvent event = null;
        protected JLabel titleLabel = null;
        protected JTextArea descArea = null;
        protected JPanel showThrowPanel = null;
        protected JPanel throwPanel = null;

        public EventInfo() {
            this.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(0, 5, 5, 5));
            try {
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setEditable(false);
                jEditorPane.setEditorKitForContentType("text/html", new VHTMLEditorKit());
                jEditorPane.setContentType("text/html");
                String string = ResourceManager.getString("EventViewerHelp");
                string = ContextHelpLoader.getContextHelp(string, ResourceManager.currentLocale);
                if (string != null) {
                    jEditorPane.setText(string);
                }
                VEventViewer.this.hLinkListener.setEditorPane(jEditorPane);
                jEditorPane.addHyperlinkListener(VEventViewer.this.hLinkListener);
                JScrollPane jScrollPane = new JScrollPane();
                Dimension dimension = new Dimension(200, 300);
                jScrollPane.setMinimumSize(dimension);
                jScrollPane.setPreferredSize(dimension);
                jScrollPane.setMaximumSize(dimension);
                jScrollPane.setViewportView(jEditorPane);
                jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.add((Component)jScrollPane, "North");
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                jPanel.setBackground(Color.white);
                JPanel jPanel2 = new JPanel(){

                    public Dimension getMaximumSize() {
                        return new Dimension(super.getMaximumSize().width, 4);
                    }

                    public Dimension getMinimumSize() {
                        return new Dimension(super.getMinimumSize().width, 4);
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width, 4);
                    }

                    public void paint(Graphics graphics) {
                        Dimension dimension = this.getSize();
                        graphics.setColor(ResourceManager.sunBlue);
                        graphics.fillRect(0, 0, dimension.width - 100, 2);
                        graphics.setColor(Color.lightGray);
                        graphics.fillRect(0, dimension.height - 2, dimension.width - 8 - 100, dimension.height - 1);
                    }
                };
                jPanel.add(Box.createVerticalStrut(2));
                jPanel.add(jPanel2);
                jPanel.add(Box.createVerticalStrut(10));
                this.titleLabel = new JLabel();
                JPanel jPanel3 = new JPanel();
                jPanel3.setBackground(Color.white);
                jPanel3.setBorder(new EmptyBorder(0, 0, 0, 0));
                jPanel3.setLayout(new FlowLayout(0));
                jPanel3.add(this.titleLabel);
                jPanel.add(jPanel3);
                jPanel.add(Box.createVerticalStrut(10));
                this.descArea = new JTextArea();
                this.descArea.setLineWrap(true);
                this.descArea.setWrapStyleWord(true);
                this.descArea.setEditable(false);
                this.descArea.setBorder(new EmptyBorder(0, 4, 0, 4));
                JPanel jPanel4 = new JPanel();
                jPanel4.setBorder(new EmptyBorder(0, 0, 0, 0));
                jPanel4.setBackground(Color.white);
                jPanel4.setLayout(new BorderLayout());
                jPanel4.add((Component)this.descArea, "Center");
                jPanel.add(jPanel4);
                this.throwPanel = new JPanel();
                this.throwPanel.setBackground(Color.white);
                this.throwPanel.setLayout(new BorderLayout());
                jPanel.add(Box.createVerticalStrut(10));
                jPanel.add(this.throwPanel);
                jPanel.add(Box.createVerticalGlue());
                this.add((Component)jPanel, "Center");
                this.showThrowPanel = new JPanel();
                this.showThrowPanel.setBackground(Color.white);
                VEventViewer.this.linkButton = new VHyperLinkButton(ResourceManager.getString("See Exception"));
                VEventViewer.this.linkButton.setFont(ResourceManager.menuFont);
                VEventViewer.this.linkButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ EventInfo this$1;
                    {
                        this.this$1 = eventInfo;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        EventInfo.access$0(this.this$1).displayThrowable(this.this$1.event);
                    }
                });
                this.showThrowPanel.setLayout(new BoxLayout(this.showThrowPanel, 0));
                this.showThrowPanel.add(VEventViewer.this.linkButton);
            }
            catch (Throwable throwable) {
                Debug.trace("EventViewer", Debug.WARNING, "Unexpected Exception", throwable);
            }
        }

        static /* synthetic */ VEventViewer access$0(EventInfo eventInfo) {
            return eventInfo.VEventViewer.this;
        }

        public void setSelectedEvent(VLogEvent vLogEvent) {
            this.event = vLogEvent;
            if (vLogEvent != null) {
                this.titleLabel.setText(vLogEvent.getTitle());
                this.titleLabel.setIcon(VEventViewer.this.getIconForEvent(vLogEvent));
                this.descArea.setText(vLogEvent.getDescription());
                this.throwPanel.remove(this.showThrowPanel);
                if (vLogEvent.getThrowable() != null) {
                    this.throwPanel.add((Component)this.showThrowPanel, "North");
                }
            } else {
                this.titleLabel.setText("");
                this.titleLabel.setIcon(null);
                this.descArea.setText("");
                this.throwPanel.removeAll();
            }
            this.validate();
            this.repaint();
        }
    }

    class EventRenderer
    extends VHyperLinkButton
    implements TableCellRenderer {
        protected Color unselectedForeground = Color.black;
        protected Color unselectedBackground = Color.white;

        public EventRenderer() {
            super((String)null);
            this.setHyperLinkOn(false);
            VEventViewer.this.defaultSrc = ResourceManager.getString("Console");
            this.setContentAreaFilled(true);
            this.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(null);
            this.setIcon(null);
            this.setHorizontalAlignment(2);
            this.setHyperLinkOn(false);
            if (object != null) {
                VLogEvent vLogEvent = (VLogEvent)object;
                switch (n2) {
                    case 0: {
                        int n3 = vLogEvent.getType();
                        this.setHorizontalAlignment(0);
                        if (vLogEvent instanceof VLogAlarm) {
                            this.setIcon(alarmIcon);
                            break;
                        }
                        this.setIcon(VEventViewer.this.getIconForEvent(vLogEvent));
                        break;
                    }
                    case 1: {
                        if (vLogEvent instanceof VLogAlarm) {
                            this.setIcon(VEventViewer.this.getIconForEvent(vLogEvent));
                        }
                        this.setHorizontalAlignment(0);
                        break;
                    }
                    case 2: {
                        this.setText(dateFormatter.format(vLogEvent.getTimeStamp()));
                        break;
                    }
                    case 3: {
                        VScopeNode vScopeNode = vLogEvent.getSourceNode();
                        if (vScopeNode != null) {
                            this.setText(vScopeNode.getText());
                            this.setHyperLinkOn(true);
                            break;
                        }
                        this.setText(VEventViewer.this.defaultSrc);
                        break;
                    }
                    case 4: {
                        this.setText(vLogEvent.getMessage());
                        break;
                    }
                }
            }
            if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
                super.setOpaque(true);
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
                super.setOpaque(false);
            }
            return this;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.unselectedBackground = color;
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            this.unselectedForeground = color;
        }
    }
}

