/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console;

import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleLF;
import com.sun.management.viper.console.VConsoleManager;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.UndoRedoStack;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;

public abstract class VConsole
implements Tool,
PropertyChangeListener,
VConsoleActionListener {
    protected static Vector consoleSet = null;
    protected ToolInfrastructure toolInf = null;
    protected ToolContext context = null;
    protected Vector listeners = null;
    protected VConsoleManager consoleManager = null;
    protected VConsoleProperties properties = null;
    protected VConsoleModel dataModel = null;
    protected VConsoleLF currentLF = null;
    protected VScopeNode exposedNode = null;
    protected UndoRedoStack nextBackStack = null;
    protected VScopeNode currSel = null;
    protected Tool currentTool = null;

    public VConsole() {
        if (consoleSet == null) {
            consoleSet = new Vector(1);
        }
        consoleSet.addElement(this);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(vConsoleActionListener)) {
            this.listeners.addElement(vConsoleActionListener);
        }
    }

    protected void closeConsole() {
        try {
            this.shutdownAndDestroyManager();
            if (this.properties != null) {
                this.properties.storeUserPreferences();
            }
            if (consoleSet != null) {
                consoleSet.remove(this);
            }
            if (consoleSet.size() == 0) {
                System.exit(0);
            }
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Throwable in VConsole.closeConsole()", throwable);
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        try {
            String string = vConsoleEvent.getID();
            if (string.equals("vconsole.newconsole")) {
                Object object = vConsoleEvent.getPayload();
                if (object instanceof VScopeNode) {
                    this.newConsole((VScopeNode)object);
                } else {
                    this.newConsole(null);
                }
            } else if (string.equals("vconsole.openconsole")) {
                Object object = vConsoleEvent.getPayload();
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.openConsole(string2);
                } else if (object instanceof VScopeNode) {
                    VScopeNode vScopeNode = (VScopeNode)object;
                    this.openConsole(vScopeNode);
                } else {
                    this.openConsole((String)null);
                }
            } else if (string.equals("vconsole.closeconsole")) {
                this.closeConsole();
            } else if (string.equals("vconsole.saveconsole")) {
                this.saveConsole();
            } else if (string.equals("vconsole.saveconsoleas")) {
                this.saveConsoleAs();
            } else if (string.equals("vconsole.modifyconfig")) {
                this.editConsole();
            } else if (string.equals("vconsole.exitconsole")) {
                this.exitConsole();
            } else if (string.equals("vconsole.showhelpindex")) {
                this.showHelpIndex();
            } else if (string.equals("vconsole.showhelpabout")) {
                this.showAboutInfo();
            } else if (string.equals("vconsole.showhelpsearch")) {
                this.showHelpSearch();
            } else if (string.equals("vconsole.showhelptoc")) {
                this.showHelpTOC();
            } else if (string.equals("vconsole.showhelpoverview")) {
                this.showHelpOverview();
            } else if (string.equals("vconsole.hyperlinkevent")) {
                this.showHelpViewer();
                this.notifyListeners(vConsoleEvent);
            } else if (string.equals("vconsole.scopeselected")) {
                this.stopTool(this.currentTool);
                this.currSel = (VScopeNode)vConsoleEvent.getPayload();
                this.nextBackStack.addItem(this.currSel);
                this.updateNextBack();
                this.notifyListeners(vConsoleEvent);
                if (this.currSel != null) {
                    this.startTool(this.currSel.getTool());
                }
            } else if (string.equals("vconsole.scopechildopened")) {
                VScopeNode vScopeNode = (VScopeNode)vConsoleEvent.getPayload();
                if (vScopeNode.getTool() != null) {
                    this.stopTool(this.currentTool);
                    this.startTool(vScopeNode.getTool());
                } else {
                    this.notifyListeners(vConsoleEvent);
                }
            } else if (string.equals("vconsole.previousscope")) {
                if (!this.nextBackStack.canUndo()) {
                    return;
                }
                VScopeNode vScopeNode = (VScopeNode)this.nextBackStack.getUndoItem();
                this.consoleAction(new VConsoleEvent(this, "vconsole.scopeselected", vScopeNode));
            } else if (string.equals("vconsole.nextscope")) {
                if (!this.nextBackStack.canRedo()) {
                    return;
                }
                VScopeNode vScopeNode = (VScopeNode)this.nextBackStack.getRedoItem();
                this.consoleAction(new VConsoleEvent(this, "vconsole.scopeselected", vScopeNode));
            } else {
                this.notifyListeners(vConsoleEvent);
            }
        }
        catch (Throwable throwable) {
            Debug.trace("VConsole", Debug.WARNING, "Unexpected exception.", throwable);
        }
    }

    public void destroy() throws CriticalStopException {
        this.closeConsole();
    }

    protected void editConsole() {
        try {
            if (this.consoleManager != null) {
                this.consoleManager.editConsole();
            }
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Throwable in VConsole.editConsole()", throwable);
        }
    }

    protected void exitConsole() {
        int n = 0;
        if (consoleSet != null && consoleSet.size() > 1) {
            n = this.promptUserToExitAllConsoles();
        }
        if (n == 0) {
            if (consoleSet != null) {
                int n2;
                int n3 = n2 = consoleSet.size() - 1;
                while (n3 >= 0) {
                    try {
                        Object e = consoleSet.elementAt(n3);
                        ((VConsole)e).closeConsole();
                    }
                    catch (Throwable throwable) {}
                    --n3;
                }
            }
            System.exit(0);
        }
    }

    public VConsoleLF getLookAndFeel() {
        return this.currentLF;
    }

    protected VConsoleModel getModel() {
        return this.dataModel;
    }

    public VScopeNode getScopeNode() {
        this.exposedNode = new VScopeNode();
        this.exposedNode.setTool(this);
        this.exposedNode.setText("VConsole");
        return this.exposedNode;
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.toolInf = toolInfrastructure;
        this.initProperties();
        this.initManager();
    }

    protected void initManager() {
        if (this.consoleManager != null) {
            this.consoleManager.init(this, this.toolInf);
        }
    }

    protected void initProperties() {
        this.setProperties(VConsoleProperties.newInstance());
    }

    protected abstract void newConsole(VScopeNode var1);

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            try {
                Object e = this.listeners.elementAt(n);
                ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            }
            catch (Throwable throwable) {
                Debug.trace("Console", Debug.WARNING, "Throwable in VConsole.notifyListeners()", throwable);
            }
            ++n;
        }
    }

    protected void openConsole(VScopeNode vScopeNode) {
        try {
            VConsoleModel vConsoleModel = new VConsoleModel(vScopeNode);
            this.setModel(vConsoleModel);
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Throwable in VConsole.openConsole()", throwable);
        }
    }

    protected void openConsole(String string) {
        try {
            this.consoleManager.openConsole(string);
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Throwable in VConsole.openConsole()", throwable);
        }
    }

    protected abstract int promptUserToExitAllConsoles();

    public abstract void propertyChange(PropertyChangeEvent var1);

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    protected void saveConsole() {
        try {
            if (this.consoleManager != null) {
                this.consoleManager.saveConsole();
            }
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Throwable in VConsole.saveConsole()", throwable);
        }
    }

    protected void saveConsoleAs() {
        try {
            if (this.consoleManager != null) {
                this.consoleManager.saveConsoleAs();
            }
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Throwable in VConsole.saveConsoleAs()", throwable);
        }
    }

    protected void setLookAndFeel(VConsoleLF vConsoleLF) {
        if (vConsoleLF != null) {
            if (this.currentLF != null) {
                this.currentLF.setEnabled(false);
            }
            this.currentLF = vConsoleLF;
            if (!this.currentLF.isInitialized()) {
                this.currentLF.setProperties(this.properties);
                this.currentLF.addConsoleActionListener(this);
                this.addConsoleActionListener(this.currentLF);
                this.currentLF.setInitialized(true);
            }
            this.currentLF.setEnabled(true);
        }
    }

    public void setModel(VConsoleModel vConsoleModel) {
        try {
            VConsoleEvent vConsoleEvent;
            this.dataModel = vConsoleModel;
            if (this.exposedNode != null) {
                try {
                    this.exposedNode.add((VScopeNode)vConsoleModel.getRoot());
                    vConsoleEvent = new VConsoleEvent(this, "vconsole.updatescope", this.exposedNode);
                    this.notifyListeners(vConsoleEvent);
                }
                catch (Throwable throwable) {
                    Debug.trace("Console", Debug.WARNING, "Could not combine model withexposed node", throwable);
                }
            }
            this.nextBackStack = new UndoRedoStack();
            this.properties.setProperty("vconsole.undoenabled", "false");
            this.properties.setProperty("vconsole.redoenabled", "false");
            this.properties.setProperty("vconsole.nextenabled", "false");
            this.properties.setProperty("vconsole.backenabled", "false");
            if (this.currentLF != null) {
                this.currentLF.setModel(vConsoleModel);
            }
            vConsoleEvent = new VConsoleEvent(this, "vconsole.scopeselected", null);
            this.notifyListeners(vConsoleEvent);
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Problem setting model", throwable);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.properties = vConsoleProperties;
            vConsoleProperties.addPropertyChangeListener(this);
            if (this.consoleManager != null) {
                this.consoleManager.setProperties(vConsoleProperties);
            }
        }
    }

    public void setToolContext(ToolContext toolContext) {
        this.context = toolContext;
    }

    protected abstract void showAboutInfo();

    protected abstract void showHelpIndex();

    protected abstract void showHelpOverview();

    protected abstract void showHelpSearch();

    protected abstract void showHelpTOC();

    protected abstract void showHelpViewer();

    protected void shutdownAndDestroyManager() {
        if (this.consoleManager != null) {
            this.consoleManager.shutDown();
            this.consoleManager.destroy();
        }
    }

    public void start() throws CriticalStopException {
        if (this.dataModel == null) {
            this.openConsole((String)null);
        }
    }

    protected void startTool(Tool tool) {
        try {
            if (this.currSel == null) {
                return;
            }
            if (tool != null) {
                Debug.trace("MainConsole", Debug.INFORMATION, "Calling Start() on " + this.currSel.getText(), null);
                tool.start();
                this.currentTool = tool;
            } else {
                Component component = this.currSel.getResultPane();
                if (component == null) {
                    return;
                }
                if (component != null && component instanceof Tool) {
                    Debug.trace("MainConsole", Debug.INFORMATION, "Calling Start() on " + this.currSel.getText(), null);
                    ((Tool)((Object)component)).start();
                    this.currentTool = (Tool)((Object)component);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.ERROR, "Problem starting Tool", throwable);
        }
    }

    public void stop() throws CriticalStopException {
    }

    protected void stopTool(Tool tool) {
        try {
            if (this.currSel == null) {
                return;
            }
            if (tool != null) {
                Debug.trace("MainConsole", Debug.INFORMATION, "Calling Stop() on " + this.currSel.getText(), null);
                tool.stop();
                this.currentTool = null;
            } else {
                Component component = this.currSel.getResultPane();
                if (component != null && component instanceof Tool) {
                    Debug.trace("MainConsole", Debug.INFORMATION, "Calling Stop() on " + this.currSel.getText(), null);
                    ((Tool)((Object)component)).stop();
                    this.currentTool = null;
                }
            }
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.ERROR, "Problem stopping Tool", throwable);
        }
    }

    protected void updateNextBack() {
        try {
            if (this.nextBackStack.canUndo()) {
                this.properties.setProperty("vconsole.backenabled", "true");
            } else {
                this.properties.setProperty("vconsole.backenabled", "false");
            }
            if (this.nextBackStack.canRedo()) {
                this.properties.setProperty("vconsole.nextenabled", "true");
            } else {
                this.properties.setProperty("vconsole.nextenabled", "false");
            }
        }
        catch (Throwable throwable) {
            Debug.trace("VConsole", Debug.WARNING, "Unexpected exception.", throwable);
        }
    }
}

