/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper;

import com.sun.management.viper.AdminClientException;
import com.sun.management.viper.VException;
import com.sun.management.viper.util.ResourceManager;
import java.io.Serializable;
import java.util.StringTokenizer;

public class AdminMgmtScope
implements Cloneable,
Serializable {
    public static final String ADM_SCOPE_SYSTEM = "file";
    public static final String ADM_SCOPE_NIS = "nis";
    public static final String ADM_SCOPE_NISPLUS = "nisplus";
    public static final String ADM_SCOPE_DNS = "dns";
    public static final String ADM_SCOPE_LDAP = "ldap";
    public static final String ADM_SCOPE_SET = "set";
    public static final String[] ALL_SCOPES = new String[]{"file", "nis", "nisplus", "dns", "ldap", "set"};
    protected static final String[] type_show = new String[]{"LG_server", "LG_nis", "LG_nis+", "LG_dns", "LG_ldap", "LG_set"};
    protected String scopetype = null;
    protected String scopename = null;
    protected String servername = null;
    protected String domainname = null;
    protected int serverport = -1;
    protected AdminMgmtScope[] scopeSet = null;

    public AdminMgmtScope(String string, String string2) throws VException {
        String string3;
        String string4;
        String string5;
        if (string2 == null || string2.trim().length() == 0) {
            throw new AdminClientException("EXM_BMS");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/", true);
        try {
            string5 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new AdminClientException("EXM_BMS");
        }
        this.scopetype = this.checkScopeType(string5);
        if (this.scopetype == null) {
            throw new AdminClientException("EXM_BMS");
        }
        try {
            string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new AdminClientException("EXM_BMS");
        }
        if (!string4.equals(":") || !string3.equals("/")) {
            throw new AdminClientException("EXM_BMS");
        }
        try {
            this.servername = stringTokenizer.nextToken();
            this.parsePortFromServer();
            string4 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new AdminClientException("EXM_MSS");
        }
        if (!string4.equals("/")) {
            throw new AdminClientException("EXM_BMS");
        }
        try {
            this.domainname = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            this.domainname = null;
        }
        if (this.domainname == null ? !this.scopetype.equals(ADM_SCOPE_SYSTEM) : this.scopetype.equals(ADM_SCOPE_SYSTEM) && !this.servername.equals(this.domainname)) {
            throw new AdminClientException("EXM_BMS");
        }
        this.scopename = string;
        if (this.scopename == null || this.scopename.trim().length() == 0) {
            this.scopename = this.defaultName();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AdminMgmtScope(String string, String string2, String string3, String string4) throws VException {
        this.scopetype = this.checkScopeType(string);
        if (this.scopetype == null) {
            throw new AdminClientException("EXM_BMS");
        }
        this.servername = string3;
        this.parsePortFromServer();
        if (this.servername == null || this.servername.trim().length() == 0) {
            throw new AdminClientException("EXM_BMS");
        }
        this.domainname = string4;
        if (this.domainname == null || this.domainname.trim().length() == 0) {
            if (!this.scopetype.equals(ADM_SCOPE_SYSTEM)) throw new AdminClientException("EXM_BMS");
            this.domainname = this.servername;
        } else if (this.scopetype.equals(ADM_SCOPE_SYSTEM) && !this.servername.equals(this.domainname)) {
            throw new AdminClientException("EXM_BMS");
        }
        this.scopename = string2;
        if (this.scopename != null && this.scopename.trim().length() != 0) return;
        this.scopename = this.defaultName();
    }

    public AdminMgmtScope(String string, AdminMgmtScope[] adminMgmtScopeArray) throws VException {
        this.scopetype = ADM_SCOPE_SET;
        this.scopename = string;
        if (this.scopename == null || this.scopename.trim().length() == 0) {
            this.scopename = this.defaultName();
        }
        this.scopeSet = adminMgmtScopeArray;
    }

    protected String checkScopeType(String string) {
        if (string != null) {
            int n = 0;
            while (n < ALL_SCOPES.length) {
                if (string.equals(ALL_SCOPES[n])) {
                    return string;
                }
                ++n;
            }
        }
        return null;
    }

    public static boolean compareServerHostNames(String string, String string2) {
        boolean bl = false;
        int n = string.indexOf(46);
        int n2 = string2.indexOf(46);
        bl = n > 0 ? (n2 > 0 ? string.equals(string2) : string2.equals(string.substring(0, n))) : (n2 > 0 ? string.equals(string2.substring(0, n2)) : string.equals(string2));
        return bl;
    }

    protected String defaultName() {
        String string;
        String string2 = this.servername.replace('.', '_');
        if (this.scopetype.equals(ADM_SCOPE_SYSTEM)) {
            string = "server-" + string2;
        } else {
            string = this.domainname.replace('.', '_');
            string = String.valueOf(this.scopetype) + "-" + string + "-" + string2;
        }
        return string;
    }

    public boolean equals(AdminMgmtScope adminMgmtScope) throws VException {
        boolean bl = false;
        if (adminMgmtScope != null) {
            String string = adminMgmtScope.getMgmtScopeType();
            String string2 = adminMgmtScope.getMgmtServerNameWithPort();
            String string3 = adminMgmtScope.getMgmtDomainName();
            bl = this.isEqual(string, string2, string3);
        }
        return bl;
    }

    public boolean equals(String string) throws VException {
        boolean bl = false;
        try {
            int n = string.indexOf(58);
            int n2 = string.lastIndexOf(47);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2, n2);
            String string4 = string.substring(n2 + 1);
            bl = this.isEqual(string2, string3, string4);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public String getMgmtDomainName() {
        String string = this.domainname;
        if (string == null) {
            string = this.scopetype == ADM_SCOPE_SYSTEM ? this.servername : this.scopename;
        }
        return string;
    }

    public String getMgmtScopeName() {
        return this.scopename;
    }

    public String getMgmtScopeType() {
        return this.scopetype;
    }

    public String getMgmtServerName() {
        return this.servername;
    }

    public String getMgmtServerNameWithPort() {
        if (this.serverport == -1) {
            return this.servername;
        }
        return String.valueOf(this.servername) + ":" + this.serverport;
    }

    public int getMgmtServerPort() {
        return this.serverport;
    }

    public AdminMgmtScope[] getMgmtSet() {
        return this.scopeSet;
    }

    protected String getShowType() {
        String string = "";
        if (this.scopetype != null) {
            int n = 0;
            while (n < ALL_SCOPES.length) {
                if (this.scopetype.equals(ALL_SCOPES[n])) {
                    string = type_show[n];
                    break;
                }
                ++n;
            }
            if (string.length() > 0) {
                string = ResourceManager.getString(string);
            }
        }
        return string;
    }

    protected boolean isEqual(String string, String string2, String string3) {
        boolean bl = false;
        if (this.scopetype.equals(string)) {
            if (this.scopetype.equals(ADM_SCOPE_SYSTEM)) {
                bl = AdminMgmtScope.compareServerHostNames(this.getMgmtServerNameWithPort(), string2);
            } else {
                String string4 = this.domainname;
                String string5 = string3;
                if (this.scopetype.equals(ADM_SCOPE_NISPLUS)) {
                    if (!string4.endsWith(".")) {
                        string4 = string4.concat(".");
                    }
                    if (!string5.endsWith(".")) {
                        string5 = string5.concat(".");
                    }
                }
                bl = string4.equals(string5);
            }
        }
        return bl;
    }

    public AdminMgmtScope newCopy() throws VException {
        return new AdminMgmtScope(this.scopetype, this.scopename, this.getMgmtServerNameWithPort(), this.domainname);
    }

    protected void parsePortFromServer() {
        if (this.servername == null) {
            return;
        }
        int n = this.servername.indexOf(":");
        if (n == -1) {
            return;
        }
        String string = this.servername.substring(n + 1);
        this.servername = this.servername.substring(0, n);
        try {
            this.serverport = new Integer(string);
        }
        catch (Throwable throwable) {}
    }

    public void setMgmtScopeName(String string) {
        this.scopename = string;
    }

    public String toDirectoryTableURL() {
        String string = String.valueOf(this.scopetype) + ":/" + this.servername;
        if (this.serverport != -1) {
            string = String.valueOf(string) + ":" + this.serverport;
        }
        string = String.valueOf(string) + "/" + this.domainname;
        return string;
    }

    public String toString() {
        String string = this.getShowType();
        string = this.scopetype.equals(ADM_SCOPE_SYSTEM) ? (this.serverport != -1 ? String.valueOf(this.servername) + ":" + this.serverport + string : String.valueOf(this.servername) + string) : (this.serverport != -1 ? String.valueOf(this.domainname) + "-" + this.servername + ":" + this.serverport + string : String.valueOf(this.domainname) + "-" + this.servername + string);
        return string;
    }
}

