Rem
Rem $Header: utlstddw.sql 22-sep-99.13:11:54 rshaikh Exp $
Rem
Rem utlstddw.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      utlstddw.sql - UTL STanDard.sql DoWngrade
Rem
Rem    DESCRIPTION
REM          This script should be run as internal during a downgrade
REM          to a pre-8.1.6 database.  Before the downgraded database
REM          is open, the timestamps in dependency$ and obj$ must 
REM          be changed for standard spec and for all objects that depend
REM          on standard because of the timestamp change that was introduced
REM          in standard in version 8.1.6.  Without doing this, 
REM          tables with type dependencies will cause a hang because
REM          the dependency has become invalid.  If left for long enough,
REM          this will eat all the memory on the system and make a reboot 
REM          necessary.  See bug 994326 for more information.
REM
REM    NOTES:**** IMPORTANT -- THIS MUST BE RUN WHEN DOWNGRADING *****
REM          **** TO A PRE-8.1.6 DATABASE AND BEFOR OPENING THE  *****
REM          **** PRE-8.1.6 DATABASE !!!!!!!!!!!!!!!!!!!!!!!!!!! *****
REM          If this is not run before the pre-8.1.6 database is 
REM          opened and standard.sql is loaded, then all the obj$.status
REM          values will be changed to "5".  Once this happens, it
REM          is very hard to figure out which objects have status "5"
REM          for a good reason, and which have status "5" because
REM          of this problem.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rshaikh     09/22/99 - bug 994326: modify timestamps for standard
Rem    rshaikh     09/22/99 - Created
Rem


alter system flush shared_pool
/

update obj$ set stime = 
	to_date('1996-11-19:00:00:00', 'YYYY-MM-DD:HH24:MI:SS') 
  where name='STANDARD' and  
	type#=9 and
	owner# = (select user# from user$ where name='SYS')
/

update dependency$ set p_timestamp =
	to_date('1996-11-19:00:00:00', 'YYYY-MM-DD:HH24:MI:SS') 
  where p_obj# = (select o.obj# from obj$ o, user$ u where o.owner#=u.user#
           	    and u.name='SYS' and o.name='STANDARD' and o.type#=9)
/

commit
/
