rem 
rem $Header: dbmsotrc.sql 16-apr-99.10:22:44 cchriste Exp $ 
rem 
Rem  Copyright (c) 1995, 1996, 1999 by Oracle Corporation 
Rem    NAME
Rem      dbmsotrc.sql - Oracle Trace interface
Rem    DESCRIPTION
Rem      This file provides client callable interfaces to the Oracle TRACE
Rem      instrumentation within the Oracle7 Server (rdbms).
Rem    RETURNS
Rem 
Rem    NOTES
Rem      Package  dbms_oracle_trace_agent  should only be granted to DBA
Rem      or the Oracle TRACE collection agent.
Rem    MODIFIED   (MM/DD/YY)
Rem     cchriste   04/16/99 -  run prvtotrc.plb
Rem     asurpur    04/09/96 -  Dictionary Protection Implementation
Rem     drady      02/09/95 -  Creation
 

CREATE OR REPLACE PACKAGE dbms_oracle_trace_agent IS
  ------------
  --  OVERVIEW
  --
  --  This package provides some system level utilities.
  --
  --  SECURITY
  --
  --  This package is only accessible to user SYS by default.  You can control
  --  access to these routines by only granting execute to privileged users.
  --
  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  PROCEDURE set_otrace
            ( sid BINARY_INTEGER DEFAULT 0,
              ser BINARY_INTEGER DEFAULT 0,
              evt BINARY_INTEGER DEFAULT 0,
              lvl BINARY_INTEGER DEFAULT 0,
              fdf VARCHAR2 DEFAULT '',
              cdf VARCHAR2 DEFAULT ''
            );
  --  This is an internally used routine that should never be called by users.
  --  The only exception to this is that it is called by the  set_oracle_trace
  --  procedure of the  dbms_oracle_trace_user  package.
  --
  ----------------------------
  PROCEDURE set_oracle_trace_in_session
            ( sid NUMBER DEFAULT 0,
              serial# NUMBER DEFAULT 0,
              on_off IN BOOLEAN  DEFAULT false,
              collection_name IN VARCHAR2 DEFAULT '',
              facility_name IN VARCHAR2 DEFAULT ''
            );
  --  
  --  Enable Oracle TRACE in the session identified by (sid, serial#).  These
  --  value are gotten from v$session. 
  --  Input arguments:
  --   sid  
  --	  session id
  --   serial#
  --      session serial number
  --    on_off
  --      TRUE or FALSE.  Turns tracing on or off.
  --    collection_name
  --      The Oracle TRACE collection name to be used.
  --    facility_name
  --      The Oracle TRACE facility name to be used.
  --
  --
END;
/
grant execute on dbms_oracle_trace_agent to execute_catalog_role
/
--
--
--
CREATE OR REPLACE PACKAGE dbms_oracle_trace_user IS
  ------------
  --  OVERVIEW
  --
  --  This package provides public access to the Oracle7 Server (rdbms)
  --  Oracle TRACE instrumentation for the calling user.
  --
  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  PROCEDURE set_oracle_trace
            ( on_off IN BOOLEAN DEFAULT false,
              collection_name IN VARCHAR2 DEFAULT '',
              facility_name IN VARCHAR2 DEFAULT ''
            );
  --  
  --  Input arguments:
  --    on_off
  --      TRUE or FALSE.  Turns tracing on or off.
  --    collection_name
  --      The Oracle TRACE collection name to be used.
  --    facility_name
  --      The Oracle TRACE facility name to be used.
  --
END dbms_oracle_trace_user;
/

DROP PUBLIC SYNONYM dbms_oracle_trace_user
/
CREATE PUBLIC SYNONYM dbms_oracle_trace_user FOR sys.dbms_oracle_trace_user
/
GRANT EXECUTE ON dbms_oracle_trace_user TO PUBLIC
/
@@prvtotrc.plb
