#
#   File:    agent-stats-d.x
#   Author:  Andrew Hillier
#   Version: 1.20 99/07/07 11:40:18     
#
#   Copyright (c) 1993-1997 Halcyon Inc.
#
#   OpenAgent Agent Statistics Module
#

    [ use MANAGED-MODULE ]
    [ load agent-stats-v2-m.x ]
    [ requires template agent-stats-models-d ]
    [ requires package psinfo ]
    [ requires package gsi ]
    [ requires package kr ]


    consoleHint:mediumDesc = base.modules.agentStats:moduleName
    persistentSlices = [ lookup value agentStatsFile ]

    _filters = { 
	[ use PROC ]
	[ source agent-stats-d.flt ]
    }

    _noopsacs = {

	shadowUserAccess(alarmlimits,%operatorUsers,write)    = "none";
        shadowGroupAccess(alarmlimits,%operatorGroups,write)    = "none";
	shadowUserAccess(alarmlimits,%operatorCommunities,write)    = "none";

    }

    objects = { [ use templates.agent-stats-models-d.objects ]

	type		= active
	initInterval	= 0
	refreshInterval	= 300
	refreshService	= _internal
	refreshCommand	= list [ idcount toe ] [ idcount bob ]

	toeCount = { [ inherit _noopsacs ] }

	bobCount = { [ inherit _noopsacs ] }
    }

    commands = { [ use templates.agent-stats-models-d.commands ]

	type 			= active
        refreshService 		= _internal 
        refreshCommand 		= info cmdcount
	refreshFilter		= intToUnsigned
	initInterval		= 0
	refreshInterval		= 300
	
	rate = { [ inherit _noopsacs ]
	    type		= derived
	    refreshTrigger	= total:update
	    refreshService	= _internal
            refreshCommand     	= decayingLinearFit scalar [ valueOf total.0 ] 
	}
    }

    transactions = { [ use templates.agent-stats-models-d.transactions ]
 
	type			= active
        refreshService     	= _internal
        refreshCommand     	= string range [ idnext tid ] 3 end
	refreshFilter           = intToUnsigned
	initInterval		= 0
	refreshInterval		= 300

        rate = { [ inherit _noopsacs ]
	    type		= derived
	    refreshTrigger	= total:update
            refreshService     	= _internal
            refreshCommand     	= decayingLinearFit scalar [ valueOf total.0 ] 
	}
    }

    procstats = { [ use templates.agent-stats-models-d.procstats ]

	type			= active
	refreshService		= _internal
	refreshCommand		= join [ psinfo [ pid ] ] "\n"
	initInterval		= 0
	refreshInterval		= 300

	size = { [ inherit _noopsacs ]

	    shadowMapping = 9900:warningmsg
 
            shadowGroups(Alarms)    = folder variable rowdesc value units separator \
                                  rules ruledesc separator warningmsg \
                                  alarmlimits ruleparms alarmwindow separator \
                                  ruleparamsdesc blankline factorydef
 
            shadowSpec(warningmsg) = "warningmsg {Warning!} {} string i18ncomment ro scalar"
            shadowDesc(warningmsg) = "Warning!"
            shadowGet(warningmsg) = "list base.modules.agentStats:editAtt.alarmTab.warningmsg"
		alarmRules = ragst100
	}

	rss = { [ inherit _noopsacs ]
            shadowMapping = 9900:warningmsg
 
            shadowGroups(Alarms)    = folder variable rowdesc value units separator \
                                  rules ruledesc separator warningmsg \
                                  alarmlimits ruleparms alarmwindow separator \
                                  ruleparamsdesc blankline factorydef
 
            shadowSpec(warningmsg) = "warningmsg {Warning!} {} string i18ncomment ro scalar"
            shadowDesc(warningmsg) = "Warning!"
            shadowGet(warningmsg) = "list base.modules.agentStats:editAtt.alarmTab.warningmsg"
		alarmRules = ragst101       
        }

        startdatestring = { [ use _filters ]
	    type		= derived
	    refreshTrigger	= starttime:update
	    refreshService	= _internal
	    refreshCommand	= sec2dateFilter [ valueOf starttime ] 
        }

        starttimestring = { [ use _filters ]
	    type		= derived
	    refreshTrigger	= starttime:update
	    refreshService	= _internal
	    refreshCommand	= sec2timeFilter [ valueOf starttime ] 
        }

        pctcputime = { [ use _filters ]
	    type		= derived
	    refreshTrigger	= cputime:update
	    refreshService	= _internal
	    refreshCommand	= pctCpuTimeFilter [ valueOf cputime ] [ valueOf starttime ]
        }
    }    

    totalstats = { [ use templates.agent-stats-models-d.totalstats _filters ]

	type			= active
	refreshService		= _internal
	refreshCommand		= pstree -r [pid] osz rss 
        refreshFilter		= pstotalStats
	initInterval		= 0
	refreshInterval		= 300
        size = {
          alarmRules = ragst102
        }
        rss = {
         alarmRules = ragst103
        }
    }    

    [ load agent-stats-d.def ]
