#
#   File:    base-topology.x
#   Author:  J.M. Heisz, Halcyon Inc. (from the original base-agent.x)
#   Version: 1.19 02/02/05 13:02:36
#   Created: March, 1998
#
#   Copyright (c) 1993-1998 Halcyon Inc.
#
#   OpenAgent Object Instantiation (Topology Agent Component)
#

#
# Create/modify services
#
services = {
    #
    # MIB Manager
    #
    mib = {
	[ requires class mibmanager ]
	[ inherit classes.mibmanager ]

	#
	# load the oid preferences
	#
	oids = {
	    [ requires class persist ]
	    [ inherit classes.persist ]

	    persistentSlices	= value:topology-oids-d.dat

	    [ activate ]
	}
        name2oid = {
            [ requires class mibnode ]
            [ inherit classes.mibnode ]
        }
        oid2name = {
            [ requires class mibnode ]
            [ inherit classes.mibnode ]
        }
        [ construct ]
    }

    #
    # Trap Action Module
    #
    trap = {
	[ requires template base-topology-action-d ]
	[ inherit templates.base-topology-action-d ]

	[ construct ]
    }

    #
    # I/O Services Manager
    # 
    io = {
        #
        # ICMP Stack
        # 
	icmp = {
	    [ requires class icmp ]
	    [ inherit classes.icmp ]

            peer:mel                = [ locate mel ]

	    [ construct ]
	}

        #
        # SNMP Stack
        # 
	snmp = {
	    [ requires class snmp ]
	    [ inherit classes.snmp ]

	    peer:mel		= [ locate mel ]
	    snmpPort		= [ lookup value .config.topology.snmpPort ]

	    #
	    # ping mechanism
	    #
	    pingService		= icmp
	    pingCommand		= ping %host 5

	    #
	    # outgoing SNMP trap destination
	    #
	    trap:host		= [ lookup value .config.trap.trapServer ]
	    trap:port		= [ lookup value .config.trap.snmpPort ]

	    #
	    # outgoing SNMP Event Trap destination
	    #
	    eventTrap:host	= [ lookup value .config.event.eventServer ]
	    eventTrap:port	= [ lookup value .config.event.snmpPort ]

	    #
	    # load the SNMP engine information
	    #
	    engine = {
		[ requires class persist ]
		[ inherit classes.persist ]

		persistentSlices = value:topology-engine-d.dat

		[ activate ]
	    }

	    #
	    # SNMP multiplexor destinations
	    #
	    mux = { [ load base-snmp-mux-d.x ] }

	    #
	    # SNMP oid cache
	    #
	    cache:staticFile	= base-snmp-cache
	    cache:dynamicFile	= topology-snmp-cache
	    cache = {}

	    [ construct ]
	    [ activate ]
	}
    }

    #
    # SNMP Periodic Job Execution Module
    #
    snmp = {
	[ requires class job ]
	[ inherit classes.job ]
 
	callback:target         = [ locate io.snmp ]
	callback:method         = runCommand %ecm %result
 
        notifyInterval          = 3600
        notifyService           = _internal
        notifyCommand           = set %host %port -1 %varbind
 
        #
        # subscribe for only status and refresh traps
        #
	# Leave undefined here and ClassJob will assign it in a generic way.
        #notifyVarbind 		= "{trapOID {^1\\.3\\.6\\.1\\.4\\.1\\.1242\\.1\\.0\\.[12]$}} {expiry 3660}"

	[ construct ]
	[ activate ]
    }


    modquery = {
        [ requires class node ]
        [ inherit classes.node ]
        [ requires template base-topology-action-d ]
        [ inherit templates.base-topology-action-d ]
        [ source base-topology-license.prc]

        type = active
        initInterval = 60
        initHoldoff = 180
        refreshInterval = "Time = 1:00:00"
        refreshService = _internal
        refreshCommand = updateDatabaseModuleList 1

        queryService = .services.io.snmp
        queryCommand = get %agentAddress %agentPort -1 %urls

        peer:io = [ locate services.io ]

        [ construct ]
    }




    #
    # Data Logging Registry
    #
    history = {
        [ requires class historyregistry ]
        [ inherit classes.historyregistry ]

        [ activate ]
    }
}
 

#
# create root of iso tree
#
iso = {
    [ requires class mibnode ]
    [ requires template base-primitives-d ]
    [ requires template base-aliases-d aliases ]

    [ use BRANCH ]

    peer:mib = [ locate services.mib ]
    peer:mel = [ locate services.mel ]
    peer:io = [ locate services.io ]
    peer:history = [ locate services.history ]

    persistentSlices = coreAccess:topology-acls-d.dat

    [ activate ]
}

 
#
# create shadow MIB
#
shadow = { 
    [ use BRANCH ]

    type = shadow
    master = iso
    #oid = 101

    peer:mib = [ locate services.mib ]
    peer:mel = [ locate services.mel ]
    peer:io = [ locate services.io ]
    peer:history = [ locate services.history ]

    [ activate ]
}

#
# create root of context tree
#
contexts = {
 
    peer:mib = [ locate services.mib ]
    peer:mel = [ locate services.mel ]
    peer:io = [ locate services.io ]
    peer:history = [ locate services.history ]
}

#
# rules repository
#
rules = {
}

#
# activate the agent
#
services = {
    mib = {
	[ ddl print info "activating MIB objects\n" ]
	[ activate ]
	[ ddl print info "MIB object activation complete\n" ]
    }
    modquery = {
	[ ddl print info "activating ModQuery object\n" ]
	[ activate ]
	[ ddl print info "ModQuery object activation complete\n" ]
    }
}

