#!/bin/ksh
# Copyright 06/22/99 Sun Microsystems, Inc. All Rights Reserved.
#
# ident  "@(#)eda_configd.ksh  1.14  00/11/08  SMI"

# Wrapper Script to Start Configd.

# Supported Platforms   Package Name  Executable Name  Platform Keyword
# -------------------   ------------  ---------------  ----------------
#  Desktop/Workstation   SUNWeswsa     configddt        Default
#  WorkGroup Server      SUNWeswga     configdWG        Default
#  Netra-t Server        SUNWesnta     configdnt        Default
#  Starfire              NoPackage     configd4u        Ultra-Enterprise-10000
#  Enterprise Server     SUNWsycfd     configd          Ultra-Enterprise:SPARCserver:SPARCcenter
#  Serengeti		 SUNWessda     configd          Default
#

#  where: NoPackage: This is for the case when we have only the binary of 
#		             configd, which will be installed with the SUNWedag 
#                    package under SUNWsymon/addons/AdvancedMonitoring/lib/agent directory.
#         Default: For the case when the platform support list is provided 
#                  by the configd package.

# PKG_LIST format is defined by three different fields delimited by ";".
# Each entry is separated by at least a whitespace character and has the 
# following format: 
#        package_name;executable_name;platform_keyword
#
# The platform_keyword field is delimited by a colon.
# NOTE: No whitespace character is allowed in any field of each enty, since 
#       is being used as a delimitation between entries.

PKG_LIST="SUNWeswsa;configddt;Default \
          SUNWeswga;configdWG;Default \
          SUNWesnta;configdnt;Default \
          NoPackage;configd4u1;Ultra-Enterprise-10000 \
          SUNWsycfd;configd;Ultra-Enterprise:SPARCserver:SPARCcenter \
 	  SUNWessda;configd;Default \
         "
## Some variable definitions
SYMONDIR=/SUNWsymon/bin
if [ $? -eq 0 ]; then
   HDBASEDIR=`pkginfo -r SUNWedag`/SUNWsymon/addons/AdvancedMonitoring
else
   # This part of the code is for the developer environment.
   DIRNAME=`dirname $0`
   HDBASEDIR=`cd $DIRNAME/..;pwd`
   if [ ! -d "$HDBASEDIR/lib" ]; then
      HDBASEDIR=`cd $DIRNAME/../..;pwd`  
   fi
fi
LOGDIR=/var/opt/SUNWhwdiag/logs
ERRFILE=hwdiag.err
TMP_BUF=""
CMD_BUF=""
integer cmd_exist=0
integer no_pkg=0

parse_data() {	
	integer i=0
	OLDIFS=$IFS
	IFS=";"
	for LIST in $1
	do
		DATA[i]=$LIST
		(( i = i + 1 ))
	done
	
	PKG=${DATA[0]}
	BIN=${DATA[1]}
	KEY=${DATA[2]}

	IFS="$OLDIFS"

	return 0
}

check_platform() {
#
#  $1 = list of platforms to check
#
#  Return code of zero means platform check failed (no match)
#
    	PLATFORM_MATCH=""
	
	# We have to make sure that "configd" of SUNWsycfd package is not 
        # being run under Starfire system, because is not compatible with
        # this new system.
	if [ $PKG = "SUNWsycfd" ] && 
	   [ $platdir = "SUNW,Ultra-Enterprise-10000" ]; then
	     return 0
	fi
    	
    	OLDIFS=$IFS
    	IFS=:
    	for each_platform in $1
    	do
	   echo "$PLATFORM_NAME" | /usr/bin/grep "$each_platform" >/dev/null 2>&1
	   if [ $? -eq 0 ] ; then
	      IFS="$OLDIFS"
	      PLATFORM_MATCH="$each_platform"
	      return 1
	   fi
    	done
    	
    	IFS="$OLDIFS"
    	
     	return 0
}

##################################################
##
## Main Entry Point
##
##################################################

## Check the user
edUser=`id | sed 's/uid=[0-9][0-9]*(\(.*\)) gid=.*$/\1/'`
   if [ "$edUser" != "root" ] ; then
       echo "eda_configd.ksh can be executed only by the superuser"
       echo "EXIT"
       exit 1
   fi

## Getting current platform name.
platdir=`/bin/uname -i`
if [ -f /usr/platform/"$platdir"/sbin/prtdiag ] ; then
  prtout=`/usr/platform/"$platdir"/sbin/prtdiag | /usr/bin/head -1 | /usr/bin/cut -f2 -d:`
else
  prtout="$platdir"
fi

integer configd_count=0
DATE=`date '+%m/%d/%y %H:%M:%S'`

# Main for loop for the script
#
for PKG_INFO in $PKG_LIST
do
    # Counting the number of entries in the PKG_LIST variable.
    (( configd_count = configd_count + 1 ))

    # Parse Package List string.
    parse_data $PKG_INFO

    # Check if it has a package
    if [ "$PKG" = "NoPackage" ]; then
        # It doen't have a package name, then get platform list from Platform Keyword.
        PLATFORMLIST=$KEY
        PLATFORM_NAME="$platdir"
        # Checking the platfrom list. 
        if [ -n "$PLATFORMLIST" ] ; then
            check_platform "$PLATFORMLIST"
        fi
  
        # Getting package informations
        TMPCMD="$HDBASEDIR/lib/cfd/$BIN"

        # Getting command informations if the platform is supported.
        if [ -n "$PLATFORM_MATCH" ]; then
            if [ -f $TMPCMD ]; then
                CMD="$HDBASEDIR/lib/cfd/$BIN -f"
                cmd_exist=1
            fi
        else
            # Platform not supported.
            (( no_pkg = no_pkg + 1 ))
            TMP_BUF="$TMP_BUF $BIN"
            CMD_BUF="$CMD_BUF $TMPCMD"
        fi
	 
    else
        # Check if the package is installed or no
        /bin/pkginfo -qi $PKG
        # The package exist
        if [ $? -eq 0 ]; then 
            # Getting the Platform support list
            if [ "$KEY" = "Default" ]; then
                # Getting from the package's ES_ADDON_PLATFORM variable.
                PLATFORMLIST=`/usr/bin/pkgparam $PKG  ES_ADDON_PLATFORM`
                PLATFORM_NAME="$prtout"
            else
                # Getting from Platform Keyword variable.
                PLATFORMLIST=$KEY
                PLATFORM_NAME="$platdir"
            fi

            # Checking the platfrom list. 
            if [ -n "$PLATFORMLIST" ] ; then
                check_platform "$PLATFORMLIST"
            fi
   
            # Getting package informations
            BASEDIR=`/bin/pkgparam $PKG BASEDIR`
            TMPCMD="$BASEDIR$SYMONDIR/$BIN"

            # Getting command informations if the platform is supported.
            if [ -n "$PLATFORM_MATCH" ]; then
                CMD="$BASEDIR$SYMONDIR/$BIN -f"
                cmd_exist=1
            else
                # Platform not supported.
                TMP_BUF="$TMP_BUF $BIN"
                CMD_BUF="$CMD_BUF $TMPCMD"
            fi
        else
            (( no_pkg = no_pkg + 1 ))
        fi
    fi

    # Run the command
    if [ $cmd_exist -eq 1 ]; then
        if [ -x $CMD ]; then
            if [ ! -d "$LOGDIR" ]; then
                mkdir -p $LOGDIR
            fi
            # Standard error of configd is redirected to the error log file.
            # This need to be done in order to show configd's errors.
            $CMD 2>>$LOGDIR/$ERRFILE 
            if [ $? -eq 0 ]; then	 
                return 0
            else
                # Printed when configd failed to run propery.
                echo "eda_configd.ksh $DATE ERROR: Error found while running $CMD" >> $LOGDIR/$ERRFILE
            fi
        else
            echo "eda_configd.ksh $DATE ERROR: Cannot execute $CMD" >> $LOGDIR/$ERRFILE
      fi
   fi		
done


# Giving a try to what you have installed.
# This part of the code is different than the VTS because ED depends on configd
# in order to function correctly. That's why we need to give a chance what we
# have installed.
for CONFIGD in $CMD_BUF
do
   CMD="$CONFIGD -f"
   if [ -x $CMD ]; then
      # Here we don't show the error messages of configd, becuase we are just
      # trying what is installed, which is not the correct configd for the
      # platform.
      $CMD 2>/dev/null
      if [ $? -eq 0 ]; then
	 # Good luck!! It works....
	 return 0
      fi
   fi
done

# Printing additional error messages.
# Error messages need to be appended to the error log file, since edagent is
# not started by the user from the command line.
if [ ! -d "$LOGDIR" ]; then
   mkdir -p $LOGDIR
fi

if [ $configd_count -eq $no_pkg ]; then
  # Non of the configd packages is installed
  echo "eda_configd.ksh $DATE ERROR: Configd not available." >> $LOGDIR/$ERRFILE
  return -1
else 
  echo "eda_configd.ksh $DATE ERROR: Platform not supported by:$TMP_BUF" >> $LOGDIR/$ERRFILE
  return -1
fi

