/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.group;

import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMLengthException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SMNameCriteria
extends SMFilterCriteria {
    private static final String version = "1.0";
    public static final String EXACT_MATCH = "X";
    public static final String CONTAINS = "C";
    public static final String STARTS_WITH = "S";
    public static final String ENDS_WITH = "E";
    private String matchType_ = "X";
    private String pattern_;

    public SMNameCriteria(String string, String string2, boolean bl) throws SMLengthException {
        super(bl);
        if (string2.length() > 64) {
            throw new SMLengthException();
        }
        this.matchType_ = string;
        this.pattern_ = string2;
    }

    public String getMatchType() {
        return this.matchType_;
    }

    private static String getMatchType(String string) {
        if (EXACT_MATCH.equals(string)) {
            return "EXACT_MATCH";
        }
        if (CONTAINS.equals(string)) {
            return "CONTAINS";
        }
        if (STARTS_WITH.equals(string)) {
            return "STARTS_WITH";
        }
        if (ENDS_WITH.equals(string)) {
            return "ENDS_WITH";
        }
        return "unknown";
    }

    public String getPattern() {
        return this.pattern_;
    }

    public boolean matches(String string) {
        if (this.matchType_.equals(CONTAINS) && string.indexOf(this.pattern_) != -1) {
            return true;
        }
        if (this.matchType_.equals(ENDS_WITH) && string.endsWith(this.pattern_)) {
            return true;
        }
        if (this.matchType_.equals(EXACT_MATCH) && string.equals(this.pattern_)) {
            return true;
        }
        return this.matchType_.equals(STARTS_WITH) && string.startsWith(this.pattern_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.matchType_ = SMDBObject.readString(objectInputStream);
        this.pattern_ = SMDBObject.readString(objectInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NameCriteria=[");
        stringBuffer.append("matchType=").append(SMNameCriteria.getMatchType(this.matchType_));
        stringBuffer.append(", pattern=").append(this.pattern_);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        SMDBObject.writeString(objectOutputStream, this.matchType_);
        SMDBObject.writeString(objectOutputStream, this.pattern_);
    }
}

