/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.sess_iiop.ssl.orb_dep;

import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IOP.TaggedComponent;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ConnectionFactory;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.IiopProtocol;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.SocketConnectionFactory;
import com.visigenic.vbroker.orb.TcpConnection;
import java.net.InetAddress;
import oracle.aurora.sess_iiop.orb_dep.ComponentBody;
import oracle.aurora.sess_iiop.orb_dep.ComponentBodyHelper;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.portable.InputStream;

public class SessionSSLConnectionFactory
implements SocketConnectionFactory {
    private ORB _orb;
    IiopProtocol _protocol;
    String _sslSocketClass = "oracle.aurora.ssl.AuroraSSLSocket";

    SessionSSLConnectionFactory(ORB orb, IiopProtocol protocol) {
        this._orb = orb;
        this._protocol = protocol;
    }

    public Connection connect(TaggedProfile profile) {
        if (this._orb.debug) {
            ProfileBody profileBody = this._protocol.profileBody(profile);
            this._orb.println((Object)("SessionSSLConnectionFactory trying to connect to " + profileBody.host + ":" + this._protocol.port(profileBody)));
        }
        Object[] args = new Object[]{this._protocol, this.doCreate(this._sslSocketClass, new Boolean(true)), this};
        TcpConnection connection = (TcpConnection)this._orb.create(27, args);
        connection.connect(profile);
        return connection;
    }

    public Connection connect(String localHostName, int localPort, TaggedProfile profile) {
        if (this._orb.debug) {
            ProfileBody profileBody = this._protocol.profileBody(profile);
            this._orb.println((Object)("SessionSSLConnectionFactory trying to connect to " + profileBody.host + ":" + this._protocol.port(profileBody) + " from " + localHostName + ":" + localPort));
        }
        Object[] args = new Object[]{this._protocol, this.doCreate(this._sslSocketClass, new Boolean(true)), this};
        TcpConnection connection = (TcpConnection)this._orb.create(27, args);
        connection.connect(localHostName, localPort, profile);
        return connection;
    }

    private Object doCreate(String className, Object arg) {
        try {
            Object result = Class.forName(className).newInstance();
            Object[] args = new Object[]{arg};
            if (result instanceof OrbObject) {
                ((OrbObject)result).init(this._orb, args);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new INTERNAL(e.toString());
        }
    }

    public Object hashEndpoint(TaggedProfile profile) {
        return new TcpEndpoint(profile);
    }

    public ConnectionFactory.Listener listen(TaggedProfile profile) {
        return null;
    }

    class TcpEndpoint {
        private String _host;
        private int _port;
        private int _session = 0;
        private String _service = "ORCL";
        private String hack = "true";

        public TcpEndpoint(TaggedProfile profile) {
            ProfileBody pb = SessionSSLConnectionFactory.this._protocol.profileBody(profile);
            int i = 0;
            while (i < pb.components.length) {
                if (pb.components[i].tag == 1330790656) {
                    TaggedComponent comp = pb.components[i];
                    GiopInputStream input = SessionSSLConnectionFactory.this._orb.newGiopInputStream(comp.component_data);
                    input.byteOrder(input.read_boolean());
                    ComponentBody body = ComponentBodyHelper.read((InputStream)input);
                    this._session = body.session;
                    this._service = body.service;
                    break;
                }
                ++i;
            }
            this._host = pb.host;
            try {
                int length = pb.host.length();
                int i2 = 0;
                while (i2 < length) {
                    char c = pb.host.charAt(i2);
                    switch (c) {
                        default: {
                            this._host = ORB.inetAddressBytesToString((byte[])InetAddress.getByName(pb.host).getAddress());
                        }
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                throw new INTERNAL(e.getMessage());
            }
            if (pb.host.equals("127.0.0.1")) {
                try {
                    this._host = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    throw new INTERNAL(e.getMessage());
                }
            }
            this._port = SessionSSLConnectionFactory.this._protocol.port(pb);
            this.hack = System.getProperty("ConnHack");
            if (this.hack == null) {
                this.hack = "true";
            }
        }

        public boolean equals(Object object) {
            if (object instanceof TcpEndpoint) {
                TcpEndpoint rhs = (TcpEndpoint)object;
                if (this.hack.equals("false") && this._session == 0) {
                    return false;
                }
                if (this._port == rhs._port && this._host.equals(rhs._host) && this._service.equals(rhs._service) && this._session == rhs._session) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this._host.hashCode() + this._port + this._service.hashCode() + this._session;
        }

        public String toString() {
            return String.valueOf(this._host) + ":" + this._port + ":" + this._service + ":" + this._session;
        }
    }
}

