/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import oracle.aurora.server.tools.sess_iiop.ChainProperties;
import oracle.aurora.server.tools.sess_iiop.ToolsException;

public class WorkingDirectory {
    private static final String DEFAULT_MSG_FILE = "oracle.aurora.server.tools.sess_iiop.Message";
    private String messageFile = "oracle.aurora.server.tools.sess_iiop.Message";
    private ResourceBundle bundle;
    protected ChainProperties environment;
    protected Context ic;
    protected Context wd;
    protected Name wd_name;
    protected NameParser parser;
    public static final String USER_HOME = "LOCAL_HOME";

    protected WorkingDirectory() {
    }

    public WorkingDirectory(String msgFile, Properties env, Context initialContext) throws ToolsException {
        this.messageFile = msgFile;
        this.wd = this.ic = initialContext;
        this.environment = new ChainProperties((Hashtable)this.environment);
        try {
            this.parser = this.ic.getNameParser("");
        }
        catch (NamingException e) {
            this.fail1("UNABLE_TO_GET_NAME_PARSER", e.getMessage());
        }
        this.wd_name = this.rootName();
    }

    public WorkingDirectory(Properties env, Context initialContext) throws ToolsException {
        this(DEFAULT_MSG_FILE, env, initialContext);
    }

    public void cd(String directory) throws ToolsException {
        if (directory == null) {
            directory = new String("/");
        }
        this.cd(this.parse(directory));
    }

    public void cd(Name name) throws ToolsException {
        Name org = name;
        try {
            if (name.size() == 0) {
                return;
            }
            name = this.transformName(this.wd_name(), name);
            this.wd = this.findDirectory(name);
            this.wd_name = name;
        }
        catch (NamingException e) {
            this.fail2("NO_SUCH_NAME", name.getSuffix(this.wd_name.size()).toString(), e.getMessage());
        }
        catch (ClassCastException classCastException) {
            this.fail1("NOT_A_DIRECTORY", org.toString());
        }
    }

    protected void error(String message) throws ToolsException {
        throw new ToolsException(message);
    }

    protected void fail0(String key) throws ToolsException {
        String message = this.msg(key, null);
        throw new ToolsException(message);
    }

    protected void fail1(String key, String info) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    protected void fail2(String key, String info, String info2) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    protected void fail3(String key, String info, String info2, String info3) throws ToolsException {
        Object[] args = new Object[]{info == null ? "null" : info, info2 == null ? "null" : info2, info3 == null ? "null" : info3};
        String message = this.msg(key, args);
        throw new ToolsException(message);
    }

    private Object find(Name absolute) throws NamingException {
        if (absolute.startsWith(this.wd_name)) {
            if (absolute.size() == this.wd_name().size()) {
                return this.wd();
            }
            return this.wd.lookup(absolute.getSuffix(this.wd_name.size()));
        }
        return this.ic.lookup(absolute);
    }

    private Context findDirectory(Name absolute) throws ClassCastException, NamingException {
        if (absolute.startsWith(this.wd_name)) {
            if (absolute.size() == this.wd_name().size()) {
                return this.wd();
            }
            return (Context)this.wd.lookup(absolute.getSuffix(this.wd_name.size()));
        }
        return (Context)this.ic.lookup(absolute);
    }

    public Context ic() {
        return this.ic;
    }

    public Name last(Name name) {
        return name.getSuffix(name.size() - 1);
    }

    public Name lead(Name name) {
        return name.getPrefix(name.size() - 1);
    }

    public Object lookup(Name transform) throws ToolsException {
        try {
            return this.find(this.transformName(this.wd_name, transform));
        }
        catch (NamingException e) {
            this.fail2("NO_SUCH_NAME", transform.toString(), e.getMessage());
        }
        catch (ClassCastException classCastException) {
            this.fail1("NOT_A_DIRECTORY", transform.toString());
        }
        return null;
    }

    public Context lookupDirectory(Name transform) throws ToolsException {
        try {
            return this.findDirectory(this.transformName(this.wd_name, transform));
        }
        catch (NamingException namingException) {
            this.fail1("NO_SUCH_NAME", transform.toString());
        }
        catch (ClassCastException classCastException) {
            this.fail1("NOT_A_DIRECTORY", transform.toString());
        }
        return null;
    }

    public Context lookupParent(Name transform) throws ToolsException {
        if (transform.size() == 1) {
            return this.wd;
        }
        return this.lookupDirectory(this.lead(transform));
    }

    protected String msg(String key) throws ToolsException {
        return this.msg(key, null);
    }

    String msg(String key, Object[] args) throws ToolsException {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle(this.messageFile);
            }
            catch (Exception exception) {
                return "Message file '" + this.messageFile + "' is missing.";
            }
        }
        try {
            return MessageFormat.format(this.bundle.getString(key), args);
        }
        catch (Exception exception) {
            throw new ToolsException("Message [" + key + "] not found in '" + this.messageFile + "'.");
        }
    }

    protected Name operate(Name name, String component) throws ToolsException {
        if (component.equals("")) {
            return name;
        }
        if (component.equals(".")) {
            return name;
        }
        if (component.equals("..")) {
            return name.getPrefix(Math.max(1, name.size() - 1));
        }
        try {
            name.addAll(this.parse(component));
            return name;
        }
        catch (InvalidNameException invalidNameException) {
            this.fail1("INVALID_NAME", component);
            return null;
        }
    }

    public Name parse(String nameString) throws ToolsException {
        try {
            return this.parser.parse(nameString);
        }
        catch (InvalidNameException invalidNameException) {
            this.fail1("NO_SUCH_NAME", nameString);
        }
        catch (NamingException namingException) {
            this.fail1("UNABLE_TO_PARSE_NAME", nameString);
        }
        return null;
    }

    public Name rootName() throws ToolsException {
        return this.parse("/");
    }

    public NamingEnumeration search(String filter, boolean recurse) throws ToolsException {
        int scope = 1;
        if (recurse) {
            scope = 2;
        }
        String[] attrs = null;
        SearchControls ctrls = new SearchControls(scope, 0L, 0, attrs, false, true);
        Name name = this.parse("/");
        try {
            return ((DirContext)this.wd).search(name, filter, ctrls);
        }
        catch (NamingException e) {
            this.fail1("ERROR_DURING_SEARCH", e.getMessage());
        }
        catch (ClassCastException classCastException) {
            this.fail1("NOT_A_DIRECTORY", this.wd_name.toString());
        }
        return null;
    }

    public NamingEnumeration search(String filter, boolean recurse, Name transform) throws ToolsException {
        return null;
    }

    public Name transformName(Name source, Name transform) throws ToolsException {
        if (transform.get(0).equals("")) {
            source = this.rootName();
            if (transform.size() == 1) {
                return source;
            }
            transform = transform.getSuffix(1);
        } else if (transform.get(0).equals("~")) {
            source = this.userHome();
            if (transform.size() == 1) {
                return source;
            }
            transform = transform.getSuffix(1);
        }
        Name dir = (Name)source.clone();
        int i = 0;
        while (i < transform.size()) {
            String component = transform.get(i);
            dir = this.operate(dir, component);
            ++i;
        }
        return dir;
    }

    public Name userHome() throws ToolsException {
        String home = this.environment.getProperty(USER_HOME);
        if (home == null) {
            return this.rootName();
        }
        return this.parse(home);
    }

    public Context wd() {
        return this.wd;
    }

    public Name wd_name() {
        return this.wd_name;
    }
}

