/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import javax.naming.Name;
import javax.naming.NamingException;
import oracle.aurora.server.tools.sess_iiop.Chmod;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;

public class Mkdir
extends ToolImpl {
    private Name[] dirName;
    private boolean createPath = false;
    private boolean recursiveGrants = false;
    private String[] grants;

    public Mkdir() {
    }

    public Mkdir(Name[] name, boolean createpath_) throws ToolsException {
        this.createPath = createpath_;
        this.dirName = new Name[name.length];
        int i = 0;
        while (i < name.length) {
            this.dirName[i] = name[i];
            ++i;
        }
        this.invoke();
    }

    public Mkdir(Name[] name, boolean createpath_, boolean recursivegrants_, String[] grants_) throws ToolsException {
        this.createPath = createpath_;
        this.dirName = new Name[name.length];
        int i = 0;
        while (i < name.length) {
            this.dirName[i] = name[i];
            ++i;
        }
        this.recursiveGrants = recursivegrants_;
        this.grants = grants_;
        this.invoke();
    }

    public String description() throws ToolsException {
        return this.msg("MKDIR_DESCRIPTION", null);
    }

    protected void ensureParent(Name parentDir) throws ToolsException {
        block6: {
            if (!this.createPath) break block6;
            Name parentparent = ToolImpl.wd.lead(parentDir);
            if (!parentparent.isEmpty()) {
                try {
                    ToolImpl.wd.lookupDirectory(parentparent);
                }
                catch (ToolsException toolsException) {
                    this.ensureParent(parentparent);
                }
            }
            try {
                Name child = ToolImpl.wd.last(parentDir);
                ToolImpl.wd.lookupDirectory(parentparent).createSubcontext(child);
                if (this.recursiveGrants && this.grants != null) {
                    new Chmod(parentDir.toString(), this.grants, null, null, null, this.grants, null);
                }
            }
            catch (NamingException e1) {
                this.fail1("CANNOT_CREATE_DIRECTORY", e1.getMessage());
            }
        }
    }

    public String help() throws ToolsException {
        return this.msg("MKDIR_HELP", null);
    }

    protected void invoke() throws ToolsException {
        int i = 0;
        while (i < this.dirName.length) {
            Name transform;
            Name parentDir;
            if (this.dirName[i].toString().equals("/")) {
                this.fail0("NO_PERMISSION_TO_CREATE_ROOT_OBJECT");
            }
            if (!(parentDir = ToolImpl.wd.lead(transform = ToolImpl.wd.transformName(ToolImpl.wd.wd_name(), this.dirName[i]))).isEmpty()) {
                try {
                    ToolImpl.wd.lookupDirectory(parentDir);
                }
                catch (ToolsException e) {
                    if (this.createPath) {
                        this.ensureParent(parentDir);
                    }
                    this.fail1("CANNOT_CREATE_DIRECTORY", e.getMessage());
                }
            }
            try {
                ToolImpl.wd.lookupParent(transform).createSubcontext(ToolImpl.wd.last(transform));
                if (this.recursiveGrants && this.grants != null) {
                    new Chmod(transform.toString(), this.grants, null, null, null, this.grants, null);
                }
            }
            catch (NamingException e1) {
                this.fail1("CANNOT_CREATE_DIRECTORY", e1.getMessage());
            }
            ++i;
        }
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        int options = 0;
        if (argv.length == 0) {
            this.error(this.usage());
        }
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-path")) {
                this.createPath = true;
                ++options;
            } else if (argv[i].equals("-grant") || argv[i].equals("-g")) {
                if (++i == argv.length) {
                    this.fail0("MISSING_GRANT_SCHEMAS");
                }
                this.grants = this.parseCommaDelimited(argv[i]);
                options += 2;
            } else if (argv[i].equals("-recursiveGrant") || argv[i].equals("-rg") || argv[i].equals("-rG")) {
                this.recursiveGrants = true;
                if (++i == argv.length) {
                    this.fail0("MISSING_GRANT_SCHEMAS");
                }
                this.grants = this.parseCommaDelimited(argv[i]);
                options += 2;
            }
            ++i;
        }
        int j = 0;
        this.dirName = new Name[argv.length - options];
        int i2 = 0;
        while (i2 < argv.length) {
            if (!argv[i2].equals("-path")) {
                if (argv[i2].equals("-grant") || argv[i2].equals("-g") || argv[i2].equals("-recursiveGrant") || argv[i2].equals("-rg") || argv[i2].equals("-rG")) {
                    ++i2;
                } else if (j < argv.length - options) {
                    this.dirName[j] = ToolImpl.wd.parse(argv[i2]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    public String usage() throws ToolsException {
        return this.msg("MKDIR_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("MKDIR_VERSION", null);
    }
}

