/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.sql.Timestamp;
import java.util.Date;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.PublishedObject;
import oracle.aurora.AuroraServices.ctxAttribs;
import oracle.aurora.AuroraServices.objAttribs;
import oracle.aurora.AuroraServices.objAttribsHolder;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.NO_PERMISSION;

public class Ls
extends ToolImpl {
    private Name[] dir = null;
    private boolean detailed = false;
    private boolean listDirOnly = false;
    private boolean recursively = false;
    private boolean headerPrinted = false;
    private int[] offset = new int[]{9, 18, 27, 36, 49, 59, 69, 79};
    private int columnFilled = 0;

    public String description() throws ToolsException {
        return this.msg("LS_DESCRIPTION", null);
    }

    private Object dir(Name name) throws ToolsException {
        if (name == null) {
            return ToolImpl.wd.wd();
        }
        return ToolImpl.wd.lookup(name);
    }

    public String help() throws ToolsException {
        return this.msg("LS_HELP", null);
    }

    protected void invoke() throws ToolsException {
        int i = 0;
        while (this.dir == null || i < this.dir.length) {
            this.columnFilled = 0;
            String str = null;
            if (this.dir != null) {
                if (this.dir[i] != null) {
                    str = this.dir[i].toString();
                }
                this.printRecursively(str, this.dir(this.dir[i]), this.listDirOnly, this.recursively);
            } else {
                this.printRecursively(str, this.dir(null), this.listDirOnly, this.recursively);
            }
            if (this.dir == null) {
                return;
            }
            ++i;
        }
        if (this.listDirOnly && !this.detailed && this.columnFilled != 80) {
            this.stdOut.println();
        }
    }

    public static void main(String[] args) {
        try {
            new Ls().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        int flags = 0;
        int objCount = 0;
        int i = 0;
        while (i < argv.length) {
            if (!this.rightArgs(argv[i])) {
                this.error(this.help());
            }
            if (argv[i].equals("-dir")) {
                this.listDirOnly = true;
                ++flags;
            }
            if (argv[i].equals("-l")) {
                this.detailed = true;
                ++flags;
            }
            if (argv[i].equals("-ld") || argv[i].equals("-dl") || argv[i].equals("-ldir")) {
                this.listDirOnly = true;
                this.detailed = true;
                ++flags;
            }
            if (argv[i].equals("-R")) {
                this.recursively = true;
                ++flags;
            }
            if (argv[i].equals("-lR") || argv[i].equals("-Rl")) {
                this.detailed = true;
                this.recursively = true;
                ++flags;
            }
            ++i;
        }
        if (argv.length == flags) {
            return;
        }
        this.dir = new Name[argv.length - flags];
        objCount = 0;
        int i2 = 0;
        while (i2 < argv.length) {
            if (!argv[i2].startsWith("-")) {
                this.dir[objCount] = argv[i2].equals(".") ? null : ToolImpl.wd.parse(argv[i2]);
                ++objCount;
            }
            ++i2;
        }
        if (argv.length != objCount + flags) {
            this.error(this.usage());
        }
    }

    private void print(Binding b) {
        this.stdOut.println(b.getName());
    }

    protected void printContext(String name, Object obj) throws ToolsException {
        int maxRows;
        SessionCtx ctx = (SessionCtx)obj;
        if (!this.detailed) {
            if (this.listDirOnly) {
                if (name != null) {
                    this.stdOut.print(String.valueOf(name) + "/   ");
                    this.columnFilled += name.length() + 4;
                    if (this.columnFilled >= 80) {
                        this.columnFilled = 0;
                        this.stdOut.println();
                    }
                } else {
                    this.stdOut.println("./");
                }
            } else {
                this.stdOut.print(String.valueOf(name) + "/    ");
                this.columnFilled += name.length() + 5;
                if (this.columnFilled >= 80) {
                    this.columnFilled = 0;
                    this.stdOut.println();
                }
            }
            return;
        }
        ctxAttribs attribs = null;
        try {
            attribs = ctx.getAttributes();
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.stdOut.print(" No permission");
            return;
        }
        if (!this.headerPrinted) {
            this.printHeader(obj);
            this.headerPrinted = true;
        }
        if ((maxRows = attribs.read.length) < attribs.write.length) {
            maxRows = attribs.write.length;
        }
        if (maxRows < attribs.execute.length) {
            maxRows = attribs.execute.length;
        }
        if (maxRows == 0) {
            this.stdOut.print("                                                  ");
            if (name != null) {
                this.stdOut.println(String.valueOf(name) + "/");
            } else {
                this.stdOut.println(" ./");
            }
            return;
        }
        int row = 0;
        while (row < maxRows) {
            int i;
            if (row < attribs.read.length) {
                this.stdOut.print(String.valueOf(attribs.read[row]) + " ");
                i = attribs.read[row].length() + 1;
                while (i < this.offset[0]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.offset[0]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            }
            if (row < attribs.write.length) {
                this.stdOut.print(String.valueOf(attribs.write[row]) + " ");
                i = this.offset[0] + attribs.write[row].length() + 1;
                while (i < this.offset[1]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            } else {
                i = this.offset[0];
                while (i < this.offset[1]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            }
            if (row < attribs.execute.length) {
                this.stdOut.print(String.valueOf(attribs.execute[row]) + " ");
                i = this.offset[1] + attribs.execute[row].length() + 1;
                while (i < this.offset[2]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            } else if (row != maxRows - 1) {
                i = this.offset[1];
                while (i < this.offset[2]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            }
            if (row == 0) {
                this.stdOut.print(String.valueOf(attribs.owner) + " ");
                if (attribs.owner != null) {
                    i = this.offset[2] + attribs.owner.length() + 1;
                    while (i < this.offset[3]) {
                        this.stdOut.print(" ");
                        ++i;
                    }
                } else {
                    i = this.offset[2];
                    while (i < this.offset[3]) {
                        this.stdOut.print(" ");
                        ++i;
                    }
                }
                this.printTime(Timestamp.valueOf(attribs.creation_ts));
                if (name != null) {
                    this.stdOut.print(String.valueOf(name) + "/");
                } else {
                    this.stdOut.print(" ./");
                }
            }
            this.stdOut.println();
            ++row;
        }
    }

    private void printHeader(Object obj) {
        this.stdOut.print(" Read");
        int i = 5;
        while (i <= this.offset[0]) {
            this.stdOut.print(" ");
            ++i;
        }
        this.stdOut.print("Write");
        int i2 = this.offset[0] + 5;
        while (i2 < this.offset[1]) {
            this.stdOut.print(" ");
            ++i2;
        }
        this.stdOut.print("Exec");
        int i3 = this.offset[1] + 4;
        while (i3 < this.offset[2]) {
            this.stdOut.print(" ");
            ++i3;
        }
        this.stdOut.print("Owner");
        int i4 = this.offset[2] + 5;
        while (i4 < this.offset[3]) {
            this.stdOut.print(" ");
            ++i4;
        }
        this.stdOut.print("Date Time");
        int i5 = this.offset[3] + 9;
        while (i5 < this.offset[4]) {
            this.stdOut.print(" ");
            ++i5;
        }
        this.stdOut.print("Name");
        int i6 = this.offset[4] + 4;
        while (i6 < this.offset[5]) {
            this.stdOut.print(" ");
            ++i6;
        }
        this.stdOut.print("Schema");
        int i7 = this.offset[5] + 6;
        while (i7 < this.offset[6]) {
            this.stdOut.print(" ");
            ++i7;
        }
        this.stdOut.print("Class");
        int i8 = this.offset[6] + 5;
        while (i8 < this.offset[7]) {
            this.stdOut.print(" ");
            ++i8;
        }
        this.stdOut.println("Helper");
    }

    private void printMonth(String s) {
        if (s.equals("01")) {
            this.stdOut.print("Jan ");
        } else if (s.equals("02")) {
            this.stdOut.print("Feb ");
        } else if (s.equals("03")) {
            this.stdOut.print("Mar ");
        } else if (s.equals("04")) {
            this.stdOut.print("Apr ");
        } else if (s.equals("05")) {
            this.stdOut.print("May ");
        } else if (s.equals("06")) {
            this.stdOut.print("Jun ");
        } else if (s.equals("07")) {
            this.stdOut.print("Jul ");
        } else if (s.equals("08")) {
            this.stdOut.print("Aug ");
        } else if (s.equals("09")) {
            this.stdOut.print("Sep ");
        } else if (s.equals("10")) {
            this.stdOut.print("Oct ");
        } else if (s.equals("11")) {
            this.stdOut.print("Nov ");
        } else if (s.equals("12")) {
            this.stdOut.print("Dec ");
        }
    }

    protected void printObject(String name, Object obj) {
        int maxRows;
        if (this.listDirOnly) {
            this.stdOut.println("Not a directory");
            return;
        }
        if (!this.detailed) {
            this.stdOut.print(String.valueOf(name) + "    ");
            this.columnFilled += name.length() + 4;
            if (this.columnFilled >= 80) {
                this.columnFilled = 0;
            }
            return;
        }
        PublishedObject pubObj = (PublishedObject)obj;
        objAttribsHolder holder = new objAttribsHolder();
        try {
            pubObj.get_attributes(holder);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.stdOut.print(" No permission");
            return;
        }
        objAttribs attribs = holder.value;
        if (!this.headerPrinted) {
            this.printHeader(obj);
            this.headerPrinted = true;
        }
        if ((maxRows = attribs.read.length) < attribs.write.length) {
            maxRows = attribs.write.length;
        }
        if (maxRows < attribs.execute.length) {
            maxRows = attribs.execute.length;
        }
        if (maxRows == 0) {
            this.stdOut.print("                                                  ");
            if (name != null) {
                this.stdOut.println(String.valueOf(name) + "/");
            } else {
                this.stdOut.println(" ./");
            }
            return;
        }
        int row = 0;
        while (row < maxRows) {
            int i;
            if (row < attribs.read.length) {
                this.stdOut.print(String.valueOf(attribs.read[row]) + " ");
                i = attribs.read[row].length() + 1;
                while (i < this.offset[0]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.offset[0]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            }
            if (row < attribs.write.length) {
                this.stdOut.print(String.valueOf(attribs.write[row]) + " ");
                i = this.offset[0] + attribs.write[row].length() + 1;
                while (i < this.offset[1]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            } else {
                i = this.offset[0];
                while (i < this.offset[1]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            }
            if (row < attribs.execute.length) {
                this.stdOut.print(String.valueOf(attribs.execute[row]) + " ");
                i = this.offset[1] + attribs.execute[row].length() + 1;
                while (i < this.offset[2]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            } else if (row != maxRows - 1) {
                i = this.offset[1];
                while (i < this.offset[2]) {
                    this.stdOut.print(" ");
                    ++i;
                }
            }
            if (row == 0) {
                int i2;
                this.stdOut.print(String.valueOf(attribs.owner) + " ");
                if (attribs.owner != null) {
                    i = this.offset[2] + attribs.owner.length() + 1;
                    while (i < this.offset[3]) {
                        this.stdOut.print(" ");
                        ++i;
                    }
                } else {
                    i = this.offset[2];
                    while (i < this.offset[3]) {
                        this.stdOut.print(" ");
                        ++i;
                    }
                }
                this.printTime(Timestamp.valueOf(attribs.creation_ts));
                this.stdOut.print(String.valueOf(name) + " ");
                i = this.offset[4] + name.length() + 1;
                while (i < this.offset[5]) {
                    this.stdOut.print(" ");
                    ++i;
                }
                this.stdOut.print(String.valueOf(attribs.schema) + " ");
                if (attribs.schema != null) {
                    i2 = this.offset[5] + attribs.schema.length() + 1;
                    while (i2 < this.offset[6]) {
                        this.stdOut.print(" ");
                        ++i2;
                    }
                } else {
                    i2 = this.offset[5];
                    while (i2 < this.offset[6]) {
                        this.stdOut.print(" ");
                        ++i2;
                    }
                }
                this.stdOut.print(String.valueOf(attribs.class_name) + " ");
                if (attribs.class_name != null) {
                    i2 = this.offset[6] + attribs.class_name.length() + 1;
                    while (i2 < this.offset[7]) {
                        this.stdOut.print(" ");
                        ++i2;
                    }
                } else {
                    i2 = this.offset[6];
                    while (i2 < this.offset[7]) {
                        this.stdOut.print(" ");
                        ++i2;
                    }
                }
                this.stdOut.print(attribs.helper);
            }
            this.stdOut.println();
            ++row;
        }
    }

    protected void printRecursively(String str, Object obj, boolean asObject, boolean recurse) throws ToolsException {
        block17: {
            if (obj instanceof PublishedObject) {
                this.printObject(str, obj);
            } else {
                Context c = (Context)obj;
                if (asObject) {
                    this.printContext(str, obj);
                } else {
                    Object curDir = null;
                    try {
                        if (str == null) {
                            curDir = (Context)this.dir(null);
                        } else {
                            Name name = ToolImpl.wd.parse(str);
                            curDir = (Context)this.dir(name);
                        }
                        NamingEnumeration list = curDir.list("");
                        if (!recurse) {
                            if (this.dir != null && this.dir.length > 1) {
                                if (str == null) {
                                    this.stdOut.println(".: ");
                                } else {
                                    this.stdOut.println(String.valueOf(str) + ":");
                                }
                            }
                            while (list.hasMore()) {
                                Binding b = (Binding)list.next();
                                Object o = curDir.lookup(b.getName());
                                this.printRecursively(b.getName(), o, true, false);
                            }
                            if (this.detailed || this.columnFilled <= 0) break block17;
                            this.stdOut.println();
                            break block17;
                        }
                        if (str == null) {
                            this.stdOut.println(".: ");
                        } else {
                            this.stdOut.println(String.valueOf(str) + ":");
                        }
                        this.printRecursively(str, c, false, false);
                        this.columnFilled = 0;
                        while (list.hasMore()) {
                            Binding b = (Binding)list.next();
                            Object o = curDir.lookup(b.getName());
                            if (!(o instanceof Context)) continue;
                            if (str == null) {
                                this.printRecursively("./" + b.getName(), o, false, true);
                                continue;
                            }
                            this.printRecursively(String.valueOf(str) + "/" + b.getName(), o, false, true);
                        }
                    }
                    catch (NamingException namingException) {
                        this.fail1("NO_SUCH_NAME", curDir.toString());
                    }
                }
            }
        }
    }

    private void printTime(Timestamp ts) {
        this.printMonth(ts.toString().substring(5, 7));
        this.stdOut.print(String.valueOf(ts.toString().substring(8, 10)) + " ");
        Date curUtilDate = new Date();
        String curYear = curUtilDate.toString().substring(24);
        if (curYear.equals(ts.toString().substring(0, 4))) {
            this.stdOut.print(ts.toString().substring(11, 16));
        } else {
            this.stdOut.print(" " + ts.toString().substring(0, 4));
        }
        int i = this.offset[3] + 12;
        while (i < this.offset[4]) {
            this.stdOut.print(" ");
            ++i;
        }
    }

    private boolean rightArgs(String argv) {
        if (argv.equals("-") || argv.startsWith("-") && argv.charAt(1) != 'd' && argv.charAt(1) != 'l' && argv.charAt(1) != 'R') {
            return false;
        }
        return argv.length() <= 2 || !argv.startsWith("-") || !(argv.charAt(1) == 'l' && argv.charAt(2) != 'd' && argv.charAt(2) != 'R' || argv.charAt(1) == 'R' && argv.charAt(2) != 'l') && (argv.charAt(1) != 'd' || argv.charAt(2) == 'l' || argv.equals("-dir"));
    }

    public String usage() throws ToolsException {
        return this.msg("LS_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("LS_VERSION", null);
    }
}

