/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import javax.naming.NamingException;
import oracle.aurora.AuroraServices.ExecutionError;
import oracle.aurora.AuroraServices.Executioner;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.StringHolder;

public class Java
extends ToolImpl {
    private String className;
    private String schema;
    private String[] args;
    static final String EXEC_NAME = "/etc/execute";
    static final String MAIN = "main";

    public String description() throws ToolsException {
        return this.msg("JAVA_DESCRIPTION", null);
    }

    public String help() throws ToolsException {
        return this.msg("JAVA_HELP", null);
    }

    protected void invoke() throws ToolsException {
        try {
            Executioner exec = (Executioner)((SessionCtx)ToolImpl.wd.ic()).activate(EXEC_NAME);
            StringHolder out = new StringHolder();
            if (this.schema == null) {
                exec.exec(out, this.className, MAIN, this.args);
            } else {
                exec.exec_in(out, this.className, this.schema, MAIN, this.args);
            }
            this.stdOut.print(out.value);
        }
        catch (NamingException e) {
            this.fail1("EXECUTIONER_NOT_FOUND", e.getMessage());
        }
        catch (ExecutionError e) {
            this.stdOut.println(e.stackTrace);
            this.fail2("EXECUTIONER_ERROR", e.exceptionClassName, e.msg);
        }
    }

    public static void main(String[] args) {
        try {
            new Java().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        if (argv.length == 0) {
            this.error(this.usage());
        }
        this.className = argv[0];
        if (argv.length > 2 && argv[1].equals("-schema")) {
            this.schema = argv[2];
            this.args = new String[argv.length - 3];
            System.arraycopy(argv, 2, this.args, 0, argv.length - 3);
            return;
        }
        this.args = new String[argv.length - 1];
        System.arraycopy(argv, 1, this.args, 0, argv.length - 1);
    }

    public String usage() throws ToolsException {
        return this.msg("JAVA_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("JAVA_VERSION", null);
    }
}

