/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.PublishedObject;
import oracle.aurora.AuroraServices.ctxAttribs;
import oracle.aurora.AuroraServices.objAttribsHolder;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.NO_PERMISSION;

public class Chmod
extends ToolImpl {
    private Name name;
    private String[] read_add = new String[0];
    private String[] write_add = new String[0];
    private String[] execute_add = new String[0];
    private String[] read_remove = new String[0];
    private String[] write_remove = new String[0];
    private String[] execute_remove = new String[0];

    public Chmod() {
    }

    public Chmod(String n, String r_add, String r_remove, String w_add, String w_remove, String e_add, String e_remove) throws ToolsException {
        this.name = ToolImpl.wd.parse(n);
        this.read_add = this.parseCommaDelimited(r_add == null ? "" : r_add);
        this.read_remove = this.parseCommaDelimited(r_remove == null ? "" : r_remove);
        this.write_add = this.parseCommaDelimited(w_add == null ? "" : w_add);
        this.write_remove = this.parseCommaDelimited(w_remove == null ? "" : w_remove);
        this.execute_add = this.parseCommaDelimited(e_add == null ? "" : e_add);
        this.execute_remove = this.parseCommaDelimited(e_remove == null ? "" : e_remove);
        this.invoke();
    }

    public Chmod(String n, String[] r_add, String[] r_remove, String[] w_add, String[] w_remove, String[] e_add, String[] e_remove) throws ToolsException {
        this.name = ToolImpl.wd.parse(n);
        String[] nullArray = new String[]{};
        this.read_add = r_add == null ? nullArray : r_add;
        this.read_remove = r_remove == null ? nullArray : r_remove;
        this.write_add = w_add == null ? nullArray : w_add;
        this.write_remove = w_remove == null ? nullArray : w_remove;
        this.execute_add = e_add == null ? nullArray : e_add;
        this.execute_remove = e_remove == null ? nullArray : e_remove;
        this.invoke();
    }

    public String description() throws ToolsException {
        return this.msg("CHMOD_DESCRIPTION", null);
    }

    public String help() throws ToolsException {
        return this.msg("CHMOD_HELP", null);
    }

    protected void invoke() throws ToolsException {
        try {
            Context dir = ToolImpl.wd.lookupParent(this.name);
            Object o = dir.lookup(ToolImpl.wd.last(this.name));
            if (o instanceof SessionCtx) {
                this.setRights((SessionCtx)o);
            } else {
                this.setRights((PublishedObject)o);
            }
        }
        catch (NamingException e) {
            this.fail2("CANNOT_CHMOD", this.name.toString(), e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            new Chmod().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private String[] merge(String[] base, String[] add, String[] remove) {
        Hashtable<String, String> set = new Hashtable<String, String>();
        int i = 0;
        while (i < base.length) {
            ((Dictionary)set).put(base[i].toUpperCase(), base[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < add.length) {
            ((Dictionary)set).put(add[i2].toUpperCase(), add[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < remove.length) {
            ((Dictionary)set).remove(remove[i3].toUpperCase());
            ++i3;
        }
        Enumeration e = ((Dictionary)set).keys();
        String[] rslt = new String[((Dictionary)set).size()];
        int i4 = 0;
        while (i4 < rslt.length) {
            rslt[i4] = (String)e.nextElement();
            ++i4;
        }
        return rslt;
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        boolean something = false;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("+r")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.read_add = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("-r")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.read_remove = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("+w")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.write_add = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("-w")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.write_remove = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("+e")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.execute_add = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("-e")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                this.execute_remove = this.parseCommaDelimited(argv[i]);
            } else if (argv[i].equals("+rw") || argv[i].equals("+wr")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] rw_add = this.parseCommaDelimited(argv[i]);
                this.read_add = rw_add;
                this.write_add = rw_add;
            } else if (argv[i].equals("+re") || argv[i].equals("+er")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] re_add = this.parseCommaDelimited(argv[i]);
                this.read_add = re_add;
                this.execute_add = re_add;
            } else if (argv[i].equals("+we") || argv[i].equals("+ew")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] we_add = this.parseCommaDelimited(argv[i]);
                this.write_add = we_add;
                this.execute_add = we_add;
            } else if (argv[i].equals("+rwe") || argv[i].equals("+rew") || argv[i].equals("+wer") || argv[i].equals("+wre") || argv[i].equals("+ewr") || argv[i].equals("+erw")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] rwe_add = this.parseCommaDelimited(argv[i]);
                this.read_add = rwe_add;
                this.write_add = rwe_add;
                this.execute_add = rwe_add;
            } else if (argv[i].equals("-rw") || argv[i].equals("-wr")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] rw_revoke = this.parseCommaDelimited(argv[i]);
                this.read_remove = rw_revoke;
                this.write_remove = rw_revoke;
            } else if (argv[i].equals("-re") || argv[i].equals("-er")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] re_revoke = this.parseCommaDelimited(argv[i]);
                this.read_remove = re_revoke;
                this.execute_remove = re_revoke;
            } else if (argv[i].equals("-we") || argv[i].equals("-ew")) {
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] we_revoke = this.parseCommaDelimited(argv[i]);
                this.write_remove = we_revoke;
                this.execute_remove = we_revoke;
            } else {
                if (!argv[i].equals("-rwe") && !argv[i].equals("-rew") && !argv[i].equals("-wer") && !argv[i].equals("-wre") && !argv[i].equals("-ewr") && !argv[i].equals("-erw")) break;
                if (++i == argv.length) {
                    this.error(this.usage());
                }
                String[] rwe_revoke = this.parseCommaDelimited(argv[i]);
                this.read_remove = rwe_revoke;
                this.write_remove = rwe_revoke;
                this.execute_remove = rwe_revoke;
            }
            something = true;
            ++i;
        }
        if (argv.length == i) {
            this.error(this.usage());
        }
        this.name = ToolImpl.local_wd.parse(argv[i]);
    }

    private void setRights(PublishedObject o) throws ToolsException {
        objAttribsHolder attribs = new objAttribsHolder();
        o.get_attributes(attribs);
        String[] read = new String[]{};
        String[] write = new String[]{};
        String[] execute = new String[]{};
        if (this.read_add.length > 0 || this.read_remove.length > 0) {
            read = this.merge(attribs.value.read, this.read_add, this.read_remove);
        }
        if (this.write_add.length > 0 || this.write_remove.length > 0) {
            write = this.merge(attribs.value.write, this.write_add, this.write_remove);
        }
        if (this.execute_add.length > 0 || this.execute_remove.length > 0) {
            execute = this.merge(attribs.value.execute, this.execute_add, this.execute_remove);
        }
        try {
            o.set_attributes(null, read, write, execute);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.fail0("NO_PERMISSION_TO_CHANGE_RIGHTS");
        }
    }

    private void setRights(SessionCtx ctx) throws ToolsException {
        ctxAttribs attribs = ctx.get_attributes();
        String[] read = new String[]{};
        String[] write = new String[]{};
        String[] execute = new String[]{};
        if (this.read_add.length > 0 || this.read_remove.length > 0) {
            read = this.merge(attribs.read, this.read_add, this.read_remove);
        }
        if (this.write_add.length > 0 || this.write_remove.length > 0) {
            write = this.merge(attribs.write, this.write_add, this.write_remove);
        }
        if (this.execute_add.length > 0 || this.execute_remove.length > 0) {
            execute = this.merge(attribs.execute, this.execute_add, this.execute_remove);
        }
        try {
            ctx.set_attributes(null, read, write, execute);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.fail0("NO_PERMISSION_TO_CHANGE_RIGHTS");
        }
    }

    public String usage() throws ToolsException {
        return this.msg("CHMOD_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("CHMOD_VERSION", null);
    }
}

