/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.persistence.ocmp;

import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.ejb.EJBMetaData;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import oracle.aurora.ejb.persistence.PersistenceKey;
import oracle.aurora.ejb.persistence.PersistenceManagement;
import oracle.aurora.ejb.persistence.PmException;
import oracle.aurora.ejb.persistence.ocmp.OcmpEntitySynchronization;
import oracle.aurora.ejb.persistence.ocmp.OcmpHashtable;
import oracle.aurora.ejb.persistence.ocmp.OcmpSqlEngine;
import oracle.aurora.ejb.server.AuroraEntityContext;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Unavailable;

public abstract class OcmpManager
implements PersistenceManagement {
    protected OcmpSqlEngine engine;
    EntityBean fakeBean;
    protected OcmpHashtable beanTable = new OcmpHashtable();
    String previousTxn;

    protected void clearRegisteredSynchronization(PersistenceKey pk, String txName) {
        this.beanTable.remove(txName, pk);
    }

    public PersistenceKey create(EntityBean bean, Object primaryKey) throws PmException {
        PersistenceKey sk;
        try {
            sk = this.engine.insert(bean);
        }
        catch (SQLException e) {
            throw new PmException(e.getMessage());
        }
        return sk;
    }

    public PersistenceKey findByPrimaryKey(EntityContext context, Object arg0) throws RemoteException, FinderException {
        try {
            return this.engine.findByPrimaryKey(arg0);
        }
        catch (SQLException e) {
            throw new PmException(e.getMessage());
        }
    }

    public EntityBean getBean(PersistenceKey persistenceKey, EntityContext ctx) throws RemoteException, PmException {
        this.previousTxn = this.getCurrentTransactionName();
        EntityBean b = this.beanTable.getBean(this.previousTxn, persistenceKey);
        if (b == null) {
            b = this.getNewBeanInstance();
            ((AuroraEntityContext)ctx).setPrimaryKey(persistenceKey.getPrimaryKey());
            b.setEntityContext(ctx);
            try {
                this.engine.load(b, persistenceKey);
            }
            catch (SQLException e) {
                throw new PmException(e.getMessage());
            }
            b.ejbLoad();
            this.registerSynchronization(b, persistenceKey, this.previousTxn);
            this.beanTable.put(this.previousTxn, persistenceKey, b);
        }
        return b;
    }

    protected String getCurrentTransactionName() throws IllegalStateException {
        try {
            return TS.getTS().getCurrent().get_transaction_name();
        }
        catch (NoTransactionServiceException noTransactionServiceException) {
            throw new IllegalStateException("No Transaction Service is available");
        }
    }

    protected EntityBean getFakeBean(EntityContext ctx) throws RemoteException, PmException {
        if (this.fakeBean == null) {
            this.fakeBean = this.getNewBeanInstance();
            this.fakeBean.setEntityContext(ctx);
        }
        return this.fakeBean;
    }

    public abstract EntityBean getNewBeanInstance() throws PmException;

    protected void registerSynchronization(EntityBean b, PersistenceKey pk, String txName) {
        try {
            Control current = TS.getTS().getCurrent().get_control();
            if (current == null) {
                return;
            }
            current.get_coordinator().register_synchronization(new OcmpEntitySynchronization(b, this, pk, txName, this.engine));
        }
        catch (NoTransactionServiceException noTransactionServiceException) {
        }
        catch (SynchronizationUnavailable synchronizationUnavailable) {
        }
        catch (Unavailable unavailable) {
        }
        catch (Inactive inactive) {}
    }

    public void remove(PersistenceKey persistenceKey) throws PmException {
        try {
            this.engine.delete(persistenceKey);
            this.beanTable.purge(persistenceKey);
        }
        catch (SQLException e) {
            throw new PmException(e.getMessage());
        }
    }

    public void shutdown() throws PmException {
    }

    public void startup(EJBMetaData ejbdata) throws PmException {
    }
}

