/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import sun.io.CharToByteConverter;

public class OracleOutputStreamWriter
extends OutputStreamWriter {
    private static final int MAXCHAR = 127;
    private CharToByteConverter m_encoding;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private char[] carr = new char[]{'\\', 'u', '0', '0', '0', '0'};

    public OracleOutputStreamWriter(OutputStream out) throws UnsupportedEncodingException {
        this(out, System.getProperty("file.encoding"));
    }

    public OracleOutputStreamWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding != null && encoding.equals("Unicode") && System.getProperty("os.arch").equals("x86") ? (encoding = "UnicodeLittle") : encoding);
        try {
            this.m_encoding = CharToByteConverter.getConverter((String)encoding);
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException("Encoding " + encoding + " not supported, " + "or sun.io.CharToByteConverter unavailable");
        }
    }

    public static String getEscape(int c) {
        char[] carr = new char[6];
        carr[0] = 92;
        carr[1] = 117;
        int b = c / 256;
        carr[2] = hex[b / 16];
        carr[3] = hex[b % 16];
        b = c % 256;
        carr[4] = hex[b / 16];
        carr[5] = hex[b % 16];
        return new String(carr);
    }

    public void write(int c) throws IOException {
        if (c > 127 && !this.m_encoding.canConvert((char)c)) {
            this.writeEscape(c);
        } else {
            super.write(c);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (str == null) {
            return;
        }
        int max = off + len;
        int i = off;
        while (i < max) {
            char c = str.charAt(i);
            if (c > '\u007f' && !this.m_encoding.canConvert(c)) {
                if (i > off) {
                    super.write(str, off, i - off);
                }
                this.writeEscape(c);
                off = ++i;
                continue;
            }
            ++i;
        }
        if (max > off) {
            super.write(str, off, max - off);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int max = off + len;
        int i = off;
        while (i < max) {
            if (cbuf[i] > '\u007f' && !this.m_encoding.canConvert(cbuf[i])) {
                if (i > off) {
                    super.write(cbuf, off, i - off);
                }
                this.writeEscape(cbuf[i]);
                off = ++i;
                continue;
            }
            ++i;
        }
        if (max > off) {
            super.write(cbuf, off, max - off);
        }
    }

    private void writeEscape(int c) throws IOException {
        int b = c / 256;
        this.carr[2] = hex[b / 16];
        this.carr[3] = hex[b % 16];
        b = c % 256;
        this.carr[4] = hex[b / 16];
        this.carr[5] = hex[b % 16];
        super.write(this.carr, 0, 6);
    }
}

