/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.security.Identity;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import javax.naming.Name;
import oracle.aurora.ejb.parser.BothDescriptors;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.Util;

public class DescriptorDumper {
    public static void dumpClass(PrintWriter out, int indentation, Class clazz) {
        int dimension = 0;
        Class<?> realClazz = clazz;
        while (realClazz.isArray()) {
            ++dimension;
            realClazz = realClazz.getComponentType();
        }
        Util.dumpString(out, realClazz.getName());
        while (dimension != 0) {
            out.print("[]");
            --dimension;
        }
    }

    public static void dumpDescriptor(PrintWriter out, int indentation, BothDescriptors defaultBothDescriptors, BothDescriptors descriptor) throws Exception {
        Identity[] allowedIdentities;
        if (descriptor.control != null) {
            Identity runAsIdentity;
            int isolationLevel;
            String value;
            int transactionAttribute = descriptor.control.getTransactionAttribute();
            if (transactionAttribute != defaultBothDescriptors.control.getTransactionAttribute()) {
                switch (transactionAttribute) {
                    case 1: {
                        value = "TX_BEAN_MANAGED";
                        break;
                    }
                    case 5: {
                        value = "TX_MANDATORY";
                        break;
                    }
                    case 0: {
                        value = "TX_NOT_SUPPORTED";
                        break;
                    }
                    case 2: {
                        value = "TX_REQUIRED";
                        break;
                    }
                    case 4: {
                        value = "TX_REQUIRES_NEW";
                        break;
                    }
                    case 3: {
                        value = "TX_SUPPORTS";
                        break;
                    }
                    default: {
                        ParseError.TRANSACTION_ATTRIBUTE_NOT_VALID(Integer.toString(transactionAttribute));
                        return;
                    }
                }
                DescriptorDumper.dumpProperty(out, indentation, "TransactionAttribute", value);
            }
            if ((isolationLevel = descriptor.control.getIsolationLevel()) != defaultBothDescriptors.control.getIsolationLevel()) {
                switch (isolationLevel) {
                    case 2: {
                        value = "TRANSACTION_READ_COMMITTED";
                        break;
                    }
                    case 1: {
                        value = "TRANSACTION_READ_UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        value = "TRANSACTION_REPEATABLE_READ";
                        break;
                    }
                    case 8: {
                        value = "TRANSACTION_SERIALIZABLE";
                        break;
                    }
                    default: {
                        ParseError.ISOLATION_LEVEL_NOT_VALID(Integer.toString(isolationLevel));
                        return;
                    }
                }
                DescriptorDumper.dumpProperty(out, indentation, "IsolationLevel", value);
            }
            int runAsMode = descriptor.control.getRunAsMode();
            switch (runAsMode) {
                case 0: {
                    value = "CLIENT_IDENTITY";
                    break;
                }
                case 1: {
                    value = "SPECIFIED_IDENTITY";
                    break;
                }
                case 2: {
                    value = "SYSTEM_IDENTITY";
                    break;
                }
                default: {
                    ParseError.RUN_AS_MODE_NOT_VALID(Integer.toString(runAsMode));
                    return;
                }
            }
            DescriptorDumper.dumpProperty(out, indentation, "RunAsMode", value);
            if (runAsMode == 1 && (runAsIdentity = descriptor.control.getRunAsIdentity()) != defaultBothDescriptors.control.getRunAsIdentity() && runAsIdentity != null) {
                DescriptorDumper.dumpProperty(out, indentation, "RunAsIdentity", runAsIdentity.getName());
            }
        }
        if (descriptor.access != null && (allowedIdentities = descriptor.access.getAllowedIdentities()) != defaultBothDescriptors.access.getAllowedIdentities() && allowedIdentities != null) {
            Util.indent(out, indentation);
            out.print("AllowedIdentities = { ");
            int i = 0;
            while (i < allowedIdentities.length) {
                if (i != 0) {
                    out.print(", ");
                }
                Util.dumpString(out, allowedIdentities[i].getName());
                ++i;
            }
            out.println(" };");
        }
    }

    public static void dumpDescriptor(PrintWriter out, DeploymentDescriptor descriptor) throws Exception {
        DescriptorDumper.dumpDescriptor1(out, 0, descriptor);
    }

    public static void dumpDescriptor1(PrintWriter out, int indentation, DeploymentDescriptor descriptor) throws Exception {
        DeploymentDescriptor defaultDescriptor;
        boolean sessionp;
        if (descriptor instanceof SessionDescriptor) {
            sessionp = true;
            defaultDescriptor = new SessionDescriptor();
        } else if (descriptor instanceof EntityDescriptor) {
            sessionp = false;
            defaultDescriptor = new EntityDescriptor();
        } else {
            ParseError.NO_SUCH_BEAN_TYPE(descriptor.getClass().toString());
            return;
        }
        Util.indent(out, indentation);
        out.print(sessionp ? "SessionBean " : "EntityBean ");
        Util.dumpString(out, descriptor.getEnterpriseBeanClassName());
        out.println();
        Util.indent(out, indentation);
        out.println("{");
        Name beanHomeName = descriptor.getBeanHomeName();
        DescriptorDumper.dumpProperty(out, indentation + 1, "BeanHomeName", beanHomeName == null ? "<null>" : beanHomeName.toString());
        DescriptorDumper.dumpProperty(out, indentation + 1, "HomeInterfaceClassName", descriptor.getHomeInterfaceClassName());
        DescriptorDumper.dumpProperty(out, indentation + 1, "RemoteInterfaceClassName", descriptor.getRemoteInterfaceClassName());
        if (descriptor.getReentrant() != defaultDescriptor.getReentrant()) {
            DescriptorDumper.dumpProperty(out, indentation + 1, "Reentrant", descriptor.getReentrant() ? "true" : "false");
        }
        out.println();
        if (sessionp) {
            DescriptorDumper.dumpSessionBeanProperties(out, indentation + 1, (SessionDescriptor)defaultDescriptor, (SessionDescriptor)descriptor);
        } else {
            DescriptorDumper.dumpEntityBeanProperties(out, indentation + 1, (EntityDescriptor)defaultDescriptor, (EntityDescriptor)descriptor);
        }
        DescriptorDumper.dumpDescriptors(out, indentation + 1, descriptor.getAccessControlEntries(), descriptor.getControlDescriptors());
        out.println();
        Properties properties = descriptor.getEnvironmentProperties();
        if (properties != null) {
            DescriptorDumper.dumpEnvironmentProperties(out, indentation + 1, properties);
        }
        Util.indent(out, indentation);
        out.println("}");
    }

    public static void dumpDescriptors(PrintWriter out, int indentation, AccessControlEntry[] accesses, ControlDescriptor[] controls) throws Exception {
        BothDescriptors methodDescriptor;
        Method method;
        int i;
        BothDescriptors defaultBothDescriptors = new BothDescriptors();
        defaultBothDescriptors.control = new ControlDescriptor();
        defaultBothDescriptors.access = new AccessControlEntry();
        BothDescriptors beanDescriptor = new BothDescriptors();
        Hashtable<Method, BothDescriptors> table = new Hashtable<Method, BothDescriptors>();
        if (controls != null) {
            i = 0;
            while (i < controls.length) {
                method = controls[i].getMethod();
                if (method == null) {
                    if (beanDescriptor.control != null) {
                        ParseError.TOO_MANY_BEAN_CONTROL_DESCRIPTORS();
                        return;
                    }
                    beanDescriptor.control = controls[i];
                } else {
                    methodDescriptor = (BothDescriptors)table.get(method);
                    if (methodDescriptor == null) {
                        methodDescriptor = new BothDescriptors();
                        table.put(method, methodDescriptor);
                    }
                    if (methodDescriptor.control != null) {
                        ParseError.TOO_MANY_METHOD_CONTROL_DESCRIPTORS(method.getName());
                        return;
                    }
                    methodDescriptor.control = controls[i];
                }
                ++i;
            }
        }
        if (accesses != null) {
            i = 0;
            while (i < accesses.length) {
                method = accesses[i].getMethod();
                if (method == null) {
                    if (beanDescriptor.access != null) {
                        ParseError.TOO_MANY_BEAN_ACCESS_DESCRIPTORS();
                        return;
                    }
                    beanDescriptor.access = accesses[i];
                } else {
                    methodDescriptor = (BothDescriptors)table.get(method);
                    if (methodDescriptor == null) {
                        methodDescriptor = new BothDescriptors();
                        table.put(method, methodDescriptor);
                    }
                    if (methodDescriptor.access != null) {
                        ParseError.TOO_MANY_METHOD_ACCESS_DESCRIPTORS(method.getName());
                        return;
                    }
                    methodDescriptor.access = accesses[i];
                }
                ++i;
            }
        }
        DescriptorDumper.dumpDescriptor(out, indentation, defaultBothDescriptors, beanDescriptor);
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            out.println();
            method = (Method)keys.nextElement();
            BothDescriptors descriptor = (BothDescriptors)table.get(method);
            Util.indent(out, indentation);
            DescriptorDumper.dumpMethodPrototype(out, indentation, method);
            out.println();
            Util.indent(out, indentation);
            out.println("{");
            DescriptorDumper.dumpDescriptor(out, indentation + 1, defaultBothDescriptors, descriptor);
            Util.indent(out, indentation);
            out.println("}");
        }
    }

    public static void dumpEntityBeanProperties(PrintWriter out, int indentation, DeploymentDescriptor defaultDescriptor, DeploymentDescriptor descriptor) {
    }

    public static void dumpEnvironmentProperties(PrintWriter out, int indentation, Properties properties) {
        Util.indent(out, indentation);
        out.println("EnvironmentProperties");
        Util.indent(out, indentation);
        out.println("{");
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            DescriptorDumper.dumpProperty(out, indentation + 1, name, value);
        }
        Util.indent(out, indentation);
        out.println("}");
    }

    public static void dumpMethodPrototype(PrintWriter out, int indentation, Method method) {
        DescriptorDumper.dumpClass(out, indentation, method.getReturnType());
        out.print(" ");
        Util.dumpString(out, method.getName());
        out.print(" (");
        Class<?>[] argumentTypes = method.getParameterTypes();
        int i = 0;
        while (i < argumentTypes.length) {
            if (i != 0) {
                out.print(", ");
            }
            DescriptorDumper.dumpClass(out, indentation, argumentTypes[i]);
            ++i;
        }
        out.print(")");
    }

    public static void dumpProperty(PrintWriter out, int indentation, String name, String value) {
        Util.indent(out, indentation);
        Util.dumpString(out, name);
        out.print(" = ");
        Util.dumpString(out, value);
        out.println(";");
    }

    public static void dumpSessionBeanProperties(PrintWriter out, int indentation, SessionDescriptor defaultDescriptor, SessionDescriptor descriptor) {
        DescriptorDumper.dumpProperty(out, indentation, "SessionTimeout", Integer.toString(descriptor.getSessionTimeout()));
        int type = descriptor.getStateManagementType();
        if (type == 0) {
            DescriptorDumper.dumpProperty(out, indentation, "StateManagementType", "STATELESS_SESSION");
        } else if (type == 1) {
            DescriptorDumper.dumpProperty(out, indentation, "StateManagementType", "STATEFUL_SESSION");
        } else {
            DescriptorDumper.dumpProperty(out, indentation, "StateManagementType", Integer.toString(type));
        }
        out.println();
    }
}

