/*
 * Decompiled with CFR 0.152.
 */
package md5;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import md5.MD5;
import md5.MD5InputStream;

class MD5TestSuite {
    MD5TestSuite() {
    }

    public static void main(String[] args) {
        String file = "MD5.java";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-t")) {
                MD5TestSuite.testtimetrial();
            } else if (args[i].equals("-x")) {
                MD5TestSuite.testsuite();
            } else if (args[i].equals("-s")) {
                if (i + 1 < args.length) {
                    MD5TestSuite.teststring(args[i + 1], null);
                    ++i;
                }
            } else {
                MD5TestSuite.testfile(args[i]);
            }
            ++i;
        }
        if (args.length == 0) {
            MD5TestSuite.teststream(null, System.in);
        }
    }

    private static void printHex(byte b) {
        if ((b & 0xFF) < 16) {
            System.out.print("0");
        }
        System.out.print(Long.toString(b & 0xFF, 16));
    }

    public static void testfile(String file) {
        try {
            FileInputStream in = new FileInputStream(file);
            MD5TestSuite.teststream(file, in);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File \"" + file + "\" not found");
        }
    }

    public static void teststream(String file, InputStream in) {
        int l;
        byte[] buf = new byte[512];
        int count = 0;
        MD5InputStream md5in = new MD5InputStream(in);
        do {
            try {
                l = md5in.read();
                ++count;
            }
            catch (IOException iOException) {
                l = -1;
            }
        } while (l >= 0);
        if (file != null) {
            System.out.print(String.valueOf(file) + ": ");
        }
        System.out.println(MD5.asHex(md5in.hash()));
    }

    private static void teststring(String s, String real) {
        MD5 md5 = new MD5();
        System.out.print("MD5(\"" + s + "\") = ");
        md5.Init();
        md5.Update(s);
        String hex = md5.asHex();
        if (real == null || hex.equals(real)) {
            System.out.println(hex);
        } else {
            System.out.println(String.valueOf(hex) + " should be " + real);
        }
    }

    public static void testsuite() {
        MD5TestSuite.teststring("", "d41d8cd98f00b204e9800998ecf8427e");
        MD5TestSuite.teststring("a", "0cc175b9c0f1b6a831c399e269772661");
        MD5TestSuite.teststring("abc", "900150983cd24fb0d6963f7d28e17f72");
        MD5TestSuite.teststring("message digest", "f96b697d7cb7938d525a2f31aaf161d0");
        MD5TestSuite.teststring("abcdefghijklmnopqrstuvwxyz", "c3fcd3d76192e4007dfb496cca67e13b");
        MD5TestSuite.teststring("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "d174ab98d277d9f5a5611c2c9f419d9f");
        MD5TestSuite.teststring("12345678901234567890123456789012345678901234567890123456789012345678901234567890", "57edf4a22be3c955ac49da2e2107b67a");
    }

    public static void testtimetrial() {
        int test_block_len = 1000;
        int test_block_count = 1000;
        byte[] block = new byte[test_block_len];
        System.out.print("MD5 time trial. Digesting " + test_block_count + " " + test_block_len + "-byte blocks ...");
        int i = 0;
        while (i < block.length) {
            block[i] = (byte)(i & 0xFF);
            ++i;
        }
        long start = System.currentTimeMillis();
        MD5 md5 = new MD5();
        i = 0;
        while (i < test_block_count) {
            md5.Update(block, test_block_len);
            ++i;
        }
        byte[] hash = md5.Final();
        long end = System.currentTimeMillis();
        System.out.print(" done\nDigest = " + md5.asHex() + "\nTime = " + (end - start) / 1000L + " seconds\n");
        System.out.print("Speed = " + (long)(test_block_len * test_block_count) / ((end - start) / 1000L) + " bytes/second\n");
    }
}

