/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.security;

import com.sun.symon.base.utility.UcDDL;
import java.security.MessageDigest;

public class SyKeyHashAuthentication {
    private MessageDigest md;
    private byte[] inner;
    private byte[] outer;
    private static final int BLOCK_LENGTH = 64;

    public SyKeyHashAuthentication(byte[] byArray) {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage("unable to get MD5 algorithm", exception);
            return;
        }
        this.md.update(byArray);
        byte[] byArray2 = this.md.digest();
        byte[] byArray3 = new byte[64];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        this.inner = new byte[64];
        this.outer = new byte[64];
        int n = 0;
        while (n < 64) {
            this.inner[n] = (byte)(0x36 ^ byArray3[n]);
            this.outer[n] = (byte)(0x5C ^ byArray3[n]);
            ++n;
        }
    }

    public synchronized byte[] sign(byte[] byArray) {
        this.md.update(this.inner);
        byte[] byArray2 = this.md.digest(byArray);
        this.md.update(this.outer);
        return this.md.digest(byArray2);
    }

    public boolean verify(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.sign(byArray);
        if (byArray3 == null || byArray2 == null || byArray3.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray3.length) {
            if (byArray3[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

