/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.tcp;

import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.receptors.SrRequest;
import com.sun.symon.base.server.receptors.SrSession;
import com.sun.symon.base.server.receptors.tcp.SrTCPReceptor;
import com.sun.symon.base.server.types.StBytes;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SrTCPSession
extends SrSession
implements Runnable {
    private OutputStream output = null;
    private InputStream input = null;
    SrTCPReceptor receptor = null;
    Thread session = null;

    public SrTCPSession(Socket socket, SrTCPReceptor srTCPReceptor) {
        super(srTCPReceptor);
        try {
            this.output = socket.getOutputStream();
            this.input = socket.getInputStream();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"failed to get socket streams");
            return;
        }
        this.receptor = srTCPReceptor;
        this.session = new Thread(this);
        this.session.start();
    }

    public ScSecurityCredential getUserTicket() {
        return null;
    }

    protected void requestResponse(SrRequest srRequest, String string, Exception exception) {
        UcDDL.logErrorMessage((String)("Got exception: " + exception));
    }

    public void requestResponse(SrRequest srRequest, StObject[][] stObjectArray) {
        StBytes stBytes = (StBytes)stObjectArray[0][0];
        try {
            this.output.write(stBytes.getValue());
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"write socket failed");
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        thread.setPriority(10);
        while (true) {
            byte[] byArray = new byte[128];
            try {
                int n = this.input.read(byArray);
                if (n == -1) {
                    UcDDL.logWarningMessage((String)"end of input stream");
                    this.session = null;
                    return;
                }
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("read socket failed " + exception));
                this.session = null;
                return;
            }
            String[] stringArray = new String[]{"echo://capilano:161/hello+world"};
            StObject[][] stObjectArrayArray = new StObject[][]{{new StBytes(byArray)}};
            this.requestCreate(0, stringArray, stObjectArrayArray, null).emit();
        }
    }
}

