/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors;

import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.receptors.SrRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;

public abstract class SrSession {
    private SrSession Prev;
    SrSession Next;
    private SrReceptor Receptor;
    private boolean Dead;
    private SrRequest RequestHead;
    int Num;
    private Date Start;
    private static Object lock = new Object();

    public SrSession(SrReceptor srReceptor) {
        this.Receptor = srReceptor;
        this.Dead = false;
        this.RequestHead = null;
        Object object = lock;
        synchronized (object) {
            this.Next = this.Receptor.Head;
            if (this.Next != null) {
                this.Next.Prev = this;
            }
            this.Receptor.Head = this;
            this.Prev = null;
            this.Num = ++this.Receptor.Count;
        }
        this.Start = new Date();
    }

    public boolean died(Exception exception) {
        Vector<Object> vector;
        SrSession srSession = this;
        synchronized (srSession) {
            if (this.Dead) {
                boolean bl = false;
                Object var5_6 = null;
                return bl;
            }
            Object object = lock;
            synchronized (object) {
                if (this.Prev == null) {
                    this.Receptor.Head = this.Next;
                } else {
                    this.Prev.Next = this.Next;
                }
                if (this.Next != null) {
                    this.Next.Prev = this.Prev;
                }
            }
            this.Dead = true;
            object = this.RequestHead;
            this.RequestHead = null;
            vector = new Vector<Object>();
            while (object != null) {
                ((SrRequest)object).deleteMark();
                vector.addElement(object);
                object = ((SrRequest)object).getNext();
            }
        }
        UcDDL.logErrorMessage((String)("Client died: " + exception));
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SrRequest srRequest = (SrRequest)vector.elementAt(n2);
            srRequest.deleteDirect();
            this.requestDone(srRequest);
            ++n2;
        }
        return true;
    }

    protected void dump(PrintWriter printWriter) {
        printWriter.println("  type=" + this.getClass().getName());
        long l = (new Date().getTime() - this.Start.getTime()) / 1000L;
        printWriter.println("  birth=" + this.Start + " (" + l + " seconds ago)");
        SrRequest srRequest = this.RequestHead;
        if (srRequest == null) {
            printWriter.println("  requests=<none>");
        } else {
            printWriter.println("  requests=");
        }
        while (srRequest != null) {
            srRequest.dump(printWriter);
            srRequest = srRequest.getNext();
        }
    }

    final SrRequest getHead() {
        return this.RequestHead;
    }

    public SrReceptor getReceptor() {
        return this.Receptor;
    }

    protected abstract ScSecurityCredential getUserTicket();

    public synchronized boolean isDead() {
        return this.Dead;
    }

    public SrRequest requestCreate(int n, String[] stringArray, StObject[][] stObjectArray, String string) {
        SrRequest srRequest;
        SrSession srSession = this;
        synchronized (srSession) {
            srRequest = new SrRequest(this, this.getHead(), string, this.getUserTicket(), n, stringArray, stObjectArray);
            this.requestInit(srRequest);
        }
        srRequest.dispatch();
        return srRequest;
    }

    public void requestDelete(SrRequest srRequest) {
        srRequest.delete();
    }

    void requestDone(SrRequest srRequest) {
        if (srRequest == this.RequestHead) {
            this.RequestHead = srRequest.getNext();
        }
    }

    protected void requestInit(SrRequest srRequest) {
        this.RequestHead = srRequest;
    }

    protected abstract void requestResponse(SrRequest var1, String var2, Exception var3);

    protected abstract void requestResponse(SrRequest var1, StObject[][] var2);
}

