/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration;

import com.sun.symon.tools.migration.TmMigrationException;
import com.sun.symon.tools.migration.datasource.MdAttribute;
import com.sun.symon.tools.migration.datasource.MdDataSource;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdTable;
import com.sun.symon.tools.migration.datasource.MdTableSpace;
import com.sun.symon.tools.migration.function.MfFunction;
import com.sun.symon.tools.migration.xml.MxMissingNodeException;
import com.sun.symon.tools.migration.xml.MxNodeHandler;
import com.sun.symon.tools.migration.xml.MxNodeRecursor;
import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TmXMLMapReader {
    private Properties functions = new Properties();
    private Properties dataSources = new Properties();
    private MdTableSpace sourceMdTableSpace;
    private MdTableSpace targetMdTableSpace;
    private MdTableSpace currentMdTableSpace;
    private MdTable currentMdTable;

    public TmXMLMapReader(File file) throws IOException, SAXException, TmMigrationException {
        InputSource inputSource = Resolver.createInputSource((File)file);
        XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)false);
        MxNodeRecursor mxNodeRecursor = new MxNodeRecursor(xmlDocument.getDocumentElement(), null);
        mxNodeRecursor.bind("map.import.function", new MfFunctionHandler());
        mxNodeRecursor.bind("map.import.datasource", new MdDataSourceHandler());
        mxNodeRecursor.bind("map.tablespace", new MdTableSpaceHandler());
        mxNodeRecursor.bind("map.tablespace.datasource", new MdTableSpaceMdDataSourceHandler());
        mxNodeRecursor.bind("map.tablespace.table", new MdTableHandler());
        mxNodeRecursor.bind("map.tablespace.table.datasource", new MdTableMdDataSourceHandler());
        mxNodeRecursor.bind("map.tablespace.table.attribute", new MdAttributeHandler());
        mxNodeRecursor.recurse();
    }

    public TmXMLMapReader(String string) throws IOException, SAXException, TmMigrationException {
        this(new File(string.replace('/', File.separatorChar)));
    }

    private static String getMdAttribute(String string, NamedNodeMap namedNodeMap, String string2, boolean bl) throws MxMissingNodeException {
        Node node = namedNodeMap.getNamedItem(string2);
        if (node == null) {
            if (bl) {
                throw new MxMissingNodeException(string, string2);
            }
            return null;
        }
        return node.getNodeValue();
    }

    private static String getMdAttribute(String string, Node node, String string2, boolean bl) throws MxMissingNodeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string2);
        if (node2 == null) {
            if (bl) {
                throw new MxMissingNodeException(string, string2);
            }
            return null;
        }
        return node2.getNodeValue();
    }

    public Properties getMdDataSources() {
        return this.dataSources;
    }

    public Properties getMfFunctions() {
        return this.functions;
    }

    public MdTableSpace getSourceMdTableSpace() {
        return this.sourceMdTableSpace;
    }

    public MdTableSpace getTargetMdTableSpace() {
        return this.targetMdTableSpace;
    }

    public static void main(String[] stringArray) throws Exception {
        new TmXMLMapReader(".\\test.xml");
    }

    public void registerMdDataSources() throws Exception {
        Enumeration enumeration = ((Hashtable)this.dataSources).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.dataSources.getProperty(string);
            MdDataSource.bind(string, string2);
        }
    }

    public void registerMfFunctions() throws Exception {
        Enumeration enumeration = ((Hashtable)this.functions).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.functions.getProperty(string);
            MfFunction.bind(string, string2);
        }
    }

    class MfFunctionHandler
    implements MxNodeHandler {
        MfFunctionHandler() {
        }

        public void handleNode(String string, Node node) throws TmMigrationException {
            String string2 = TmXMLMapReader.getMdAttribute(string, node, "NAME", true);
            String string3 = TmXMLMapReader.getMdAttribute(string, node, "CLASS", true);
            TmXMLMapReader.this.functions.setProperty(string2, string3);
        }
    }

    class MdDataSourceHandler
    implements MxNodeHandler {
        MdDataSourceHandler() {
        }

        public void handleNode(String string, Node node) throws TmMigrationException {
            String string2 = TmXMLMapReader.getMdAttribute(string, node, "TYPE", true);
            String string3 = TmXMLMapReader.getMdAttribute(string, node, "CLASS", true);
            TmXMLMapReader.this.dataSources.setProperty(string2, string3);
        }
    }

    class MdTableSpaceHandler
    implements MxNodeHandler {
        MdTableSpaceHandler() {
        }

        public void handleNode(String string, Node node) throws TmMigrationException {
            String string2 = TmXMLMapReader.getMdAttribute(string, node, "NAME", true);
            TmXMLMapReader.this.currentMdTableSpace = MdTableSpace.newInstance(string2, null, null);
            if (TmXMLMapReader.this.sourceMdTableSpace == null) {
                TmXMLMapReader.this.sourceMdTableSpace = TmXMLMapReader.this.currentMdTableSpace;
            } else if (TmXMLMapReader.this.targetMdTableSpace == null) {
                TmXMLMapReader.this.targetMdTableSpace = TmXMLMapReader.this.currentMdTableSpace;
            } else {
                throw new TmMigrationException("Too many tablespaces: " + string2);
            }
        }
    }

    class MdTableSpaceMdDataSourceHandler
    implements MxNodeHandler {
        MdTableSpaceMdDataSourceHandler() {
        }

        public void handleNode(String string, Node node) throws TmMigrationException {
            NamedNodeMap namedNodeMap;
            MdDataSourceProperties mdDataSourceProperties = TmXMLMapReader.this.currentMdTableSpace.getMdDataSourceProperties();
            String string2 = TmXMLMapReader.getMdAttribute(string, node, "TYPE", false);
            if (string2 != null) {
                mdDataSourceProperties.setType(string2);
            }
            if ((namedNodeMap = node.getAttributes()) != null) {
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    mdDataSourceProperties.setProperty(node2.getNodeName().toLowerCase(), node2.getNodeValue());
                    ++n;
                }
            }
        }
    }

    class MdTableHandler
    implements MxNodeHandler {
        MdTableHandler() {
        }

        public void handleNode(String string, Node node) throws TmMigrationException {
            String string2 = TmXMLMapReader.getMdAttribute(string, node, "NAME", true);
            String string3 = TmXMLMapReader.getMdAttribute(string, node, "PRE", false);
            String string4 = TmXMLMapReader.getMdAttribute(string, node, "POST", false);
            TmXMLMapReader.this.currentMdTable = TmXMLMapReader.this.currentMdTableSpace.newMdTable(string2);
            TmXMLMapReader.this.currentMdTable.setPreSource(string3);
            TmXMLMapReader.this.currentMdTable.setPostSource(string4);
        }
    }

    class MdTableMdDataSourceHandler
    implements MxNodeHandler {
        MdTableMdDataSourceHandler() {
        }

        public void handleNode(String string, Node node) throws TmMigrationException {
            NamedNodeMap namedNodeMap;
            MdDataSourceProperties mdDataSourceProperties = TmXMLMapReader.this.currentMdTable.getMdDataSourceProperties();
            String string2 = TmXMLMapReader.getMdAttribute(string, node, "TYPE", false);
            if (string2 != null) {
                mdDataSourceProperties.setType(string2);
            }
            if ((namedNodeMap = node.getAttributes()) != null) {
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    mdDataSourceProperties.setProperty(node2.getNodeName().toLowerCase(), node2.getNodeValue());
                    ++n;
                }
            }
        }
    }

    class MdAttributeHandler
    implements MxNodeHandler {
        MdAttributeHandler() {
        }

        public void handleNode(String string, Node node) throws TmMigrationException {
            String string2 = TmXMLMapReader.getMdAttribute(string, node, "NAME", true);
            String string3 = TmXMLMapReader.getMdAttribute(string, node, "TYPE", true);
            String string4 = TmXMLMapReader.getMdAttribute(string, node, "SRC", false);
            String string5 = TmXMLMapReader.getMdAttribute(string, node, "REFERENCES", false);
            TmXMLMapReader.this.currentMdTable.newMdAttribute(string2, MdAttribute.toType(string3), string4, string5);
        }
    }
}

