/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration;

import com.sun.symon.tools.migration.datasource.MdDataSource;
import com.sun.symon.tools.migration.datasource.MdRecord;
import com.sun.symon.tools.migration.datasource.MdTableSpace;
import com.sun.symon.tools.migration.function.MfFunction;
import com.sun.symon.tools.migration.function.MfFunctionCallContext;
import com.sun.symon.tools.migration.function.MfValueMap;
import com.sun.symon.tools.migration.util.MuDebug;
import java.util.HashMap;
import java.util.Iterator;

public class TmExtractRaimaString
extends MfFunction {
    public static final String SYMON21_STRING_TABLE = "dat_20";
    public static final String SYMON21_STRING_COLUMN = "val";
    private final HashMap strings = new HashMap();
    private boolean loaded;

    public TmExtractRaimaString() {
        super("TmExtractRaimaString");
    }

    public void addString(String string, String string2) {
        this.strings.put(string, string2);
    }

    public String execute(MfFunctionCallContext mfFunctionCallContext, String[] stringArray) throws Exception {
        Object object;
        if (stringArray == null || stringArray.length != 2) {
            throw new IllegalArgumentException("expected 2 argument: " + this.getUsage());
        }
        if (!this.loaded) {
            object = this;
            synchronized (object) {
                if (!this.loaded) {
                    this.retrieveStrings(mfFunctionCallContext.getSourceMdDataSource().getMdTable().getMdTableSpace());
                    this.loaded = true;
                }
            }
        }
        object = stringArray[0];
        String string = MfFunction.attributeToMdValue(mfFunctionCallContext, stringArray[1]);
        return (String)this.strings.get(TmExtractRaimaString.hashKey((String)object, string));
    }

    private static int findKey(MdRecord mdRecord) {
        int n = 1;
        while (n < mdRecord.values()) {
            if (!mdRecord.getMdValue(n).isNull()) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("No key found in record: " + mdRecord);
    }

    public String getUsage() {
        return String.valueOf(this.getName()) + "(dat20PKIndex, dat20PK):AssembledString";
    }

    private static String hashKey(int n, String string) {
        return String.valueOf(n) + "-" + string;
    }

    private static String hashKey(String string, String string2) {
        return String.valueOf(string) + "-" + string2;
    }

    public static void main(String[] stringArray) throws Exception {
        MfValueMap mfValueMap = new MfValueMap();
        mfValueMap.addMap("t", "true");
        mfValueMap.addMap("T", "true");
        mfValueMap.addMap("f", "false");
        mfValueMap.addMap("F", "false");
        MuDebug.println(mfValueMap.execute(null, "f"));
    }

    private static void put(int n, MdRecord mdRecord, HashMap hashMap) {
        String string = TmExtractRaimaString.hashKey(n, mdRecord.getMdValue(n).toString());
        String string2 = (String)hashMap.get(string);
        String string3 = mdRecord.getMdValue(SYMON21_STRING_COLUMN).toString();
        string2 = string2 == null ? string3 : (string2.length() % 20 != 0 ? String.valueOf(string3) + string2 : String.valueOf(string2) + string3);
        hashMap.put(string, string2);
    }

    public void removeString(String string) {
        this.strings.remove(string);
    }

    private void retrieveStrings(MdTableSpace mdTableSpace) throws Exception {
        MdDataSource mdDataSource = MdDataSource.getInstance(mdTableSpace.getMdTable(SYMON21_STRING_TABLE));
        mdDataSource.open(1);
        MdRecord mdRecord = null;
        while ((mdRecord = mdDataSource.read()) != null) {
            MuDebug.println(mdRecord);
            TmExtractRaimaString.put(TmExtractRaimaString.findKey(mdRecord), mdRecord, this.strings);
        }
        mdDataSource.close();
        Iterator iterator = this.strings.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            MuDebug.println(String.valueOf(string) + "=" + this.strings.get(string));
        }
    }
}

