/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.web.details.alarm;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmPageSyncRequest;
import com.sun.symon.base.web.common.SMWebServlet;
import com.sun.symon.base.web.common.SMWebSession;
import com.sun.symon.base.web.common.SMWebUtil;
import com.sun.symon.base.web.details.alarm.SMWebAlarmInit;
import com.sun.symon.base.web.details.alarm.SMWebAlarmList;
import com.sun.symon.base.web.details.alarm.SMWebAlarmView;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SMWebAlarmTable {
    private final int PAGE_SIZE = 50;
    int alarmCount;
    int page;
    int initCount;
    int lastPage = 1;
    int sortColumn = 2;
    boolean[] descend;
    boolean deletingAlarms;
    boolean newHost;
    String alarmUrl;
    String hostPort;
    Vector clientList;
    SMAlarmPageSyncRequest alarmProbeRequest;
    SMWebSession webSession;
    SMRawDataRequest rawRequest;
    SMAlarmPageSyncRequest request;
    SMWebAlarmList alarmList;
    SMWebAlarmView alarmView;
    SMWebAlarmInit alarmInit;

    public SMWebAlarmTable() {
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        this.descend = blArray;
        this.deletingAlarms = false;
        this.newHost = false;
        this.alarmUrl = null;
        this.hostPort = null;
        this.clientList = new Vector();
        this.alarmProbeRequest = null;
        this.webSession = null;
        this.rawRequest = null;
        this.alarmView = new SMWebAlarmView();
    }

    public void clear() {
        if (this.alarmProbeRequest != null) {
            try {
                this.alarmProbeRequest.closeConnection();
            }
            catch (Exception exception) {
                SMWebUtil.log("Error closing SMAlarmPageSyncRequest connection");
            }
            this.alarmProbeRequest = null;
        }
    }

    public void displayTable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.alarmCount == 0) {
            this.clientList = new Vector();
        }
        ArrayList arrayList = new ArrayList(this.clientList);
        this.alarmList = new SMWebAlarmList(arrayList, this.webSession);
        int n = this.alarmList.getColumnCount();
        int n2 = this.alarmCount == 0 ? 0 : this.alarmList.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr><th width=" + this.alarmList.getColumnWidth(0) + ">");
        stringBuffer.append(this.alarmList.getColumnName(0));
        int n3 = 1;
        while (n3 < n) {
            stringBuffer.append("<th align=left width=" + this.alarmList.getColumnWidth(n3) + "onDblClick=sortTable(i)>" + this.alarmList.getColumnName(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append("<tr><td><input type=checkbox name=check" + n4 + ">");
            stringBuffer.append("<td align=center nowrap><img border=0 src=/getimage?iconId=" + URLEncoder.encode(this.alarmList.getValueAt(n4, 1)) + ">");
            stringBuffer.append("<td nowrap>" + this.alarmList.getValueAt(n4, 2));
            stringBuffer.append("<td align=center nowrap><img border=0 src=/getimage?iconId=" + URLEncoder.encode(this.alarmList.getValueAt(n4, 3)) + ">");
            stringBuffer.append("<td align=center nowrap>" + this.alarmList.getValueAt(n4, 4));
            stringBuffer.append("<td nowrap>" + this.alarmList.getValueAt(n4, 5));
            ++n4;
        }
        PrintWriter printWriter = SMWebServlet.initOutput(httpServletResponse);
        printWriter.println("<html><body bgcolor=white><script src='/scripts/AlarmUtil.js'></script><form name=alarmTable><table><tr><td align=left>" + this.webSession.translate("currentPage") + "<td align=left>" + "<select name=list onChange=absolutePage()>");
        int n5 = 0;
        int n6 = 1;
        while (n5 < this.lastPage) {
            String string = n6 == this.page ? "selected" : "";
            printWriter.println("<option value=\"" + n6 + "\" " + string + ">" + n6);
            ++n5;
            ++n6;
        }
        printWriter.println("</select><td> <td><input type=button value=\" " + this.webSession.translate("first") + " \"" + " onClick=relativePage('first')>" + "<td><input type=button value=\" " + this.webSession.translate("previous") + " \"" + " onClick=relativePage('prev')>" + "<td><input type=button value=\" " + this.webSession.translate("next") + " \"" + " onClick=relativePage('next')>" + "<td><input type=button value=\" " + this.webSession.translate("last") + " \"" + " onClick=relativePage('last')>" + "<tr>" + "<td align=left valign=bottom>" + this.webSession.translate("totalAlarms") + "<td align=left valign=bottom colspan=6>" + "<b>" + this.getTotalAlarms() + "</b>" + "</table>" + "<LINK REL=stylesheet HREF=/styles/TableStyle.css" + " TYPE=text/css>" + "<TABLE CELLSPACING=1 CELLPADDING=2>" + stringBuffer.toString() + "</table>" + "</form>" + "</body>" + "</html>");
    }

    SMWebAlarmList getAlarmList() {
        return this.alarmList;
    }

    SMAlarmPageSyncRequest getAlarmRequest() {
        return this.request;
    }

    boolean getDescend() {
        return this.descend[this.sortColumn];
    }

    int getPage() {
        return this.page;
    }

    public void getPageOfAlarms(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            this.clientList = this.request.pageHostAlarms("1", this.page);
        }
        catch (SMAPIException sMAPIException) {
            SMWebUtil.log(String.valueOf(this.webSession.translate("pageReqException")) + "\n" + sMAPIException.getMessage());
            return;
        }
        this.displayTable(httpServletRequest, httpServletResponse);
    }

    int getSortColumn() {
        return this.sortColumn;
    }

    int getTotalAlarms() {
        return this.alarmCount;
    }

    public void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.webSession == null || this.newHost) {
            this.webSession = (SMWebSession)httpServletRequest.getSession(false).getValue("SMWebSession");
            this.page = 1;
            if (this.newHost) {
                this.alarmView = new SMWebAlarmView();
            }
            this.webSession.setAlarmView(this.alarmView);
            this.alarmInit = this.webSession.getAlarmInit();
            this.rawRequest = this.webSession.getRawRequest();
            if (this.hostPort == null) {
                this.hostPort = httpServletRequest.getParameter("hostPort");
            }
            if (this.alarmUrl == null) {
                this.alarmUrl = httpServletRequest.getParameter("url");
            }
            try {
                this.clear();
                this.alarmProbeRequest = this.request = new SMAlarmPageSyncRequest(this.rawRequest, this.hostPort);
            }
            catch (SMAPIException sMAPIException) {
                SMWebUtil.log("could not create SMAlarmPageAsyncRequest!");
                return;
            }
            this.newHost = false;
        }
        this.selectAlarms(httpServletRequest, httpServletResponse);
    }

    public void selectAlarms(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            this.alarmCount = this.request.selectHostAlarms("1", null, this.alarmUrl, this.alarmView.getSeverity(), this.alarmView.getState(), this.alarmView.getAcknowledge(), null, null, null, SMWebAlarmList.emAttribute[this.sortColumn], this.descend[this.sortColumn]);
        }
        catch (SMAPIException sMAPIException) {
            SMWebUtil.log(String.valueOf(this.webSession.translate("selectReqException")) + "\n" + sMAPIException.getMessage());
            return;
        }
        this.lastPage = this.alarmCount / 50;
        if (this.alarmCount % 50 != 0 || this.alarmCount == 0) {
            ++this.lastPage;
        }
        if (!this.deletingAlarms) {
            this.page = 1;
        }
        this.deletingAlarms = false;
        if (this.alarmCount > 0) {
            this.getPageOfAlarms(httpServletRequest, httpServletResponse);
        } else {
            this.displayTable(httpServletRequest, httpServletResponse);
        }
    }

    void setDeletingAlarms(boolean bl) {
        this.deletingAlarms = bl;
    }

    void setNewHost() {
        this.newHost = true;
        this.alarmUrl = null;
        this.hostPort = null;
    }

    public void setPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getParameter("loc");
        if (string.compareTo("first") == 0) {
            this.page = 1;
        } else if (string.compareTo("prev") == 0) {
            if (this.page - 1 >= 1) {
                --this.page;
            }
        } else if (string.compareTo("next") == 0) {
            if (this.page + 1 <= this.lastPage) {
                ++this.page;
            }
        } else {
            this.page = string.compareTo("last") == 0 ? this.lastPage : Integer.parseInt(string);
        }
        this.getPageOfAlarms(httpServletRequest, httpServletResponse);
    }

    public void setSort(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.sortColumn = Integer.parseInt(httpServletRequest.getParameter("col"));
        this.descend[this.sortColumn] = !this.descend[this.sortColumn];
        this.alarmInit.doWork(httpServletRequest, httpServletResponse, false);
    }
}

