/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.web.details.alarm;

import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.utility.UcListUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SMWebAlarmData {
    static final int NO_ACTION = 0;
    static final int PENDING = 1;
    static final int EXECUTED = 2;
    final String[] actionStatus = new String[]{"no action", "pending", "executed"};
    String alarmId;
    String start;
    String action;
    String message;
    String host;
    int sevIndex;
    int stateIndex;
    int actionStatusIndex = 0;
    String Url;
    String ackUser;
    long startTime;
    long endTime;
    long ackTime;

    public SMWebAlarmData() {
        this.alarmId = "";
        this.start = "-";
        this.action = "-";
        this.message = "-";
        this.stateIndex = -1;
        this.sevIndex = -1;
        this.ackTime = 0L;
        this.endTime = 0L;
        this.startTime = 0L;
    }

    public SMWebAlarmData(SMAlarmObjectData sMAlarmObjectData) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd  HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        this.start = simpleDateFormat.format(new Date(sMAlarmObjectData.getOpenTimestamp() * 1000L));
        this.alarmId = sMAlarmObjectData.getAlarmId();
        this.action = sMAlarmObjectData.getActionName();
        this.actionStatusIndex = sMAlarmObjectData.getActionStatus();
        String string = sMAlarmObjectData.getAlarmShortText();
        this.message = UcListUtil.AsciiToUnicode((String)string);
        this.host = sMAlarmObjectData.getHost();
        String string2 = sMAlarmObjectData.getSeverity();
        this.sevIndex = string2.compareTo("DWN") == 0 ? (sMAlarmObjectData.isAcked() ? 1 : 0) : (string2.compareTo("ERR") == 0 ? (sMAlarmObjectData.isAcked() ? 3 : 2) : (string2.compareTo("WRN") == 0 ? (sMAlarmObjectData.isAcked() ? 5 : 4) : (string2.compareTo("INF") == 0 ? (sMAlarmObjectData.isAcked() ? 7 : 6) : (sMAlarmObjectData.isAcked() ? 9 : 8))));
        this.stateIndex = sMAlarmObjectData.isClosed() ? 1 : 0;
        this.Url = sMAlarmObjectData.getMoURL();
        this.startTime = sMAlarmObjectData.getOpenTimestamp() * 1000L;
        this.endTime = sMAlarmObjectData.getCloseTimestamp() * 1000L;
        this.ackTime = sMAlarmObjectData.getAckTimestamp() * 1000L;
        this.ackUser = sMAlarmObjectData.getAckOperator();
    }

    long getAckTime() {
        return this.ackTime;
    }

    String getAckUser() {
        return this.ackUser;
    }

    String getAction() {
        return this.action;
    }

    String getActionStatus() {
        return this.actionStatus[this.actionStatusIndex];
    }

    int getActionStatusIndex() {
        return this.actionStatusIndex;
    }

    long getEndTime() {
        return this.endTime;
    }

    String getHost() {
        return this.host;
    }

    String getId() {
        return this.alarmId;
    }

    int getSevIndex() {
        return this.sevIndex;
    }

    int getStateIndex() {
        return this.stateIndex;
    }

    String getUrl() {
        return this.Url;
    }

    void setAckTime(long l) {
        this.ackTime = l;
    }

    void setAckUser(String string) {
        this.ackUser = string;
    }

    void setAction(String string) {
        this.action = string;
    }

    void setActionStatusIndex(int n) {
        this.actionStatusIndex = n;
    }

    void setSevIndex(int n) {
        this.sevIndex = n;
    }
}

