/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.emitters.snmp.SeSnmpException;
import com.sun.symon.base.server.emitters.snmp.SeSnmpMessenger;
import com.sun.symon.base.server.emitters.snmp.SeSnmpPortal;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.v1.SsGetResponse;
import com.sun.symon.base.server.snmp.v2u.SsReport;
import com.sun.symon.base.server.snmp.v2u.SsResponse;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerOneShot;
import com.sun.symon.base.utility.UcTickerOneShotResponse;
import java.io.IOException;
import java.net.InetAddress;

class Request
implements ScRequestSinkInterface,
SeSnmpPortal.ResponseHandler {
    private static final long REPORT_RETRY_TIME = 2L;
    private SsMessage msg;
    private SeSnmpMessenger.ResponseCallback responseHandler;
    private int sendId;
    private SeSnmpPortal portal;
    private UcTickerOneShot reportPauseOneShot;
    private UcTickerOneShot requestTimeoutOneShot;
    private boolean reportPauseOneShotActive;
    private boolean requestTimeoutOneShotActive;
    private int reportCnt;
    private InetAddress ip;
    private int port;
    private boolean timedOut;

    Request(SeSnmpPortal seSnmpPortal, long l, InetAddress inetAddress, int n, SsMessage ssMessage, SeSnmpMessenger.ResponseCallback responseCallback) {
        this.portal = seSnmpPortal;
        this.ip = inetAddress;
        this.port = n;
        this.msg = ssMessage;
        this.responseHandler = responseCallback;
        this.sendId = seSnmpPortal.register(this);
        ssMessage.setSendId(this.sendId);
        try {
            this.reportPauseOneShot = new UcTickerOneShot(2L, new UcTickerOneShotResponse(){

                public void processTick() {
                    Request.this.reportResend();
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {}
        try {
            this.requestTimeoutOneShot = new UcTickerOneShot(l, new UcTickerOneShotResponse(){

                public void processTick() {
                    Request.this.requestTimeout();
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {}
    }

    public synchronized void delete() {
        this.portal.unregister(this.sendId);
        this.reset();
    }

    public synchronized void emit() {
        if (this.requestTimeoutOneShotActive) {
            return;
        }
        this.reset();
        this.requestTimeoutOneShot.start();
        this.requestTimeoutOneShotActive = true;
        this.timedOut = false;
        this.emitPacket();
    }

    private void emitPacket() {
        try {
            this.portal.sendMsg(this.msg, this.ip, this.port);
        }
        catch (IOException iOException) {
            UcDDL.logErrorMessage((String)"error sending snmp packet - packet not sent", (Throwable)iOException);
        }
        catch (SsEncodeException ssEncodeException) {
            UcDDL.logErrorMessage((String)"error encoding snmp packet - packet not sent", (Throwable)ssEncodeException);
        }
    }

    private void emitPacketAfterPause() {
        this.reportPauseOneShot.start();
        this.reportPauseOneShotActive = true;
    }

    public String[][] getCacheKeys() {
        return null;
    }

    private String handleReport(SsMessage ssMessage) {
        String string = null;
        ++this.reportCnt;
        if (this.reportCnt > 10) {
            string = "too many consecutive reports";
        } else if (ssMessage.getVariable("1.3.6.1.6.3.6.1.2.5.0") != null) {
            UcDDL.logDebugMessage((String)"received report: unknown context");
            this.emitPacket();
        } else if (ssMessage.getVariable("1.3.6.1.6.3.6.1.2.2.0") != null) {
            UcDDL.logDebugMessage((String)"received report: not in time window");
            this.emitPacket();
        } else if (ssMessage.getVariable("1.3.6.1.6.3.6.1.2.3.0") != null) {
            UcDDL.logDebugMessage((String)"received report: unknown user id");
            this.emitPacketAfterPause();
        } else if (ssMessage.getVariable("1.3.6.1.6.3.6.1.2.4.0") != null) {
            UcDDL.logDebugMessage((String)"received report: unknown digest");
            this.emitPacketAfterPause();
        } else if (ssMessage.getVariable("1.3.6.1.6.3.6.1.2.1.0") != null) {
            UcDDL.logDebugMessage((String)"received report: unsupported quality of service");
        } else {
            UcDDL.logDebugMessage((String)"received report");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleResponse(SsMessage ssMessage) {
        String string = null;
        int n = 1;
        int n2 = 0;
        Request request = this;
        synchronized (request) {
            Object object;
            Object object2;
            if (this.timedOut) {
                UcDDL.logInfoMessage((String)"SNMP response is too late");
                return;
            }
            switch (ssMessage.getVersion()) {
                case 1: {
                    object2 = (SsGetResponse)ssMessage;
                    n2 = ((SsGetResponse)object2).getErrorStatus();
                    n = ((SsGetResponse)object2).getErrorIndex();
                    break;
                }
                case 2: {
                    object = (com.sun.symon.base.server.snmp.v2.SsResponse)ssMessage;
                    n2 = ((com.sun.symon.base.server.snmp.v2.SsResponse)object).getErrorStatus();
                    n = ((com.sun.symon.base.server.snmp.v2.SsResponse)object).getErrorIndex();
                    break;
                }
                case 3: {
                    if (ssMessage.getType() == 7) {
                        string = this.handleReport(ssMessage);
                        if (string == null) {
                            return;
                        } else {
                            SsReport ssReport = (SsReport)ssMessage;
                            n = ssReport.getErrorIndex();
                            break;
                        }
                    }
                    SsResponse ssResponse = (SsResponse)ssMessage;
                    n2 = ssResponse.getErrorStatus();
                    n = ssResponse.getErrorIndex();
                    break;
                }
                default: {
                    UcDDL.logErrorMessage((String)"this should not happen");
                    return;
                }
            }
            if (string == null && n2 != 0) {
                object2 = ssMessage.getSecurityName();
                UcDDL.logDebugMessage((String)("SNMP response security name = '" + (String)object2 + "'"));
                object = ssMessage.getText();
                string = "SNMP request returned error status " + n2 + " (" + (String)object + ")";
            }
            this.reset();
        }
        if (string != null) {
            int n3 = 0;
            if (ssMessage.getNames() != null) {
                n3 = ssMessage.getNames().length;
            }
            if (n < 1 || n > n3) {
                UcDDL.logWarningMessage((String)("bad error index in response packet: " + n));
                n = n3 == 0 ? 1 : n3;
            }
        }
        this.respond(ssMessage, string, n - 1, n2);
    }

    private synchronized void reportResend() {
        if (this.reportPauseOneShotActive) {
            this.emitPacket();
        }
    }

    private void requestTimeout() {
        Request request = this;
        synchronized (request) {
            if (!this.requestTimeoutOneShotActive) {
                Object var2_2 = null;
                return;
            }
            this.reset();
            this.timedOut = true;
        }
        this.respond(null, "SNMP request timed out", 0, 1001);
    }

    private void reset() {
        this.reportCnt = 0;
        this.reportPauseOneShot.stop();
        this.reportPauseOneShotActive = false;
        this.requestTimeoutOneShot.stop();
        this.requestTimeoutOneShotActive = false;
    }

    private void respond(SsMessage ssMessage, String string, int n, int n2) {
        if (string == null) {
            this.responseHandler.handleResponse(ssMessage);
        } else {
            UcDDL.logWarningMessage((String)string);
            this.responseHandler.handleException(new SeSnmpException(string, n, n2));
        }
    }
}

