/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;

public class LoadJavaSourceImpl {
    byte[] md5;
    boolean verbose = false;
    boolean createSynonym = false;
    Connection conn;
    String username_password = "internal/oracle";
    String database = "@localhost:1521:orcl";
    String resolver = "((\"*\" SYS) (\"*\" PUBLIC) (\"java/awt/*\" -) (\"java/applet/*\" -))";
    String schema = "";
    String rights = "";
    String andcompile = "";
    private static String loadLobsPackage = "create or replace package loadlobs is   column blob;   end_of_lob binary_integer;   function beginload (classfile varchar2) return varchar2;   procedure appendpiece (piece raw, len binary_integer);   function endload (classfile varchar2) return varchar2;   function beginread (classfile varchar2, len out binary_integer)          return varchar2;   function getpiece (piece out raw, len in out binary_integer)          return varchar2;   function endread (classfile varchar2) return varchar2; end loadlobs;";
    private static String loadLobsBody = "create or replace package body loadlobs is   function beginload (classfile varchar2) return varchar2 is   begin      column := null;      end_of_lob := 1;          delete from CREATE$JAVA$LOB$TABLE where name = classfile;     insert into CREATE$JAVA$LOB$TABLE (name, lob, loadtime)         values (classfile, empty_blob(), sysdate);     select lob into column from CREATE$JAVA$LOB$TABLE          where name = classfile;     return '';   exception when others then return sqlerrm;   end;   procedure appendpiece (piece raw, len binary_integer) is   begin      dbms_lob.write(column, len, end_of_lob, piece);      end_of_lob := end_of_lob + len;   end;   function endload (classfile varchar2) return varchar2 is   begin     if end_of_lob - 1 != dbms_lob.getlength(column)    then return 'length mismatch: sum of piece lengths = ' ||          end_of_lob - 1 ||          ', while dbms_lob.getlength = ' || dbms_lob.getlength(column);    end if;    commit;    return '';    exception when others then return sqlerrm;   end;   function beginread (classfile varchar2, len out binary_integer)          return varchar2 is   begin     end_of_lob := 1;          select lob into column from CREATE$JAVA$LOB$TABLE          where name = classfile;     len := dbms_lob.getlength(column);     return '';   exception when others then return sqlerrm;   end;   function getpiece (piece out raw, len in out binary_integer)          return varchar2 is   begin     dbms_lob.read(column, len, end_of_lob, piece);      end_of_lob := end_of_lob + len;     return '';   exception when others then return sqlerrm;   end;   function endread (classfile varchar2) return varchar2 is   begin    if end_of_lob - 1 != dbms_lob.getlength(column)    then return 'length mismatch: sum of piece lengths = ' ||          end_of_lob - 1 ||          ', while dbms_lob.getlength = ' || dbms_lob.getlength(column);    end if;    return '';   exception when others then return sqlerrm;   end; end loadlobs;";

    String classNameFrom(String name) {
        String className = name.substring(0, name.lastIndexOf(".java")).replace('.', '/').replace('\\', '/');
        int last = className.lastIndexOf("/");
        String quote = "\"";
        if (last == -1) {
            return String.valueOf(quote) + className + quote;
        }
        return String.valueOf(quote) + className.substring(last + 1, className.length()) + quote;
    }

    void createClass(String className) throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            try {
                stmt.execute("create or replace" + this.andcompile + " java source named " + className + this.schema + this.rights + " resolver " + this.resolver + " using '" + className + "'");
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    void createClassSynonym(String className) throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            try {
                block6: {
                    try {
                        stmt.execute("drop public synonym \"" + className + "\"");
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1432) break block6;
                        System.out.println(e.getMessage());
                    }
                }
                stmt.execute("create public synonym \"" + className + "\" for \"" + className + "\"");
                stmt.execute("grant execute on \"" + className + "\" to public");
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    void createResource(String fileName) throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            try {
                this.msg("creating resource " + fileName);
                stmt.execute("create or replace java resource named \"" + fileName + "\"  using '" + fileName + "'");
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    void createSynonymsFrom(ZipFile jarFile) throws SQLException {
        Enumeration<? extends ZipEntry> e = jarFile.entries();
        int count = 0;
        Statement stmt = this.conn.createStatement();
        try {
            while (e.hasMoreElements()) {
                ZipEntry currentEntry = e.nextElement();
                if (!currentEntry.isDirectory()) {
                    if (this.isClassEntry(currentEntry)) {
                        this.createClassSynonym(this.classNameFrom(currentEntry.getName()));
                    } else {
                        this.grantResourceExecute(this.resourceNameFrom(currentEntry.getName()));
                    }
                }
                if (++count % 20 != 0) continue;
                this.conn.commit();
                if (stmt != null) {
                    stmt.close();
                }
                this.conn.close();
                this.conn = DriverManager.getConnection("jdbc:oracle:thin:" + this.username_password + this.database);
                stmt = this.conn.createStatement();
            }
            this.conn.commit();
        }
        finally {
            Object var8_6 = null;
            stmt.close();
        }
    }

    void grantResourceExecute(String fileName) throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            stmt.execute("grant execute on \"" + fileName + "\" to public");
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        stmt.close();
    }

    boolean isClassEntry(ZipEntry entry) {
        return entry.getName().endsWith(".java");
    }

    void loadClass(String fileName) throws IOException, SQLException {
        FileInputStream file;
        block4: {
            file = new FileInputStream(fileName);
            try {
                String className = this.classNameFrom(fileName);
                System.out.println("loadClass: " + className);
                this.loadFile(className, file);
                this.createClass(className);
                if (!this.createSynonym) break block4;
                this.createClassSynonym(className);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (file != null) {
                    file.close();
                }
                throw throwable;
            }
        }
        Object var5_4 = null;
        if (file != null) {
            file.close();
        }
    }

    void loadFile(String fileName, InputStream file) throws SQLException, IOException {
        long byte_count;
        byte[] buf = new byte[4096];
        this.msg("loading file " + fileName);
        CallableStatement cs = this.conn.prepareCall("begin ? := loadlobs.beginload( ? ); end;");
        cs.registerOutParameter(1, 12);
        cs.setString(2, fileName);
        cs.execute();
        String err = cs.getString(1);
        if (!cs.wasNull()) {
            System.out.println(err);
        }
        cs.close();
        ((OracleConnection)this.conn).setDefaultExecuteBatch(100);
        cs = this.conn.prepareCall("begin loadlobs.appendpiece(?, ?); end;");
        int loop_count = 0;
        while ((byte_count = (long)file.read(buf, 0, buf.length)) >= 1L) {
            cs.setBytes(1, buf);
            cs.setLong(2, byte_count);
            cs.execute();
            ++loop_count;
        }
        int rows_updated = ((OraclePreparedStatement)cs).sendBatch();
        cs.close();
        cs = this.conn.prepareCall("begin ? := loadlobs.endload( ? ); end;");
        cs.registerOutParameter(1, 12);
        cs.setString(2, fileName);
        cs.execute();
        err = cs.getString(1);
        if (!cs.wasNull()) {
            System.out.println(err);
        }
        cs.close();
    }

    void loadFilesFrom(ZipFile jarFile) throws SQLException, IOException {
        Enumeration<? extends ZipEntry> e = jarFile.entries();
        int count = 0;
        while (e.hasMoreElements()) {
            ZipEntry currentEntry = e.nextElement();
            try {
                if (!currentEntry.isDirectory()) {
                    if (this.isClassEntry(currentEntry)) {
                        String className = this.classNameFrom(currentEntry.getName());
                        this.loadFile(className, jarFile.getInputStream(currentEntry));
                        this.createClass(className);
                    } else {
                        String resourceName = this.resourceNameFrom(currentEntry.getName());
                        this.loadFile(resourceName, jarFile.getInputStream(currentEntry));
                        this.createResource(resourceName);
                    }
                }
            }
            catch (SQLException p) {
                p.getErrorCode();
                System.err.println("Socket Dropped during processing of " + currentEntry.getName());
                System.err.println("Trying to establish a new connection");
                this.conn.close();
                this.conn = DriverManager.getConnection("jdbc:oracle:thin:" + this.username_password + this.database);
                this.conn.setAutoCommit(false);
            }
            if (++count % 20 != 0) continue;
            this.conn.commit();
            this.conn.close();
            this.conn = DriverManager.getConnection("jdbc:oracle:thin:" + this.username_password + this.database);
            this.conn.setAutoCommit(false);
        }
        this.conn.commit();
    }

    void loadJar(String fileName) throws IOException, SQLException {
        ZipFile jarFile;
        block4: {
            jarFile = new ZipFile(fileName);
            try {
                this.loadFilesFrom(jarFile);
                if (!this.createSynonym) break block4;
                this.createSynonymsFrom(jarFile);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (jarFile != null) {
                    jarFile.close();
                }
                throw throwable;
            }
        }
        Object var5_3 = null;
        if (jarFile != null) {
            jarFile.close();
        }
    }

    void loadLobsSQL() throws SQLException {
        Statement stmt = this.conn.createStatement();
        try {
            stmt.execute("drop table CREATE$JAVA$LOB$TABLE");
        }
        catch (SQLException sQLException) {}
        stmt.execute("create table CREATE$JAVA$LOB$TABLE (name varchar2(200) unique, lob blob, loadtime date)");
        stmt.execute(loadLobsPackage);
        stmt.execute(loadLobsBody);
        stmt.close();
    }

    void msg(String msg) {
        if (this.verbose) {
            System.err.println(msg);
        }
    }

    String resourceNameFrom(String name) {
        return name.replace('\\', '/');
    }

    public void run(String[] args) throws SQLException, ClassNotFoundException, IOException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        Vector<String> filenames = new Vector<String>(20, 10);
        String flags = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("@")) {
                this.database = args[i];
            } else if (args[i].startsWith("-P")) {
                this.username_password = args[i].substring(2);
            } else if (args[i].startsWith("-RESOLVER") | args[i].startsWith("-resolver")) {
                this.resolver = args[i].substring(9);
            } else {
                if (args[i].startsWith("-s")) {
                    this.schema = " SCHEMA " + args[i].substring(2) + " ";
                } else if (args[i].startsWith("-i")) {
                    this.rights = " INVOKER ";
                } else if (args[i].startsWith("-d")) {
                    this.rights = " DEFINER ";
                } else if (args[i].startsWith("-c")) {
                    this.andcompile = " and compile ";
                }
                if (args[i].startsWith("-")) {
                    flags = String.valueOf(flags) + args[i];
                } else {
                    filenames.addElement(args[i]);
                }
            }
            ++i;
        }
        if (flags.indexOf("v") > -1) {
            this.verbose = true;
        }
        if (flags.indexOf("s") > -1) {
            this.createSynonym = true;
        }
        this.msg("Parsed command-line arguments:");
        this.msg("database = '" + this.database + "'");
        this.msg("flags = '" + flags + "'");
        this.msg("username/password = '" + this.username_password + "'");
        this.msg("name resolver = '" + this.resolver + "'");
        this.msg("files:");
        i = 0;
        while (i < filenames.size()) {
            this.msg("    " + (String)filenames.elementAt(i));
            ++i;
        }
        this.conn = DriverManager.getConnection("jdbc:oracle:thin:" + this.username_password + this.database);
        this.conn.setAutoCommit(false);
        this.loadLobsSQL();
        i = 0;
        while (i < filenames.size()) {
            if (((String)filenames.elementAt(i)).endsWith(".java")) {
                this.loadClass((String)filenames.elementAt(i));
            } else {
                this.loadJar((String)filenames.elementAt(i));
            }
            ++i;
        }
        Statement stmt = this.conn.createStatement();
        try {
            stmt.execute("drop table CREATE$JAVA$LOB$TABLE");
        }
        catch (SQLException sQLException) {}
        stmt.close();
        this.conn.commit();
        this.conn.close();
    }
}

