/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.DatabaseOptions;
import oracle.aurora.server.tools.loadjava.Error;
import oracle.aurora.server.tools.loadjava.LoadJava;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;

public class LoadJavaMain {
    DatabaseOptions database = new DatabaseOptions();
    boolean verbose = false;
    boolean debug = false;
    boolean resolve = false;
    boolean andresolve = false;
    boolean jdkresolver = false;
    boolean definer = false;
    boolean force = false;
    boolean synonyms = false;
    String resolver = null;
    String[] classFileNames = null;
    String[] jarFileNames = null;
    String grantNames = null;
    String encoding = null;
    String schema = null;
    boolean useStdout = false;
    String useFileOutput = null;
    boolean order = false;
    boolean noverify = false;
    String localPathPrefix = null;
    LoadJava loadJava = new LoadJava();
    boolean successFlag = true;
    public static final String load_java_help = "LoadJava is a utility providing a means to quickly load individual\nclass files or entire JAR files into the Aurora Java server.  The\nutility will not load classes that are not different from the classes\nalready in the database, although if the \"-r\" switch is provided, the\nutility will resolve these classes.\n\nQuick reference.  To use this utility:\n\n\nLoad .class files in JAR files by listing the JAR file names as \ncommand-line args to java utility LoadJava like this:\n\n> java LoadJava -Pscott/tiger @hhildebr-pc:1521:orcl one.jar two.jar three.jar\n\nLoad individual .class files by listing the file names as command-line\nargs to the java utility LoadJava like this:\n\n\t\t> java LoadJava -Pscott/tiger @myComputer:1521:orcl one.class two.class\n\nGetting Started:\n\tYou need Oracle thin JDBC to run this utility.\n\t\n_______________________________________________________________\n\n\tCommand Line Arguments\n\n  The LoadJava utility takes a list of names of .jar or .class files on the\n  command line:\n \n> java LoadJava [-frvs] [database] [-Puser/passwd] [\"-RESOLVER name resolver\"] file1.jar [file2.jar file3.class ...]\n\nYou can mix both .class and .jar files in the same command line.\n\nThe \"-f\" switch is for \"force loading\" which forces the utility to load\n\tthe classes, regardless of whether the utility thinks the class has\n\tchanged or not.\n\t\nThe \"-v\" switch is for \"verbose\" and prints some tracing messages.\n\nThe \"-r\" switch is for \"resolve\" and causes the system to resolve the\n\tdatabase classes.  The default of the utility is not to resolve\n\tthe classes at load time, rather \"lazily\" resolving the classes\n\tat run time.  If any errors are encountered during the resolution\n\tof the class, the utility prints these to standard out.\n\t\nThe \"-a\" switch is for \"andresolve\" and causes the system to create and\nresolve as part of a single DDL statement rather than using a separate resolve\nstatement as it does for the \"-r\" switch.\nThe \"-s\" switch is for \"synonym\" and causes the system to create public\n\tsynonyms for the classes\n\nThe \"database\" argument is given in the syntax used by the thin JDBC driver.\n\tThe database argument must start with an '@' followed by the host name\n\tof the computer, followed by a colon (':') followed by the port number,\n\tfollowed by the database.  If you do not supply the database argument,\n\tthe default database used is @localhost:1521:orcl.\n\n\nThe \"-P\" switch is for \"Password\" and the username/password string must\n\tfollow the switch with no intervening spaces. If no password is supplied,\n\tthe default password is \"internal/oracle\".\n\t\nThe \"-RESOLVER\" switch is for \"Name Resolver\" and because the name resolver has\n\tspaces in the specification, it must be supplied as a double quoted string.\n\tThe name resolver specified is used with the creation of the classes\n\tsuch that the specified resolver is bound to the created classes.  If\n\tthe class is not created, the resolver of the existing class is not\n\tchanged.   The format of the resolver string is:\n\t\t\"((<match string>, <schema name>) ...)\"\n\tPlease see the release notes for Aurora for more details on the syntax and usage\n\tof name resolvers.  If no name resolver spec is given, the default name resolver is:\n\t\t\"((* SYS) (* PUBLIC) (\"java/awt/*\" -) (\"java/applet/*\" -))\"\n\texample:\n\t\tloadJava my.jar \"-RESOLVER(* PUBLIC))\"\n\t\t\n___________________________________________________________________\n\n  The LoadJava utility makes use of the MD5 hash of a class file\n  to determine whether to load a class into the database or not.\n  An auxillary table, JAVA$CLASS$MD5$TABLE, is maintained in the\n  schema which keeps track of the MD5 hash of the classes loaded\n  with this utility.  If this utility is not used to load classes,\n  this table will not be updated properly, and the utility will\n  be confused as to whether the class has been loaded or not.\n  \n  The utility reads all the .class files in each of the .jar files,\n  and stores each in a BLOB column in table CREATE$JAVA$LOB$TABLE,\n  in a row keyed by the file name as provided in the .jar file \n  , e.g., \"SomeJavaFile.class\".  The table CREATE$JAVA$LOB$TABLE, \n  and the PLSQL package LOADLOBS that manages it are automatically\n  created by the utility.\n\n  table CREATE$JAVA$LOB$TABLE \n\t(filename varchar2(255) unique, classbits blob, loadtime date);\n\n  The client-side part of this utility this java program, which uses\n  jdbc to access the default database.  It passes byte arrays to the\n  database as \"raw\" data.  All lob manipulation is done by a plsql\n  program on the serverside, so this utility does not depend on lob \n  support in jdbc.\n\n  Before a row is inserted into table CREATE$JAVA$LOB$TABLE with a filename \n  (e.g., \"file3.class\") as its key, other rows with that key are\n  deleted.  The entire .class file is loaded into the \"classbits\"\n  BLOB column of the row with the filename as its key.  Column\n  \"loadtime\" is set to SYSDATE when the file is loaded, just\n  as side info.";

    public void dumpArgs() {
        this.database.dumpArgs();
        System.out.println("verbose = " + this.verbose);
        System.out.println("debug = " + this.debug);
        System.out.println("resolve = " + this.resolve);
        System.out.println("andresolve = " + this.andresolve);
        System.out.println("definer = " + this.definer);
        System.out.println("force = " + this.force);
        System.out.println("synonyms = " + this.synonyms);
        System.out.println("resolver = " + this.resolver);
        System.out.print("classFileNames = ");
        int i = 0;
        while (i < this.classFileNames.length) {
            System.out.print(String.valueOf(this.classFileNames[i]) + " ");
            ++i;
        }
        System.out.println();
        System.out.print("jarFileNames = ");
        i = 0;
        while (i < this.jarFileNames.length) {
            System.out.print(String.valueOf(this.jarFileNames[i]) + " ");
            ++i;
        }
        System.out.println();
    }

    private void fail() {
        this.successFlag = false;
    }

    public static void main(String[] args) {
        LoadJavaMain m = new LoadJavaMain();
        m.run(args);
        if (!m.success()) {
            System.exit(1);
        }
    }

    void parseArgs(String[] argvIn) throws ToolsException {
        String[] argv = this.database.parseArgs(argvIn);
        Vector<String> classes = new Vector<String>();
        Vector<String> jars = new Vector<String>();
        Vector grants = new Vector();
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-help") || argv[i].equals("-h")) {
                Error.LOAD_JAVA_HELP();
            } else if (argv[i].equals("-verbose") || argv[i].equals("-v")) {
                this.verbose = true;
            } else if (argv[i].equals("-resolve") || argv[i].equals("-r")) {
                this.resolve = true;
            } else if (argv[i].equals("-definer") || argv[i].equals("-d")) {
                this.definer = true;
            } else if (argv[i].equals("-debug")) {
                this.debug = true;
            } else if (argv[i].equals("-andresolve") || argv[i].equals("-a")) {
                this.andresolve = true;
            } else if (argv[i].equals("-force") || argv[i].equals("-f")) {
                this.force = true;
            } else if (argv[i].equals("-synonym") || argv[i].equals("-s")) {
                this.synonyms = true;
            } else if (argv[i].equals("-order")) {
                this.order = true;
            } else if (argv[i].equals("-noverify")) {
                this.noverify = true;
            } else if (argv[i].equals("-dresolver")) {
                this.jdkresolver = true;
            } else if (argv[i].equals("-oracleresolver")) {
                this.jdkresolver = false;
            } else if (argv[i].equals("-localpathprefix")) {
                if (++i == argv.length) {
                    this.usage();
                }
                this.localPathPrefix = argv[i];
            } else if (argv[i].equals("-stdout")) {
                this.useStdout = true;
            } else if (argv[i].equals("-fileout")) {
                if (++i == argv.length) {
                    this.usage();
                }
                this.useFileOutput = argv[i];
            } else if (argv[i].equals("-resolver") || argv[i].equals("-R")) {
                if (++i == argv.length) {
                    this.usage();
                }
                this.resolver = argv[i];
            } else if (argv[i].equals("-grant") || argv[i].equals("-g")) {
                if (++i == argv.length) {
                    this.usage();
                }
                this.grantNames = argv[i];
            } else if (argv[i].equals("-encoding") || argv[i].equals("-e")) {
                if (++i == argv.length) {
                    this.usage();
                }
                this.encoding = argv[i];
            } else if (argv[i].equals("-schema")) {
                if (++i == argv.length) {
                    this.usage();
                }
                this.schema = argv[i];
            } else if (argv[i].startsWith("-R")) {
                this.resolver = argv[i].substring(2);
            } else if (argv[i].startsWith("-")) {
                this.usage();
            } else if (argv[i].endsWith(".jar") || argv[i].endsWith(".zip")) {
                jars.addElement(argv[i]);
            } else {
                classes.addElement(argv[i]);
            }
            ++i;
        }
        if (classes.size() == 0 && jars.size() == 0) {
            this.usage();
        }
        this.classFileNames = new String[classes.size()];
        classes.copyInto(this.classFileNames);
        this.jarFileNames = new String[jars.size()];
        jars.copyInto(this.jarFileNames);
        this.loadJava.setVerbose(this.verbose);
        this.loadJava.setDebug(this.debug);
        this.loadJava.setResolve(this.resolve);
        this.loadJava.setDefiner(this.definer);
        this.loadJava.setAndresolve(this.andresolve);
        this.loadJava.setJdkresolver(this.jdkresolver);
        this.loadJava.setForceLoading(this.force);
        this.loadJava.setCreateSynonym(this.synonyms);
        this.loadJava.setResolver(this.resolver);
        this.loadJava.setLocalPathPrefix(this.localPathPrefix);
        this.loadJava.setFilenames(this.classFileNames);
        this.loadJava.setJarFilenames(this.jarFileNames);
        this.loadJava.setGrantNames(this.grantNames);
        this.loadJava.setEncoding(this.encoding);
        this.loadJava.setSchema(this.schema);
        this.loadJava.setOrder(this.order);
        this.loadJava.setNoverify(this.noverify);
    }

    public void run(String[] argv) {
        Object conn = null;
        try {
            try {
                this.parseArgs(argv);
                this.loadJava.setDatabase(this.database);
                if (this.useStdout) {
                    this.loadJava.setOutput(System.out);
                } else if (this.useFileOutput != null) {
                    try {
                        this.loadJava.setOutput(new PrintStream(new FileOutputStream(this.useFileOutput)));
                    }
                    catch (IOException e) {
                        throw new ToolsException("error opening " + this.useFileOutput, e);
                    }
                } else {
                    this.loadJava.setOutput(System.err);
                }
                this.loadJava.process();
                this.loadJava.getConnection().commit();
            }
            catch (SQLException e) {
                Error.SQL_ERROR(e.getMessage());
            }
            catch (UnsatisfiedLinkError e) {
                Error.OCI8_NOT_INSTALLED(e.getMessage());
            }
        }
        catch (ToolsException e) {
            System.err.println("loadjava: " + e.getMessage());
            if (this.debug && e.getChain() != null) {
                e.getChain().printStackTrace(System.err);
            }
            this.fail();
        }
        catch (ToolsError e) {
            System.err.println("loadjava: " + e.getMessage());
            this.fail();
        }
    }

    public static void serverMain(String args) {
        LoadJavaMain.serverMain(args, null);
    }

    public static void serverMain(String args, String resolver) {
        Vector<String> argv = new Vector<String>();
        String localPathPrefix = System.getProperty("oracle.aurora.rdbms.oracle_home");
        argv.add("-kprb");
        if (localPathPrefix != null) {
            argv.add("-localpathprefix");
            argv.add(localPathPrefix);
        }
        if (resolver != null) {
            argv.add("-resolver");
            argv.add(resolver);
        }
        StringTokenizer tokens = new StringTokenizer(args);
        while (tokens.hasMoreTokens()) {
            argv.add(tokens.nextToken());
        }
        Object[] arga = new String[argv.size()];
        argv.copyInto(arga);
        new LoadJavaMain().run((String[])arga);
    }

    public boolean success() {
        return this.successFlag;
    }

    void usage() throws ToolsException {
        Error.LOAD_JAVA_USAGE();
    }
}

