/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.Error;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.jdbc.driver.OracleDriver;

public class DatabaseOptions {
    String driver = "oci8";
    String user = null;
    String password = null;
    String database = null;

    public Connection connect() throws SQLException, ToolsException {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = null;
        try {
            if (this.driver.equals("oci8")) {
                try {
                    String oci8DB = this.database == null ? "@" : "@" + this.database;
                    conn = DriverManager.getConnection("jdbc:oracle:oci8:" + oci8DB, this.user, this.password);
                }
                catch (UnsatisfiedLinkError e) {
                    Error.OCI8_NOT_INSTALLED(e.getMessage());
                }
            } else if (this.driver.equals("kprb")) {
                String connString = "jdbc:oracle:kprb:@";
                conn = DriverManager.getConnection(connString);
            } else {
                String thinDB = this.database == null ? "" : "@" + this.database;
                conn = DriverManager.getConnection("jdbc:oracle:thin:" + thinDB, this.user, this.password);
            }
        }
        catch (SQLException e) {
            Error.SQL_CONNECT_ERROR(e.getMessage(), this.driver, this.database);
        }
        catch (Exception e) {
            Error.SQL_CONNECT_ERROR(e.toString(), this.driver, this.database);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public void dumpArgs() {
        System.out.println("driver = " + this.driver);
        System.out.println("user = " + this.user);
        System.out.println("password = " + this.password);
        System.out.println("database = " + this.database);
    }

    public String[] parseArgs(String[] argv) throws ToolsException {
        Vector<String> argsLeft = new Vector<String>();
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-thin") || argv[i].equals("-t")) {
                this.driver = "thin";
            } else if (argv[i].equals("-oci8") || argv[i].equals("-o")) {
                this.driver = "oci8";
            } else if (argv[i].equals("-kprb")) {
                this.driver = "kprb";
            } else if (argv[i].equals("-user") || argv[i].equals("-u")) {
                if (++i == argv.length) {
                    Error.MISSING_USER_NAME();
                }
                this.tryFullDBString(argv[i]);
            } else if (argv[i].equals("-password") || argv[i].equals("-P")) {
                if (++i == argv.length) {
                    Error.MISSING_PASSWORD();
                }
                this.password = argv[i];
            } else if (argv[i].equals("-database") || argv[i].equals("-d")) {
                if (++i == argv.length) {
                    Error.MISSING_DATABASE();
                }
                this.database = argv[i];
            } else if (argv[i].startsWith("@")) {
                this.tryFullDBString(argv[i]);
            } else if (argv[i].startsWith("-P")) {
                this.tryFullDBString(argv[i].substring(2));
            } else {
                argsLeft.addElement(argv[i]);
            }
            ++i;
        }
        if (this.user != null && this.password == null) {
            this.password = "";
        } else if (this.user == null) {
            this.user = "internal";
            this.password = "oracle";
        }
        if (this.driver.equals("thin") && this.database != null) {
            int second_colon;
            int first_colon = this.database.indexOf(58);
            if (first_colon == -1) {
                Error.BAD_THIN_DATABASE(this.database);
            }
            if ((second_colon = this.database.indexOf(58, first_colon + 1)) == -1) {
                Error.BAD_THIN_DATABASE(this.database);
            }
        } else {
            boolean bl = this.driver.equals("thin") && this.database != null;
        }
        Object[] result = new String[argsLeft.size()];
        argsLeft.copyInto(result);
        return result;
    }

    public String promptPassword() throws ToolsException {
        StringBuffer buffer = new StringBuffer();
        try {
            try {
                char c;
                System.err.print("password: ");
                System.err.flush();
                while ((c = (char)System.in.read()) != '\uffffffff') {
                    if (c != '\n' && c != '\r') {
                        buffer.append(c);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Error.COULD_NOT_READ_PASSWORD(e.toString());
            }
            Object var3_4 = null;
            System.err.println();
            System.err.flush();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            System.err.println();
            System.err.flush();
            throw throwable;
        }
        return buffer.toString();
    }

    public void tryFullDBString(String dbString) throws ToolsException {
        int user_start = 0;
        int user_end = 0;
        int password_start = 0;
        int password_end = 0;
        int database_start = 0;
        int database_end = 0;
        int slash_index = dbString.indexOf("/");
        int at_index = dbString.indexOf("@");
        if (slash_index != -1 && at_index != -1 && slash_index > at_index) {
            Error.BAD_DATABASE_ARGUMENT(dbString);
        }
        user_start = 0;
        user_end = slash_index != -1 ? slash_index : (at_index != -1 ? at_index : dbString.length());
        if (slash_index != -1) {
            password_start = slash_index + 1;
            password_end = at_index == -1 ? dbString.length() : at_index;
        }
        if (at_index != -1) {
            database_start = at_index + 1;
            database_end = dbString.length();
        }
        this.user = dbString.substring(user_start, user_end);
        if (slash_index != -1) {
            this.password = dbString.substring(password_start, password_end);
        }
        if (at_index != -1) {
            this.database = dbString.substring(database_start, database_end);
        }
    }
}

