/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.publishing;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import oracle.aurora.AuroraServices.ActivatableObject;
import oracle.aurora.AuroraServices.ActivationException;
import oracle.aurora.AuroraServices.MinorCodes;
import oracle.aurora.AuroraServices._PublishedObjectImplBase;
import oracle.aurora.AuroraServices.objAttribs;
import oracle.aurora.AuroraServices.objAttribsHolder;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.DbmsRealm;
import oracle.aurora.rdbms.ExecutePermissionException;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.server.ORB;
import oracle.aurora.server.publishing.NamespaceRDBMS;
import oracle.aurora.server.publishing.Node;
import oracle.aurora.server.publishing.PublishingContextImpl;
import oracle.aurora.vm.ClassNotResolvedException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.StringHolder;

public final class PublishedObjectImpl
extends _PublishedObjectImplBase
implements Node {
    private long node;
    private Object object;
    private Date activated;
    protected static NamespaceRDBMS db = PublishingContextImpl.db;

    private PublishedObjectImpl() {
    }

    PublishedObjectImpl(long id) {
        this.node = id;
        com.visigenic.vbroker.orb.ORB _orb = (com.visigenic.vbroker.orb.ORB)ORB.init();
        _orb.BOA_init().obj_is_ready((Object)this);
    }

    private Object _activate() throws SQLException, ActivationException {
        if (this.object != null) {
            if (this.activated.after(db.get_last_modified(this.node))) {
                return this.object;
            }
            this.object = null;
        }
        Class theClass = null;
        java.lang.Object[] c_and_s = db.get_object_class_and_schema(this.node);
        String className = (String)c_and_s[0];
        try {
            Schema schema = Schema.lookup((int)((Integer)c_and_s[1]));
            theClass = DbmsJava.classForNameAndSchema((String)className, (Schema)schema);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                theClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ActivationException("Class Not Found: " + className);
            }
        }
        catch (ExecutePermissionException e) {
            throw new ActivationException("User does not have execute permissions: " + e.getMessage());
        }
        catch (ClassNotResolvedException e) {
            throw new ActivationException("The class has dependencies which cannot be resolved: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ActivationException("The class does not exist: " + e.getMessage());
        }
        try {
            Schema invalidUser = Schema.lookup((String)"AURORA$ORB$UNAUTHENTICATED");
            if (Schema.currentSchema().equals((java.lang.Object)invalidUser) && !className.equals("oracle.aurora.server.LoginServerImpl")) {
                throw new NO_PERMISSION(MinorCodes.getMessage(18), 18, CompletionStatus.COMPLETED_NO);
            }
            java.lang.Object o = theClass.newInstance();
            if (o instanceof ActivatableObject) {
                this.object = ((ActivatableObject)o)._initializeAuroraObject();
            } else {
                try {
                    this.object = (Object)o;
                }
                catch (ClassCastException classCastException) {
                    System.err.println("The class: " + theClass + " does not implement the org.omg.CORBA.Object interface");
                    throw new ActivationException("The class: " + theClass + " does not implement the org.omg.CORBA.Object interface");
                }
            }
            this.activated = new Date();
            com.visigenic.vbroker.orb.ORB _orb = (com.visigenic.vbroker.orb.ORB)ORB.init();
            _orb.BOA_init().obj_is_ready(this.object);
            return this.object;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.err.println("The class: " + theClass + " does not have a public, no argument constructor");
            throw new ActivationException("The class: " + theClass + " does not have a public, no argument constructor");
        }
        catch (ExceptionInInitializerError e) {
            System.err.println("An error occured during static initialization of " + theClass + ":" + e.getException().getMessage());
            e.getException().printStackTrace();
            throw new ActivationException("An error occured during initialization of " + theClass + e.getException().getMessage());
        }
        catch (InstantiationException instantiationException) {
            System.err.println("An error occured during instantiation of " + theClass);
            throw new ActivationException("An error occured during instantiation of " + theClass);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("The class is not a public class, or the no argument constructor is not declared public in class " + className);
            throw new ActivationException("The class is not a public class, or the no argument constructor is not declared public in class " + className);
        }
    }

    public Object activate(StringHolder classHelperName) throws ActivationException {
        try {
            db.beginTxn();
            if (!this.check_execute_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            classHelperName.value = db.get_object_helper(this.node);
            Object obj = this._activate();
            db.commitROTxn();
            return obj;
        }
        catch (SQLException e) {
            db.abortTxn();
            e.printStackTrace();
            throw new ActivationException("SQL Exception: " + e.getMessage());
        }
    }

    public Object activate_no_helper() throws ActivationException {
        try {
            db.beginTxn();
            if (!this.check_execute_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            Object obj = this._activate();
            db.commitROTxn();
            return obj;
        }
        catch (SQLException e) {
            db.abortTxn();
            e.printStackTrace();
            throw new ActivationException("SQL Exception: " + e.getMessage());
        }
    }

    boolean check_execute_rights() throws SQLException {
        return this.check_rights(NamespaceRDBMS.EXECUTE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean check_owner() throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        block7: {
            boolean bl2;
            block6: {
                Schema schema = Schema.currentSchema();
                if (schema == DbmsRealm.theSystemSchema) {
                    return true;
                }
                pstmt = null;
                rs = null;
                try {
                    pstmt = NamespaceRDBMS.con.prepareStatement("select owner from " + NamespaceRDBMS.inode + " where node = ?");
                    pstmt.setLong(1, this.node);
                    rs = db.execute(pstmt);
                    if (rs.next()) {
                        int uorid = rs.getInt(1);
                        if (uorid == DbmsRealm.thePublicSchema.ownerNumber() || schema.equals(uorid)) {
                            boolean bl3 = true;
                            java.lang.Object var6_8 = null;
                            db.close(pstmt);
                            db.close(rs);
                            return bl3;
                        }
                        if (DbmsJava.isRoleEnabled((int)uorid)) {
                            bl2 = true;
                            break block6;
                        }
                    }
                    bl = false;
                    break block7;
                }
                catch (Throwable throwable) {
                    java.lang.Object var6_11 = null;
                    db.close(pstmt);
                    db.close(rs);
                    throw throwable;
                }
            }
            java.lang.Object var6_9 = null;
            db.close(pstmt);
            db.close(rs);
            return bl2;
        }
        java.lang.Object var6_10 = null;
        db.close(pstmt);
        db.close(rs);
        return bl;
    }

    boolean check_read_rights() throws SQLException {
        return this.check_rights(NamespaceRDBMS.READ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean check_rights(int right) throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        block5: {
            boolean bl2;
            pstmt = null;
            rs = null;
            if (this.check_owner()) {
                return true;
            }
            Schema schema = Schema.currentSchema();
            try {
                int uorid;
                pstmt = NamespaceRDBMS.con.prepareStatement("select schema from " + NamespaceRDBMS.permissions + " where node = :1 and type = :2");
                pstmt.setLong(1, this.node);
                pstmt.setInt(2, right);
                rs = db.execute(pstmt);
                do {
                    if (!rs.next()) {
                        bl = false;
                        break block5;
                    }
                    uorid = rs.getInt(1);
                    if (uorid != DbmsRealm.thePublicSchema.ownerNumber() && !schema.equals(uorid)) continue;
                    boolean bl3 = true;
                    java.lang.Object var7_9 = null;
                    db.close(pstmt);
                    db.close(rs);
                    return bl3;
                } while (!DbmsJava.isRoleEnabled((int)uorid));
                bl2 = true;
            }
            catch (Throwable throwable) {
                java.lang.Object var7_12 = null;
                db.close(pstmt);
                db.close(rs);
                throw throwable;
            }
            java.lang.Object var7_10 = null;
            db.close(pstmt);
            db.close(rs);
            return bl2;
        }
        java.lang.Object var7_11 = null;
        db.close(pstmt);
        db.close(rs);
        return bl;
    }

    boolean check_write_rights() throws SQLException {
        return this.check_rights(NamespaceRDBMS.WRITE);
    }

    public void destroy() {
        try {
            db.beginTxn();
            if (!this.check_owner()) {
                throw new NO_PERMISSION();
            }
            db.delete(this.node);
            Date date = this.activated;
            synchronized (date) {
                PublishingContextImpl.activated.remove(new Long(this.node));
            }
            com.visigenic.vbroker.orb.ORB _orb = (com.visigenic.vbroker.orb.ORB)ORB.init();
            _orb.BOA_init().deactivate_obj((Object)this);
            db.commitTxn();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            throw new PERSIST_STORE("SQL Exception: " + e.getMessage());
        }
    }

    public void get_attributes(objAttribsHolder attribs) {
        try {
            db.beginTxn();
            if (!this.check_read_rights()) {
                db.commitROTxn();
                String es = "";
                String[] sc = new String[]{};
                attribs.value = new objAttribs(es, es, es, es, es, es, sc, sc, sc);
                return;
            }
            attribs.value = db.get_object_attributes(this.node);
            db.commitROTxn();
        }
        catch (SQLException e) {
            db.abortTxn();
            e.printStackTrace();
            throw new PERSIST_STORE("SQL Exception: " + e.getMessage());
        }
    }

    public long node() {
        return this.node;
    }

    private boolean nullString(String s) {
        if (s == null) {
            return true;
        }
        return s.equals("");
    }

    public void republish(String className, String helper) {
        try {
            db.beginTxn();
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            this.object = null;
            String[] rights = new String[]{Schema.currentSchema().toString()};
            db.set_read_rights(this.node, rights);
            db.set_write_rights(this.node, rights);
            db.set_execute_rights(this.node, rights);
            db.republish(this.node, className, helper);
            db.commitTxn();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            throw new PERSIST_STORE("SQL Exception: " + e.getMessage());
        }
    }

    public void republish_in(String className, String schema, String helper) {
        Schema invalidUser = Schema.lookup((String)"AURORA$ORB$UNAUTHENTICATED");
        if (Schema.currentSchema().equals((java.lang.Object)invalidUser)) {
            throw new NO_PERMISSION(MinorCodes.getMessage(18), 18, CompletionStatus.COMPLETED_NO);
        }
        try {
            db.beginTxn();
            if (!this.check_write_rights()) {
                db.commitROTxn();
                throw new NO_PERMISSION();
            }
            this.object = null;
            String[] rights = new String[]{Schema.currentSchema().toString()};
            db.set_read_rights(this.node, rights);
            db.set_write_rights(this.node, rights);
            db.set_execute_rights(this.node, rights);
            db.republish(this.node, className, NamespaceRDBMS.lookup_schema(schema), helper);
            db.commitTxn();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            throw new PERSIST_STORE("SQL Exception: " + e.getMessage());
        }
    }

    public void set_attributes(String owner, String[] read, String[] write, String[] execute) {
        try {
            db.beginTxn();
            if (!this.check_owner()) {
                throw new NO_PERMISSION();
            }
            if (!this.nullString(owner)) {
                if (Schema.currentSchema() != DbmsRealm.theSystemSchema) {
                    throw new NO_PERMISSION();
                }
                db.set_owner(this.node, NamespaceRDBMS.lookup_schema(owner));
            }
            if (read.length > 0) {
                db.set_read_rights(this.node, read);
            }
            if (write.length > 0) {
                db.set_write_rights(this.node, write);
            }
            if (execute.length > 0) {
                db.set_execute_rights(this.node, execute);
            }
            db.commitTxn();
        }
        catch (SQLException e) {
            e.printStackTrace();
            db.abortTxn();
            throw new PERSIST_STORE("SQL Exception: " + e.getMessage());
        }
    }

    public String toString() {
        return "Object : " + this.node;
    }
}

