/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server;

import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ProtocolAdapter;
import com.visigenic.vbroker.orb.ServerThreadInfo;
import com.visigenic.vbroker.orb.ThreadLocal;
import java.net.Socket;
import org.omg.CORBA.OBJ_ADAPTER;

public class ThreadSessionDispatcher
implements Adapter.Dispatcher {
    private boolean _busy = false;
    private long _lastUsed = 0L;
    private ProtocolAdapter _pa;
    private ORB _orb;
    private Adapter _adapter;
    private static final int Initial = 0;
    private static final int Active = 1;
    private static final int Holding = 2;
    private static final int Deactivated = 3;
    private static final int Deactivating = 4;
    private int _state = 0;

    public ThreadSessionDispatcher(ORB orb, Adapter adapter, ProtocolAdapter pa, Connection connection) {
        this._orb = orb;
        this._adapter = adapter;
        this._pa = pa;
        this._pa.initialize(connection);
    }

    public synchronized void activate() {
        this._state = 1;
    }

    public boolean busy() {
        return this._busy;
    }

    public synchronized void deactivate() {
        if (this._state == 0 || this._state == 3 || this._state == 4) {
            return;
        }
        this._state = 4;
        this._state = 3;
        this._pa.destroy();
        this._adapter.dispatcherCompleted((Adapter.Dispatcher)this);
    }

    public synchronized boolean deactivateIfNotUsedSince(long time) {
        if (this._busy) {
            return false;
        }
        if (this._lastUsed > time) {
            return false;
        }
        this.deactivate();
        return true;
    }

    public synchronized void hold() {
        if (this._state == 0) {
            throw new OBJ_ADAPTER("Cannot hold() unless Dispatcher is activated.");
        }
        this._state = 2;
    }

    public synchronized boolean holdIfNotUsedSince(long time) {
        if (this._busy) {
            return false;
        }
        if (this._lastUsed > time) {
            return false;
        }
        this.hold();
        return true;
    }

    public synchronized long lastUsed() {
        return this._lastUsed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(Socket s) {
        int msgs = 3;
        ServerThreadInfo _tls = ServerThreadInfo.instance((ORB)this._orb);
        try {
            int i = 0;
            while (i < msgs) {
                Object message = this._pa.readMessage((ThreadLocal)_tls);
                if (message == null) return;
                this._pa.dispatchMessage(message, (ThreadLocal)_tls);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            _tls = null;
            throw throwable;
        }
    }
}

