/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server;

import com.visigenic.vbroker.GIOP.Version;
import com.visigenic.vbroker.IIOP_1_1.ProfileBody;
import com.visigenic.vbroker.IIOP_1_1.ProfileBodyHelper;
import com.visigenic.vbroker.IOP.TaggedComponent;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopProtocol;
import com.visigenic.vbroker.orb.IiopProtocolImpl;
import com.visigenic.vbroker.orb.ProtocolAdapter;
import oracle.aurora.server.GiopProtocolAdapter;
import oracle.aurora.server.VCListener;
import oracle.aurora.ssl.SSLComponentBody;
import oracle.aurora.ssl.SSLComponentBodyHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class IiopProtocol
extends IiopProtocolImpl {
    public ProtocolAdapter createProtocolAdapter(Adapter adapter) {
        return new GiopProtocolAdapter(this._orb, adapter, (GiopProtocol)this);
    }

    public String prettyPrint(TaggedProfile profile) {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        ProfileBody profileBody = this.profileBody(profile);
        buffer.append("IIOP Profile:" + nl);
        buffer.append("    version: " + profileBody.iiop_version.major + "." + profileBody.iiop_version.minor + nl);
        buffer.append("    host: " + profileBody.host + nl);
        buffer.append("    port: " + this.port(profileBody) + nl);
        buffer.append("    Object Key: " + this._orb.toObjectId(profileBody.object_key) + nl);
        if (profileBody.iiop_version.minor == 1) {
            buffer.append("Detected a 1.1 profile" + nl);
        }
        int i = 0;
        while (i < profileBody.components.length) {
            buffer.append("Component " + i + "-");
            if (profileBody.components[i].tag == 20) {
                buffer.append("SSL component " + nl);
                TaggedComponent comp = profileBody.components[i];
                GiopInputStream input = this._orb.newGiopInputStream(comp.component_data);
                input.byteOrder(input.read_boolean());
                SSLComponentBody body = SSLComponentBodyHelper.read((InputStream)input);
                buffer.append("target_supports = " + body.target_supports + nl);
                buffer.append("target_requires = " + body.target_requires + nl);
                buffer.append("port = " + body.port + nl);
            } else {
                buffer.append("Unknown component " + nl);
            }
            ++i;
        }
        return buffer.toString();
    }

    public TaggedProfile taggedProfile(ProfileBody profileBody) {
        GiopOutputStream output = this._orb.newGiopOutputStream();
        output.byteOrder(false);
        output.write_boolean(false);
        boolean _is_ssl_connection = VCListener.isSSLConnection();
        if (this._orb.AuroraDebug) {
            System.out.println("is_ssl_connection = " + _is_ssl_connection);
        }
        if (_is_ssl_connection) {
            short portNumber = profileBody.port;
            String ipAddr = profileBody.host;
            byte[] oid = profileBody.object_key;
            Version version = new Version(1, 1);
            SSLComponentBody compBody = new SSLComponentBody(32, 32, portNumber);
            GiopOutputStream compOut = this._orb.newGiopOutputStream();
            compOut.write_boolean(false);
            SSLComponentBodyHelper.write((OutputStream)compOut, compBody);
            byte[] compData = compOut.toByteArray();
            TaggedComponent comp = new TaggedComponent(20, compData);
            int ncomp = profileBody.components != null ? profileBody.components.length + 1 : 1;
            TaggedComponent[] components = new TaggedComponent[ncomp];
            components[0] = comp;
            int i = 1;
            while (i < ncomp) {
                components[i] = profileBody.components[i - 1];
                ++i;
            }
            ProfileBody tmpProfBody = new ProfileBody(version, ipAddr, portNumber, oid, components);
            ProfileBodyHelper.write((OutputStream)output, (ProfileBody)tmpProfBody);
        } else {
            ProfileBodyHelper.write((OutputStream)output, (ProfileBody)profileBody);
        }
        byte[] profileData = output.toByteArray();
        TaggedProfile profile = new TaggedProfile(0, profileData);
        return profile;
    }
}

