/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jts.server;

import com.visigenic.vbroker.GIOP.ReplyHeader;
import com.visigenic.vbroker.GIOP.ReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.ReplyHeaderHolder;
import com.visigenic.vbroker.GIOP.ReplyStatusType;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.IOP.ServiceContext;
import com.visigenic.vbroker.interceptor.Closure;
import com.visigenic.vbroker.interceptor.DefaultServerInterceptor;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopOutputStreamImpl;
import com.visigenic.vbroker.orb.ORB;
import oracle.aurora.jts.server.AuroraTransactionService;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import org.omg.CORBA.Environment;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.PropagationContextHolder;

public class ServerInterceptor
extends DefaultServerInterceptor {
    ORB _orb = null;
    final int MAX_ALIGNMENT = 8;

    public ServerInterceptor() {
    }

    public ServerInterceptor(org.omg.CORBA.ORB orb) {
        this._orb = (ORB)orb;
    }

    public void prepare_reply(RequestHeader reqHdr, ReplyHeaderHolder hdr, Object target, Closure closure) {
        PropagationContextHolder holder = new PropagationContextHolder();
        try {
            ((AuroraTransactionService)TS.getTS()).sending_reply(hdr.value.request_id, holder);
        }
        catch (NoTransactionServiceException noTransactionServiceException) {}
        if (hdr.value.reply_status != ReplyStatusType.USER_EXCEPTION && hdr.value.reply_status != ReplyStatusType.SYSTEM_EXCEPTION && holder.value != null) {
            int contextListLength = hdr.value.service_context.length;
            if (contextListLength > 0) {
                ServiceContext[] tempList = hdr.value.service_context;
                hdr.value.service_context = new ServiceContext[contextListLength + 1];
                System.arraycopy(tempList, 0, hdr.value.service_context, 0, contextListLength);
            } else {
                hdr.value.service_context = new ServiceContext[1];
            }
            GiopOutputStream output = this._orb.newGiopOutputStream();
            holder._write((OutputStream)output);
            int offset = output.offset() + 16 + 12;
            int pad = (offset - 8) % 8;
            if (pad != 0) {
                byte[] padBytes = new byte[pad];
                output.write_octet_array(padBytes, 0, pad);
            }
            byte[] buffer = output.toByteArray();
            hdr.value.service_context[contextListLength] = new ServiceContext();
            hdr.value.service_context[contextListLength].context_id = 0;
            hdr.value.service_context[contextListLength].context_data = buffer;
        }
    }

    public InputStream receive_request(RequestHeader hdr, ObjectHolder object, InputStream buf, Closure closure) {
        int i = 0;
        while (i < hdr.service_context.length) {
            if (hdr.service_context[i].context_id == 0) {
                byte[] buffer = hdr.service_context[i].context_data;
                GiopInputStream input = this._orb.newGiopInputStream(buffer);
                PropagationContext cxt = PropagationContextHelper.read((InputStream)input);
                try {
                    ((AuroraTransactionService)TS.getTS()).received_request(hdr.request_id, cxt);
                }
                catch (NoTransactionServiceException e) {
                    e.printStackTrace();
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public OutputStream send_reply(RequestHeader reqHdr, ReplyHeader hdr, Object target, OutputStream buf, Environment env, Closure closure) {
        GiopOutputStreamImpl ostr = (GiopOutputStreamImpl)buf;
        int dataStart = ostr.dataOffset();
        int dataEnd = ostr.offset();
        int dataLen = dataEnd - dataStart;
        GiopOutputStreamImpl tmpOut = (GiopOutputStreamImpl)this._orb.newGiopOutputStream();
        byte[] orgBytes = ostr.bytes();
        tmpOut.byteOrder(ostr.byteOrder());
        tmpOut.write_octet_array(orgBytes, 0, 12);
        ReplyHeaderHelper.write((OutputStream)tmpOut, (ReplyHeader)hdr);
        tmpOut.write_octet_array(orgBytes, dataStart, dataLen);
        return tmpOut;
    }
}

