/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jndi.sess_iiop;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.jndi.orb_dep.Orb;
import oracle.aurora.jndi.sess_iiop.BindingEnumeration;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;
import oracle.aurora.jndi.sess_iiop.ServiceId;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.jndi.sess_iiop.SessionNameParser;
import oracle.aurora.jndi.sess_iiop.sess_iiopContext;

public class sess_iiopURLContext
implements sess_iiopContext {
    private static ResourceBundle resMessages = ResourceBundle.getBundle("oracle.aurora.jndi.sess_iiop.Messages");
    protected Hashtable env;
    protected Hashtable bindings = new Hashtable(5, 0.75f);
    private static Orb __orb = new Orb();
    final SessionNameParser parser = new SessionNameParser();
    public static final String DEFAULT_SERVICE = "default";
    public static final String THIS_SERVER = "thisServer";
    public static final String SERVER_PORT = "oracle.aurora.server.ORB.LISTENING_PORT";
    public static final String SERVER_CONTEXT = "oracle.aurora.server.ORB.INITIAL_CONTEXT";

    sess_iiopURLContext(Hashtable _env) {
        this.env = (Hashtable)_env.clone();
        if (!SessionCtx.inServer()) {
            return;
        }
        String sp = System.getProperty(SERVER_PORT);
        if (sp == null) {
            return;
        }
        Short prop = Short.valueOf(sp);
        short port = prop;
        try {
            String localHost = InetAddress.getLocalHost().getHostAddress();
            ServiceCtx thisService = this.bindNewService(this.parser.parse(String.valueOf(localHost) + ":" + port));
            thisService.bindInitialContext(SessionCtx.thisContext());
            this.bindings.put(THIS_SERVER, thisService);
        }
        catch (Exception e) {
            System.out.println("Exception during initialization of this session's default service");
            e.printStackTrace();
        }
    }

    public Object _lookup(String string) throws NamingException {
        return this._lookup(this.parser.parse(string));
    }

    public Object _lookup(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return this;
        }
        try {
            sess_iiopContext ctx = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                ctx = (sess_iiopContext)this.bindings.get(name.get(0));
            }
            if (ctx == null) {
                ctx = this.bindNewService(name);
            }
            if (name.size() == 1) {
                return ctx;
            }
            return ctx._lookup(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public Object addToEnvironment(String key, Object value) throws NamingException {
        return this.env.put(key, value);
    }

    public void bind(String key, Object value) throws NamingException {
        this.bind(this.parser.parse(key), value);
    }

    public void bind(Name name, Object object) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            if (object instanceof ServiceCtx) {
                throw new NotContextException(resMessages.getString("ONLY_SERVICES"));
            }
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                this.bindings.put(name.get(0), object);
            }
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.bind(name.getSuffix(1), object);
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    private synchronized ServiceCtx bindNewService(Name name) throws InvalidNameException, CommunicationException {
        ServiceId id = new ServiceId(name);
        ServiceCtx service = new ServiceCtx(this.env, id);
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            if (this.bindings.size() == 0) {
                this.bindings.put(DEFAULT_SERVICE, service);
            }
            this.bindings.put(id.toString(), service);
            this.bindings.put(name.get(0), service);
        }
        return service;
    }

    public void close() throws NamingException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Enumeration sessions = this.bindings.elements();
            while (sessions.hasMoreElements()) {
                ((Context)sessions.nextElement()).close();
            }
        }
        this.env = null;
        this.bindings = null;
    }

    public String composeName(String name1, String name2) throws NamingException {
        if (name2.equals("")) {
            return name1;
        }
        if (name1.equals("")) {
            return name2;
        }
        return String.valueOf(String.valueOf(name2)) + "/" + name1;
    }

    public Name composeName(Name name1, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name1);
        return name3;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.parser.parse(name));
    }

    public Context createSubcontext(Name arg1) throws NamingException {
        return null;
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(this.parser.parse(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            try {
                Context ctx = null;
                Hashtable hashtable = this.bindings;
                synchronized (hashtable) {
                    ctx = (Context)this.bindings.remove(name.get(0));
                }
                ctx.close();
            }
            catch (ClassCastException classCastException) {
                throw new NotContextException();
            }
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.destroySubcontext(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    private ServiceCtx findService(ServiceId id) {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Enumeration services = this.bindings.elements();
            while (services.hasMoreElements()) {
                ServiceCtx service = (ServiceCtx)services.nextElement();
                if (!service.equals(id)) continue;
                ServiceCtx serviceCtx = service;
                Object var4_6 = null;
                return serviceCtx;
            }
        }
        return null;
    }

    private Enumeration getBindings() {
        Vector<Binding> b = null;
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            b = new Vector<Binding>(this.bindings.size());
            Enumeration keys = this.bindings.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object obj = this.bindings.get(key);
                b.addElement(new Binding(key, obj));
            }
        }
        return b.elements();
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Cannot retreive full name");
    }

    public NameParser getNameParser(String arg1) throws NamingException {
        return this.parser;
    }

    public NameParser getNameParser(Name arg1) throws NamingException {
        return this.parser;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(this.parser.parse(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return new BindingEnumeration(this.getBindings());
        }
        try {
            Context ctx = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                ctx = (Context)this.bindings.get(name.get(0));
            }
            return ctx.listBindings(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(this.parser.parse(string));
    }

    public Object lookup(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return this;
        }
        try {
            Context ctx = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                ctx = (Context)this.bindings.get(name.get(0));
                if (ctx == null) {
                    ctx = this.bindNewService(name);
                }
            }
            if (name.size() == 1) {
                return ctx;
            }
            return ctx.lookup(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rebind(String string, Object obj) throws NamingException {
        this.rebind(this.parser.parse(string), obj);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            if (object instanceof ServiceCtx) {
                throw new NotContextException(resMessages.getString("ONLY_SERVICES"));
            }
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                this.bindings.put(name.get(0), object);
            }
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.rebind(name.getSuffix(1), object);
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    public Object removeFromEnvironment(String key) throws NamingException {
        return this.env.remove(key);
    }

    public void rename(String from, String to) throws NamingException {
        this.rename(this.parser.parse(from), this.parser.parse(to));
    }

    public void rename(Name from, Name to) throws NamingException {
        from = this.trim(from);
        to = this.trim(to);
        if (from.size() == 0 || to.size() == 0) {
            throw new InvalidNameException(resMessages.getString("ONE_OR_BOTH_NAMES_EMPTY"));
        }
        Object object = this._lookup(from);
        this.bind(to, object);
        this.unbind(from);
    }

    public sess_iiopURLContext setEnv(Hashtable _env) {
        this.env = (Hashtable)_env.clone();
        return this;
    }

    private Name trim(Name name) throws NamingException {
        if (name.size() == 0) {
            return name;
        }
        if (name.get(0).equals("sess_iiop:")) {
            name = name.getSuffix(1);
        }
        while (name.size() > 0 && name.get(0).equals("")) {
            name = name.getSuffix(1);
        }
        return name;
    }

    public void unbind(String string) throws NamingException {
        this.unbind(this.parser.parse(string));
    }

    public void unbind(Name n) throws NamingException {
        Name name = this.trim(n);
        if (name.size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                this.bindings.remove(name.get(0));
            }
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.unbind(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }
}

