/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jndi.sess_iiop;

import java.util.ResourceBundle;
import javax.naming.CannotProceedException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public final class ExceptionMapper {
    private static ResourceBundle resMessages = ResourceBundle.getBundle("oracle.aurora.jndi.sess_iiop.Messages");

    private ExceptionMapper() {
    }

    public static final NamingException mapAlreadyBoundExc(AlreadyBound alreadyBound) {
        NameAlreadyBoundException e = new NameAlreadyBoundException(resMessages.getString("NAME_ALREADY_BOUND"));
        e.setRootCause((Throwable)((Object)alreadyBound));
        return e;
    }

    public static final NamingException mapCannotProceedExc(CannotProceed cannotProceed) {
        CannotProceedException e = new CannotProceedException(resMessages.getString("UNABLE_TO_CONTINUE"));
        e.setRootCause((Throwable)((Object)cannotProceed));
        return e;
    }

    public static final NamingException mapInvalidNameExc(InvalidName invalidName) {
        InvalidNameException e = new InvalidNameException(resMessages.getString("INVALID_NAME"));
        e.setRootCause((Throwable)((Object)invalidName));
        return e;
    }

    public static final NamingException mapNoPermExec(NO_PERMISSION noPermission) {
        NoPermissionException e = new NoPermissionException(resMessages.getString("NO_PERMISSION"));
        e.setRootCause((Throwable)noPermission);
        return e;
    }

    public static final NamingException mapNotEmptyExc(NotEmpty notEmpty) {
        ContextNotEmptyException e = new ContextNotEmptyException(resMessages.getString("CONTEXT_NOT_EMPTY"));
        e.setRootCause((Throwable)((Object)notEmpty));
        return e;
    }

    public static final NamingException mapNotFoundExc(NotFound notFound) {
        NameNotFoundException e = new NameNotFoundException(resMessages.getString("NO_OBJECT_BOUND"));
        e.setRootCause((Throwable)((Object)notFound));
        return e;
    }
}

