/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.server;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.deployment.Identity;
import javax.jts.UserTransaction;
import oracle.aurora.jts.AuroraUserTransaction;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.Schema;

public class AuroraEJBContext
implements EJBContext,
Serializable {
    private EJBHome home;
    private EJBObject object;
    private Properties environment;
    private boolean rollbackOnly = false;
    private UserTransaction userTxn;

    protected AuroraEJBContext() {
    }

    protected AuroraEJBContext(EJBObject o, EJBHome h, UserTransaction u, String[][] props) {
        this.home = h;
        this.object = o;
        this.userTxn = u;
        this.environment = new Properties();
        int i = 0;
        while (i < props.length) {
            if (props[i][0] != null) {
                ((Hashtable)this.environment).put(props[i][0], props[i][1]);
            }
            ++i;
        }
    }

    public final java.security.Identity getCallerIdentity() {
        return new Identity(Schema.currentSchema().toString());
    }

    public final EJBHome getEJBHome() {
        return this.home;
    }

    public final EJBObject getEJBObject() throws IllegalStateException {
        return this.object;
    }

    public final Properties getEnvironment() {
        return this.environment;
    }

    public final boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public final UserTransaction getUserTransaction() throws IllegalStateException {
        return this.userTxn;
    }

    public final boolean isCallerInRole(java.security.Identity role) {
        int current = Schema.currentSchema().ownerNumber();
        int rid = Schema.lookupRole((String)role.getName()).ownerNumber();
        return DbmsJava.hasRole((int)current, (int)rid);
    }

    protected final void setEJBHome(EJBHome h) {
        this.home = h;
    }

    protected final void setEJBObject(EJBObject o) {
        this.object = o;
    }

    public final void setEnvironment(String[][] props) {
        if (this.environment != null) {
            return;
        }
        this.environment = new Properties();
        int i = 0;
        while (i < props.length) {
            ((Hashtable)this.environment).put(props[i][0], props[i][1]);
            ++i;
        }
    }

    public final void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    protected final void setUserTransaction(AuroraUserTransaction txn) {
        this.userTxn = txn;
    }
}

