/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment.server;

import java.util.Date;
import oracle.aurora.ejb.deployment.server.BeanGenerator;
import oracle.aurora.ejb.deployment.server.EjbRuntimeGenerator;
import oracle.aurora.ncomp.jasper.binary.BinaryFieldInspector;
import oracle.aurora.ncomp.java.BinaryField;
import oracle.aurora.ncomp.java.ClassDeclaration;
import oracle.aurora.ncomp.java.ClassDefinition;
import oracle.aurora.ncomp.java.ClassNotFound;
import oracle.aurora.ncomp.java.FieldDefinition;
import oracle.aurora.ncomp.java.Identifier;
import oracle.aurora.ncomp.javac.SourceFile;
import oracle.aurora.ncomp.tree.Syntax;
import oracle.aurora.ncomp.tree.c.SectionComment;
import oracle.aurora.ncomp.tree.documentation.Documentation;

abstract class EjbRuntimeGeneratorDriver {
    private EjbRuntimeGenerator stubGenerator;
    private Identifier stubName;
    BeanGenerator generationContext;

    EjbRuntimeGeneratorDriver(BeanGenerator genCtxt, EjbRuntimeGenerator stubGenerator) {
        this.generationContext = genCtxt;
        this.setStubGenerator(stubGenerator);
        this.setStubName(this.computeStubName());
        this.generationContext = genCtxt;
    }

    Syntax build() {
        return null;
    }

    Identifier classBaseName() {
        return this.getStubGenerator().getDefinition().getName().getName();
    }

    protected abstract Identifier computeStubName();

    protected String fileExtension() {
        return ".java";
    }

    protected Documentation fileHeader() {
        return new SectionComment(String.valueOf(String.valueOf(this.getStubName())) + ": generated Oracle Aurora EJB Runtime for \n" + this.getStubGenerator().getDefinition() + "\n\nGenerated on " + new Date());
    }

    void forEachField(BinaryFieldInspector handler) {
        ClassDefinition baseClass = this.getStubGenerator().getDefinition();
        FieldDefinition f = baseClass.getFirstField();
        while (f != null) {
            FieldDefinition temp = f;
            if (temp != null && temp instanceof BinaryField) {
                BinaryField bf = (BinaryField)temp;
                handler.run(bf);
            }
            f = f.getNextField();
        }
        ClassDeclaration[] interfaces = baseClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ClassDefinition current = null;
            try {
                current = interfaces[i].getClassDefinition(this.getStubGenerator().getEnv());
            }
            catch (ClassNotFound e) {
                System.err.println("Unable to find in classpath the required class: " + e.name.toString());
                System.exit(1);
            }
            String currentName = current.getName().toString();
            if (!currentName.equals("javax.ejb.EJBHome") && !currentName.equals("javax.ejb.EJBObject")) {
                FieldDefinition f2 = current.getFirstField();
                while (f2 != null) {
                    FieldDefinition temp = f2;
                    if (temp != null && temp instanceof BinaryField) {
                        BinaryField bf = (BinaryField)temp;
                        handler.run(bf);
                    }
                    f2 = f2.getNextField();
                }
            }
            ++i;
        }
    }

    void generate() {
        SourceFile file = new SourceFile(String.valueOf(String.valueOf(this.getStubName())) + this.fileExtension(), this.fileHeader());
        file.add(this.build());
        this.getStubGenerator().emit(file);
    }

    public EjbRuntimeGenerator getStubGenerator() {
        return this.stubGenerator;
    }

    public Identifier getStubName() {
        return this.stubName;
    }

    public void setStubGenerator(EjbRuntimeGenerator stubGenerator_newValue) {
        this.stubGenerator = stubGenerator_newValue;
    }

    public void setStubName(Identifier stubName_newValue) {
        this.stubName = stubName_newValue;
    }
}

