/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.console.views.table.SortableHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CvBaseTableModel
extends AbstractTableModel {
    protected static SortableHeaderRenderer asRenderer = new SortableHeaderRenderer(true);
    protected static SortableHeaderRenderer deasRenderer = new SortableHeaderRenderer(false);
    protected static TableCellRenderer defaultHeader;
    protected String[] columnNames = new String[0];
    protected Vector rows = new Vector();
    int oldColumn = -1;
    int compares;
    protected int[] indexes;
    int[] sortableColumn = null;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    boolean reclick = true;
    public MouseAdapter listMouseListener;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public CvBaseTableModel() {
        this.indexes = new int[0];
    }

    public CvBaseTableModel(String[] stringArray, Vector vector) {
        this.columnNames = stringArray;
        if (!vector.isEmpty()) {
            this.rows = vector;
        }
        this.reallocateIndexes();
    }

    public void addData(Vector vector) {
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        int n3 = vector.size() / n;
        int n4 = 0;
        while (n4 < n3) {
            Vector vector2 = new Vector();
            int n5 = 0;
            while (n5 < n) {
                vector2.addElement(vector.get(n4 * n + n5));
                ++n5;
            }
            this.rows.addElement(vector2);
            ++n4;
        }
        this.fireTableRowsInserted(n2 + 1, n2 + n3);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        this.listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 2 && n2 != -1) {
                    if (sortableColumn != null) {
                        int n3 = 0;
                        while (n3 < sortableColumn.length) {
                            if (n2 == sortableColumn[n3]) {
                                if (n2 != oldColumn) {
                                    reclick = true;
                                }
                                boolean bl = reclick;
                                this.setSortableColumn(jTable2, n, bl);
                                break;
                            }
                            ++n3;
                        }
                    } else {
                        if (n2 != oldColumn) {
                            reclick = true;
                        }
                        boolean bl = reclick;
                        this.setSortableColumn(jTable2, n, bl);
                    }
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(this.listMouseListener);
    }

    public void addRow(Vector vector) {
        this.rows.addElement(vector);
        int n = this.getRowCount();
        this.fireTableRowsInserted(n, n);
    }

    public void checkModel() {
        if (this.indexes.length != this.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int compare(int n, int n2) {
        ++this.compares;
        int n3 = 0;
        while (n3 < this.sortingColumns.size()) {
            Integer n4 = (Integer)this.sortingColumns.elementAt(n3);
            int n5 = this.compareRowsByColumn(n, n2, n4);
            if (n5 != 0) {
                return this.ascending ? n5 : -n5;
            }
            ++n3;
        }
        return 0;
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        Class clazz = this.getColumnClass(n3);
        Object object2 = this.getRealValueAt(n, n3);
        Object object3 = this.getRealValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == (class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = CvBaseTableModel.class$("java.lang.Number")))) {
            Number number;
            double d;
            Number number2 = (Number)this.getRealValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)this.getRealValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == (class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = CvBaseTableModel.class$("java.util.Date")))) {
            Date date;
            long l;
            Date date2 = (Date)this.getRealValueAt(n, n3);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)this.getRealValueAt(n2, n3)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = CvBaseTableModel.class$("java.lang.String")))) {
            String string2;
            String string3 = (String)this.getRealValueAt(n, n3);
            int n4 = string3.compareTo(string2 = (String)this.getRealValueAt(n2, n3));
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = CvBaseTableModel.class$("java.lang.Boolean")))) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)this.getRealValueAt(n, n3);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)this.getRealValueAt(n2, n3)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object4 = this.getRealValueAt(n, n3);
        String string4 = object4.toString();
        int n5 = string4.compareTo(string = (object = this.getRealValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    public int convertRowIndexToModel(int n) {
        if (n >= this.getRowCount() || n < 0) {
            return -1;
        }
        return this.indexes[n];
    }

    public int convertRowIndexToView(int n) {
        if (n >= this.getRowCount() || n < 0) {
            return -1;
        }
        int n2 = 0;
        while (this.indexes[n2] != n && n2 < this.getRowCount()) {
            ++n2;
        }
        return n2;
    }

    public void deleteRow(int n) {
        int n2 = this.indexes[n];
        this.rows.removeElementAt(n2);
        this.fireTableRowsDeleted(n2, n2);
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        if (this.oldColumn != -1) {
            this.sort(this);
        }
        super.fireTableChanged(tableModelEvent);
    }

    public Class getColumnClass(int n) {
        return this.getRealValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    protected Object getRealValueAt(int n, int n2) {
        if (!this.rows.isEmpty()) {
            Vector vector = (Vector)this.rows.elementAt(n);
            return vector.elementAt(n2);
        }
        return null;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        this.checkModel();
        return this.getRealValueAt(this.indexes[n], n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void modifyRow(int n, Vector vector) {
        int n2 = this.indexes[n];
        this.rows.setElementAt(vector, n2);
        this.fireTableRowsUpdated(n2, n2);
    }

    public void n2sort() {
        int n = 0;
        while (n < this.getRowCount()) {
            int n2 = n + 1;
            while (n2 < this.getRowCount()) {
                if (this.compare(this.indexes[n], this.indexes[n2]) == -1) {
                    this.swap(n, n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void reallocateIndexes() {
        int n = this.getRowCount();
        this.indexes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.indexes[n2] = n2;
            ++n2;
        }
    }

    public void removeAllRows() {
        int n = this.getRowCount();
        this.rows.removeAllElements();
        this.fireTableRowsDeleted(0, n);
    }

    public void setColumnsForSorting(int[] nArray) {
        this.sortableColumn = nArray;
    }

    public void setDefaultHeaderRenderer(TableCellRenderer tableCellRenderer) {
        defaultHeader = tableCellRenderer;
    }

    protected void setRealValueAt(Object object, int n, int n2) {
        Vector vector = (Vector)this.rows.get(n);
        vector.setElementAt(object, n2);
    }

    public void setSortableColumn(JTable jTable, int n, boolean bl) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        int n2 = jTable.convertColumnIndexToModel(n);
        int n3 = jTable.getSelectedRow();
        if (n3 != -1) {
            n3 = this.indexes[n3];
        }
        this.sortByColumn(n2, bl);
        if (bl) {
            tableColumn.setHeaderRenderer(asRenderer);
        } else {
            tableColumn.setHeaderRenderer(deasRenderer);
        }
        this.reclick = !bl;
        int n4 = jTable.convertColumnIndexToView(this.oldColumn);
        if (n4 != n && n4 != -1) {
            tableColumn = tableColumnModel.getColumn(n4);
            tableColumn.setHeaderRenderer(defaultHeader);
        }
        this.oldColumn = n2;
        if (n3 != -1) {
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < this.indexes.length) {
                if (this.indexes[n5] == n3) {
                    jTable.setRowSelectionInterval(n5, n5);
                    break;
                }
                ++n5;
            }
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        ((Component)jTableHeader).invalidate();
        ((Component)jTableHeader).validate();
        jTableHeader.repaint();
    }

    public void setUpHeaderRenderer(JTable jTable) {
        TableCellRenderer tableCellRenderer = defaultHeader;
        if (tableCellRenderer == null) {
            defaultHeader = tableCellRenderer = new LabelHeaderRenderer();
        }
        int n = 0;
        while (n < this.getColumnCount()) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            tableColumn.setHeaderRenderer(tableCellRenderer);
            ++n;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.setRealValueAt(object, this.indexes[n], n2);
        this.fireTableCellUpdated(this.indexes[n], n2);
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            int n6 = n;
            while (n6 < n2) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            nArray2[n7] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n7;
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort(this);
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    class LabelHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        JLabel label = new JLabel("");
        JLabel label1 = new JLabel(" ");
        boolean isBold = false;

        public LabelHeaderRenderer() {
        }

        public LabelHeaderRenderer(boolean bl) {
            this.isBold = bl;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            Font font = jTableHeader.getFont();
            this.label.setForeground(Color.black);
            this.label.setBorder(BorderFactory.createMatteBorder(2, 5, 2, 5, jTableHeader.getBackground()));
            this.label.setText(object.toString());
            this.label.setOpaque(true);
            this.label.setFont(font);
            this.setLayout(new BorderLayout());
            this.add(this.label);
            this.add((Component)this.label1, "East");
            this.setText(object.toString());
            this.setHorizontalAlignment(0);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setFont(font);
            return this;
        }
    }
}

