/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CtTimexListPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;

class Display
extends JTextField
implements FocusListener,
MouseListener {
    private boolean hasFocus = false;
    CtTimexListPanel list;

    public Display(String string, CtTimexListPanel ctTimexListPanel) {
        super(string);
        this.list = ctTimexListPanel;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.grabFocus();
        this.getCaret().setVisible(true);
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.getCaret().setVisible(false);
        this.getCaret().setVisible(false);
        this.hasFocus = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.selectAll();
        this.list.changeIndex();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(Color.blue);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

