/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CtMarginPanel;
import com.sun.symon.base.console.tools.editor.CtTimex;
import com.sun.symon.base.console.tools.editor.CtTimexField;
import com.sun.symon.base.console.tools.editor.CtTimexListPanel;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class CtTimexEditor
extends CtMarginPanel
implements ActionListener {
    private CtTimexListPanel valuePanel;
    CtMarginPanel editPanel = new CtMarginPanel(new Insets(5, 5, 5, 5));
    private CtMarginPanel statusBox = new CtMarginPanel(new Insets(5, 5, 5, 5));
    private JLabel statusMesg;
    private JButton insert = new JButton(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:insertbutt"));
    private JButton delete = new JButton(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:deletebutt"));
    private JButton apply = new JButton(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:applybutt"));
    private JButton cancel = new JButton(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:cancelbutt"));
    private String originalValue;
    private CtTimexField field;
    private boolean isTimeWindow = false;
    private CtMarginPanel infoPanel = new CtMarginPanel(new Insets(5, 5, 5, 5));

    public CtTimexEditor(CtTimexField ctTimexField, boolean bl) {
        this.isTimeWindow = bl;
        this.setLayout(new BorderLayout());
        this.setInsets(new Insets(5, 5, 5, 5));
        CtMarginPanel ctMarginPanel = new CtMarginPanel(new Insets(5, 5, 5, 5));
        ctMarginPanel.setLayout(new BorderLayout());
        this.disableEdit();
        this.originalValue = ctTimexField.getTextField().getText();
        this.field = ctTimexField;
        this.valuePanel = new CtTimexListPanel(this.originalValue, this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 10, 5));
        jPanel.add(this.insert);
        jPanel.add(this.delete);
        this.editPanel.setLayout(new BorderLayout());
        this.editPanel.add("North", jPanel);
        this.statusMesg = new JLabel(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:whattodo"));
        this.statusMesg.setFont(new Font("SansSerif", 0, 12));
        this.statusBox.setLayout(new BoxLayout(this.statusBox, 0));
        this.statusBox.add(this.statusMesg);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", this.valuePanel);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        String string = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:timex");
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("Center", jScrollPane);
        jPanel3.setBorder(BorderFactory.createTitledBorder(string));
        jPanel3.setPreferredSize(new Dimension(0, 150));
        ctMarginPanel.add("Center", jPanel3);
        ctMarginPanel.add("South", this.statusBox);
        ctMarginPanel.add("East", this.editPanel);
        CtMarginPanel ctMarginPanel2 = new CtMarginPanel(new Insets(5, 5, 5, 5));
        ctMarginPanel2.setLayout(new GridLayout(1, 5, 5, 2));
        ctMarginPanel2.add(new JLabel());
        ctMarginPanel2.add(this.apply);
        ctMarginPanel2.add(new JLabel());
        ctMarginPanel2.add(this.cancel);
        ctMarginPanel2.add(new JLabel());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add("North", new JSeparator());
        jPanel4.add("Center", ctMarginPanel2);
        String[] stringArray = ctTimexField.getAttributeEditor().getTimezoneInfo();
        CtTimexEditor.addTimezoneInfo(this.infoPanel, stringArray);
        this.add("North", this.infoPanel);
        this.add("Center", ctMarginPanel);
        this.add("South", jPanel4);
        this.insert.addActionListener(this);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        this.delete.addActionListener(this);
        if (this.originalValue.length() == 0) {
            this.insert.setEnabled(true);
            this.statusMesg.setText(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:nothing"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.insert) {
            Point point = this.getLocationOnScreen();
            Dimension dimension = this.getSize();
            this.disableButtons();
            JFrame jFrame = this.field.getTopFrame();
            JDialog jDialog = this.field.getTopDialog();
            JDialog jDialog2 = jFrame != null ? new JDialog(jFrame) : new JDialog(jDialog);
            CtTimex ctTimex = new CtTimex(this.valuePanel, this, this.isTimeWindow);
            jDialog2.getContentPane().add("Center", ctTimex);
            jDialog2.setTitle(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:title"));
            Point point2 = this.getLocationOnScreen();
            ((Component)jDialog2).setLocation(point2.x + 20, point2.y + 20);
            jDialog2.pack();
            jDialog2.show();
        } else if (actionEvent.getSource() == this.cancel) {
            this.getTopWindow().dispose();
            this.field.resetDialog();
        } else if (actionEvent.getSource() == this.delete) {
            if (this.valuePanel.notReady()) {
                Toolkit.getDefaultToolkit().beep();
                this.updateMessage(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:deleteerror"));
            } else {
                this.valuePanel.deleteSE();
            }
        } else if (actionEvent.getSource() == this.apply) {
            String string = this.valuePanel.getCurrentValue();
            if (!this.originalValue.equals(string)) {
                this.field.timexChanged(string);
            }
            this.getTopWindow().dispose();
            this.field.resetDialog();
        }
    }

    private static void addAnotherRow(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent, JComponent jComponent2) {
        gridBagConstraints.insets = new Insets(2, 4, 5, 6);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        jComponent2.setFont(new Font("SansSerif", 0, 12));
        jComponent2.setForeground(Color.black);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jPanel.add(jComponent2);
    }

    public static void addTimezoneInfo(JPanel jPanel, String[] stringArray) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        String string = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:note");
        String string2 = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:agentTime");
        String string3 = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:timezone");
        String string4 = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:unknownTime");
        if (stringArray == null) {
            string2 = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:consoleTime");
        } else if (stringArray[0].equals("NA")) {
            string4 = "   ";
            string3 = "   ";
            string2 = "   ";
            string = "   ";
        } else {
            string4 = stringArray[0];
        }
        CtTimexEditor.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(string, 4), new JLabel(string2));
        CtTimexEditor.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(string3, 4), new JLabel(string4));
    }

    void disableButtons() {
        this.apply.setEnabled(false);
        this.insert.setEnabled(false);
        this.cancel.setEnabled(false);
        this.delete.setEnabled(false);
    }

    void disableDelete() {
        this.delete.setEnabled(false);
    }

    void disableEdit() {
        this.delete.setEnabled(false);
    }

    void enableButtons() {
        this.insert.setEnabled(true);
        this.cancel.setEnabled(true);
        this.apply.setEnabled(true);
        if (this.valuePanel.notReady()) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
        }
    }

    void enableEdit() {
        this.insert.setEnabled(true);
        this.delete.setEnabled(true);
    }

    public CtTimexField getTimexField() {
        return this.field;
    }

    Window getTopWindow() {
        Container container = this;
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    void updateMessage(String string) {
        this.statusMesg.setText(string);
        this.statusBox.invalidate();
        this.statusBox.validate();
        this.statusBox.repaint();
        this.invalidate();
        this.validate();
        this.repaint();
    }
}

