/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.topology.console;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.client.topology.SMUserDomainResponse;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.tools.topology.console.TCExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TCExportDomainChooser
extends JPanel
implements SMUserDomainResponse,
AwxServiceManager {
    private final String EXPORT_DOMAIN_NAME = "exportDomainName";
    private final String EXPORT_TO_FILE = "exportToFile";
    private final String FILE_NAME = "fileName";
    private final String BROWSE = "browse";
    private final String EXPORT_TITLE = "exportTitle";
    private final String OK = "ok";
    private final String CANCEL = "cancel";
    private final String EXPORT_MODE = "exportMode";
    private final String APPEND = "append";
    private final String OVERWRITE = "overwrite";
    private final String VALID = "validity";
    private final String UNLIMIT = "unlimit";
    private final String ALL_DOMAINS = "allDomain";
    private final String HELP = "help";
    private final String NO_LIC = "noLic";
    private final String COMMENTS = "comments";
    private final String REQ_PERIOD = "600";
    private Component owner;
    private JTextField fileTF;
    private JFileChooser fc;
    private ButtonGroup btnGrp;
    private SMRawDataRequest req;
    private SMUserDomainRequest domainRequest;
    private JComboBox domainList;
    private JTextArea commentArea;
    private JComboBox validity;
    private Object handle;
    private AwxServiceProvider SvcProvider;
    private int i = 0;

    public TCExportDomainChooser() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(this.translate("exportDomainName"));
        jPanel.add((Component)jLabel, "West");
        this.domainList = new JComboBox();
        jPanel.add((Component)this.domainList, "Center");
        Dimension dimension = this.domainList.getPreferredSize();
        this.domainList.setPreferredSize(new Dimension((int)dimension.getWidth(), 26));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        jPanel2.add((Component)new JLabel(this.translate("exportToFile")), gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 6, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        jPanel3.add(new JLabel(this.translate("fileName")));
        this.fileTF = new JTextField(25);
        jPanel3.add(this.fileTF);
        JButton jButton = new JButton(this.translate("browse"));
        jPanel3.add(jButton);
        this.fc = new JFileChooser();
        this.fc.setDialogTitle(this.translate("exportTitle"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TCExportDomainChooser.this.fc.showDialog(((JButton)actionEvent.getSource()).getRootPane().getParent(), TCExportDomainChooser.this.translate("ok")) == 0) {
                    File file = TCExportDomainChooser.this.fc.getSelectedFile();
                    TCExportDomainChooser.this.fileTF.setText(file.getPath());
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 0));
        jLabel = new JLabel(this.translate("exportMode"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 12));
        jLabel.setAlignmentY(0.0f);
        jPanel4.add(jLabel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setAlignmentY(0.0f);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.btnGrp = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(this.translate("append"));
        jRadioButton.setSelected(true);
        jRadioButton.setActionCommand("Append");
        JRadioButton jRadioButton2 = new JRadioButton(this.translate("overwrite"));
        jRadioButton2.setActionCommand("Overwrite");
        this.btnGrp.add(jRadioButton);
        this.btnGrp.add(jRadioButton2);
        jPanel5.add(jRadioButton);
        jPanel5.add(jRadioButton2);
        jPanel4.add(jPanel5);
        jPanel4.add(Box.createHorizontalGlue());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout());
        jPanel6.setAlignmentY(0.0f);
        jLabel = new JLabel(this.translate("validity"));
        jLabel.setAlignmentY(0.0f);
        jPanel6.add(jLabel);
        String[] stringArray = new String[]{"Unlimited", "7", "15", "30", "90"};
        this.validity = new JComboBox<String>(stringArray);
        this.validity.setAlignmentY(0.0f);
        this.validity.setEditable(true);
        jPanel6.add(this.validity);
        jPanel4.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jLabel = new JLabel(this.translate("comments"));
        jLabel.setAlignmentX(0.0f);
        jPanel7.add(jLabel);
        jPanel7.add(Box.createRigidArea(new Dimension(0, 5)));
        this.commentArea = new JTextArea();
        this.commentArea.setLineWrap(true);
        this.commentArea.setWrapStyleWord(false);
        this.commentArea.setRows(4);
        this.commentArea.setAutoscrolls(true);
        JScrollPane jScrollPane = new JScrollPane(this.commentArea, 20, 31);
        jScrollPane.setAlignmentX(0.0f);
        jPanel7.add(jScrollPane);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jPanel8.add(Box.createHorizontalGlue());
        JButton jButton2 = new JButton(this.translate("ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TCExportDomainChooser.this.doExport();
            }
        });
        jPanel8.add(jButton2);
        jPanel8.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton3 = new JButton(this.translate("cancel"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TCExportDomainChooser.this.owner.setVisible(false);
            }
        });
        jPanel8.add(jButton3);
        jPanel8.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton4 = new JButton(this.translate("help"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "export-help";
                CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
                cmConsoleSession.launchHelp(string);
            }
        });
        jPanel8.add(jButton4);
        this.setLayout(new BoxLayout(this, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel7.setAlignmentX(0.0f);
        jPanel8.setAlignmentX(0.0f);
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        this.add(jPanel4);
        this.add(jPanel7);
        this.add(jPanel8);
    }

    public void doExport() {
        int n = this.btnGrp.getSelection().getActionCommand() == "Append" ? 0 : 1;
        new TCExport(this.owner, this.fileTF.getText(), (String)this.domainList.getSelectedItem(), n, this.commentArea.getText(), (String)this.validity.getSelectedItem(), this.req, this.SvcProvider).doIt();
    }

    public void getDomainDataResponse(SMRequestStatus sMRequestStatus, SMUserDomainData[] sMUserDomainDataArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)("Domain list request unsuccessful: " + sMRequestStatus.getMessageText()));
            if (sMRequestStatus.getReturnCode() == 4) {
                this.req.launchTimeoutNotification("both");
            }
            return;
        }
        int n = this.domainList.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        this.domainList.removeAllItems();
        this.domainList.addItem(this.translate("allDomain"));
        int n2 = 1;
        while (n2 < sMUserDomainDataArray.length) {
            this.domainList.addItem(sMUserDomainDataArray[n2].getDomainName());
            ++n2;
        }
        this.domainList.setSelectedIndex(n);
        this.domainList.revalidate();
    }

    public void init() {
        block4: {
            Container container = this;
            while (container != null) {
                if (container instanceof Window) {
                    this.owner = container;
                    break;
                }
                container = container.getParent();
            }
            UcCommon.isServiceLicenseAvailable((String)"Export_Import_Service", (Component)this.owner);
            if (this.req == null) break block4;
            try {
                this.handle = this.domainRequest.getUserDomainsRequest("", "600", (SMUserDomainResponse)this, null);
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)"Failded to send get user domains request with exception ", (Throwable)sMAPIException);
            }
        }
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.req = sMRawDataRequest;
        this.domainRequest = new SMUserDomainRequest(sMRawDataRequest);
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.tools.topology.console.TopologyBundle:" + string));
    }
}

