/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.cli.topology;

import com.sun.symon.base.cli.base.ClCLIBaseCommand;
import com.sun.symon.base.cli.base.ClCLIData;
import com.sun.symon.base.cli.base.ClSession;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyEntityData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.utility.UcInternationalizer;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class ClTopologyBase
extends ClCLIBaseCommand {
    protected static final String COL_DOMAIN_NAME = "Domain Name";
    protected static final String COL_DOMAIN_OWNER = "Domain Owner";
    protected static final String COL_DOMAIN_ROOT_URL = "Domain Root URL";
    protected static final String COL_TOPOLOGY_NAME = "Name";
    protected static final String COL_OBJECT_ID = "Object ID";
    protected static final String COL_ARCH = "Architecture";
    protected static final String COL_CONFIG = "Configuration";
    protected static final String COL_DESC = "Description";
    protected static final String COL_ENTITY_ID = "Entity ID";
    protected static final String COL_FAMILY = "Family";
    protected static final String COL_FULL_DESC = "Full Description";
    protected static final String COL_HOST_NAME = "Host";
    protected static final String COL_IP_ADDR = "Host IP";
    protected static final String COL_POLLING = "Polling Indicator";
    protected static final String COL_SOFT_GROUP_LINK = "Soft Group Link Indicator";
    protected static final String COL_NETMASK = "Net Mask";
    protected static final String COL_POLL_TYPE = "Poll Type";
    protected static final String COL_READ_INFO = "Read Security Info";
    protected static final String COL_TARGET_HOST = "Target Host";
    protected static final String COL_TARGET_IP = "Target Host IP";
    protected static final String COL_TYPE = "Representation Type";
    protected static final String COL_WRITE_INFO = "Write Security Info";
    protected static final String COL_X_COORD = "X Coordinate";
    protected static final String COL_Y_COORD = "Y Coordinate";
    protected static final String COL_AGENT_PORT = "Agent Port";
    protected static final String[] TOPOENTITY_DESC_LIST = new String[]{"fullDesc", "family", "topoType", "topoCfg", "isPolled", "pollType", "readInfo", "writeInfo", "targetHost", "targetIp"};
    protected static final String[] TOPOENTITY_FILTER_LIST = new String[]{"pollType", "arch", "family"};
    protected static final String[] TOPOGROUP_DESC_LIST = new String[]{"family", "fullDesc"};
    protected static final String DEFAULTDOMAIN1 = "default domain";
    protected static final String DEFAULTDOMAIN2 = "defaultdomain";
    protected static final String DEFAULTDOMAIN3 = "default_domain";
    protected static final String DEFAULTDOMAINKEY = "base.console.ConsoleTopology:domain.defaultdomain";

    public ClTopologyBase(ClSession clSession, String string, ClCLIData clCLIData, ClCLIData clCLIData2) {
        super(clSession, string, clCLIData, clCLIData2);
    }

    protected String convertTopoDomainName(String string) {
        if (this.isDefaultDomain(string)) {
            return DEFAULTDOMAINKEY;
        }
        return string;
    }

    protected String convertTopoName(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (bl) {
                if (cArray[n] == '/' && n + 1 < cArray.length && cArray[n + 1] == '/') {
                    cArray[++n] = 255;
                }
            } else if (cArray[n] == '\u00ff') {
                cArray[n] = 47;
            }
            ++n;
        }
        return new String(cArray);
    }

    protected void depthSearch(ClCLIData clCLIData, SMTopologyRequest sMTopologyRequest, String string, String string2, StringTokenizer stringTokenizer, Vector vector) {
        block17: {
            if (!this.isRunning()) {
                return;
            }
            try {
                SMHierarchyViewData sMHierarchyViewData;
                int n;
                int n2;
                Vector vector2 = new Vector();
                Vector vector3 = new Vector();
                if (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
                    SMHierarchyViewData sMHierarchyViewData2;
                    int n3;
                    int n4;
                    String string3 = this.convertTopoName(stringTokenizer.nextToken(), false);
                    string2 = String.valueOf(string2) + "/" + string3;
                    sMTopologyRequest.topologySearch(string, string3, vector2, vector3);
                    if (vector2.size() > 0) {
                        n4 = 0;
                        n3 = vector2.size();
                        while (n4 < n3) {
                            sMHierarchyViewData2 = (SMHierarchyViewData)vector2.elementAt(n4);
                            if (string3.equals(sMHierarchyViewData2.getName())) {
                                vector.addElement(this.getViewData(sMHierarchyViewData2, string2));
                            }
                            ++n4;
                        }
                    }
                    n4 = 0;
                    n3 = vector3.size();
                    while (n4 < n3) {
                        try {
                            SMTopologyEntityData[] sMTopologyEntityDataArray;
                            sMHierarchyViewData2 = (SMHierarchyViewData)vector3.elementAt(n4);
                            if (string3.equals(sMHierarchyViewData2.getName()) && (sMTopologyEntityDataArray = sMTopologyRequest.getTopologyInfo(sMHierarchyViewData2.getTargetUrl(), null))[0].getPollType().equals("aview")) {
                                this.depthSearch(clCLIData, sMTopologyRequest, sMHierarchyViewData2.getNavigationUrl(), string2, stringTokenizer, vector);
                            }
                        }
                        catch (Exception exception) {}
                        ++n4;
                    }
                    break block17;
                }
                sMTopologyRequest.topologySearch(string, "", vector2, vector3);
                if (vector2.size() > 0) {
                    n2 = 0;
                    n = vector2.size();
                    while (n2 < n) {
                        sMHierarchyViewData = (SMHierarchyViewData)vector2.elementAt(n2);
                        vector.addElement(this.getViewData(sMHierarchyViewData, String.valueOf(string2) + "/" + sMHierarchyViewData.getName()));
                        ++n2;
                    }
                }
                if (vector3.size() <= 0) break block17;
                n2 = 0;
                n = vector3.size();
                while (n2 < n) {
                    try {
                        sMHierarchyViewData = (SMHierarchyViewData)vector3.elementAt(n2);
                        SMTopologyEntityData[] sMTopologyEntityDataArray = sMTopologyRequest.getTopologyInfo(sMHierarchyViewData.getTargetUrl(), null);
                        if (sMTopologyEntityDataArray[0].getPollType().equals("aview")) {
                            this.depthSearch(clCLIData, sMTopologyRequest, sMHierarchyViewData.getNavigationUrl(), String.valueOf(string2) + "/" + sMHierarchyViewData.getName(), null, vector);
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
            catch (Exception exception) {
                clCLIData.appendRow(ClCLIData.ROW_TYPE_ERROR);
                clCLIData.appendColumn("state", this.session_.getI18NMessage("State.Fail"));
                clCLIData.appendColumn("message", exception.getMessage());
                System.err.println("ClTopologyBase.depthSearth: " + exception.getMessage());
            }
        }
    }

    protected void displayTopology(SMTopologyRequest sMTopologyRequest, SMHierarchyViewData sMHierarchyViewData, Vector vector, String[] stringArray) {
        try {
            SMHierarchyViewData sMHierarchyViewData2;
            SMTopologyEntityData[] sMTopologyEntityDataArray;
            if (sMHierarchyViewData.getIsBranch()) {
                sMTopologyEntityDataArray = sMTopologyRequest.getTopologyInfo(sMHierarchyViewData.getNavigationUrl(), null);
                this.printTopology(new SMHierarchyViewData[]{sMHierarchyViewData}, sMTopologyEntityDataArray, stringArray);
            }
            int n = 0;
            Vector<SMHierarchyViewData> vector2 = new Vector<SMHierarchyViewData>();
            while (vector.size() > 0 && n < vector.size()) {
                sMHierarchyViewData2 = (SMHierarchyViewData)vector.elementAt(n);
                if (sMHierarchyViewData2.getName().startsWith(sMHierarchyViewData.getName())) {
                    vector.remove(n);
                    if (sMHierarchyViewData2.getIsBranch()) {
                        this.displayTopology(sMTopologyRequest, sMHierarchyViewData2, vector, stringArray);
                        continue;
                    }
                    vector2.addElement(sMHierarchyViewData2);
                    continue;
                }
                ++n;
            }
            if (vector2.size() == 0) {
                return;
            }
            String[] stringArray2 = new String[vector2.size()];
            int n2 = 0;
            int n3 = stringArray2.length;
            while (n2 < n3) {
                sMHierarchyViewData2 = (SMHierarchyViewData)vector2.elementAt(n2);
                stringArray2[n2] = sMHierarchyViewData2.getObjectId();
                ++n2;
            }
            sMTopologyEntityDataArray = sMTopologyRequest.getTopologyInfo(sMHierarchyViewData.getNavigationUrl(), stringArray2);
            Object[] objectArray = new SMHierarchyViewData[vector2.size()];
            vector2.copyInto(objectArray);
            this.printTopology((SMHierarchyViewData[])objectArray, sMTopologyEntityDataArray, stringArray);
        }
        catch (Exception exception) {
            this.handleException(exception, this.session_.getI18NMessage("Topology.GetAllTopoObjectsFail"), false);
        }
    }

    protected SMHierarchyViewData getViewData(SMHierarchyViewData sMHierarchyViewData, String string) {
        if (sMHierarchyViewData == null) {
            return new SMHierarchyViewData("", "", null, null, null, null, false, false);
        }
        return new SMHierarchyViewData(sMHierarchyViewData.getObjectId(), string, sMHierarchyViewData.getFamilyImages(), sMHierarchyViewData.getFamilyCommands(), sMHierarchyViewData.getNavigationUrl(), sMHierarchyViewData.getTargetUrl(), sMHierarchyViewData.getIsBranch(), sMHierarchyViewData.getIsSoftGroupLink());
    }

    protected boolean isDefaultDomain(String string) {
        return string.equalsIgnoreCase(DEFAULTDOMAIN1) || string.equalsIgnoreCase(DEFAULTDOMAIN2) || string.equalsIgnoreCase(DEFAULTDOMAIN3) || string.equalsIgnoreCase(DEFAULTDOMAINKEY);
    }

    protected void printTopology(SMHierarchyViewData[] sMHierarchyViewDataArray, SMTopologyEntityData[] sMTopologyEntityDataArray, String[] stringArray) throws Exception {
        ClCLIData clCLIData = this.getOutput();
        int n = 0;
        int n2 = sMTopologyEntityDataArray.length;
        while (n < n2) {
            if (!(stringArray[0] != null && !sMTopologyEntityDataArray[n].getPollType().equals(stringArray[0]) || stringArray[1] != null && sMTopologyEntityDataArray[n].getArch().indexOf(stringArray[1]) == -1 || stringArray[2] != null && sMTopologyEntityDataArray[n].getFamily().indexOf(stringArray[2]) == -1)) {
                clCLIData.appendRow(ClCLIData.ROW_TYPE_DATA);
                clCLIData.appendColumn(COL_TOPOLOGY_NAME, sMHierarchyViewDataArray[n].getName());
                clCLIData.appendColumn(COL_ARCH, sMTopologyEntityDataArray[n].getArch());
                clCLIData.appendColumn(COL_CONFIG, sMTopologyEntityDataArray[n].getConfig());
                clCLIData.appendColumn(COL_DESC, UcInternationalizer.translateKey((String)sMTopologyEntityDataArray[n].getDesc()));
                clCLIData.appendColumn(COL_ENTITY_ID, sMTopologyEntityDataArray[n].getEntityId());
                clCLIData.appendColumn(COL_FAMILY, sMTopologyEntityDataArray[n].getFamily());
                clCLIData.appendColumn(COL_FULL_DESC, sMTopologyEntityDataArray[n].getFullDesc());
                clCLIData.appendColumn(COL_HOST_NAME, sMTopologyEntityDataArray[n].getHostName());
                clCLIData.appendColumn(COL_IP_ADDR, sMTopologyEntityDataArray[n].getIpAddr());
                clCLIData.appendColumn(COL_POLLING, sMTopologyEntityDataArray[n].getIsPoll());
                clCLIData.appendColumn(COL_SOFT_GROUP_LINK, sMTopologyEntityDataArray[n].getIsSoftGroupLink());
                clCLIData.appendColumn(COL_NETMASK, sMTopologyEntityDataArray[n].getNetmask());
                clCLIData.appendColumn(COL_POLL_TYPE, sMTopologyEntityDataArray[n].getPollType());
                clCLIData.appendColumn(COL_READ_INFO, sMTopologyEntityDataArray[n].getReadInfo());
                clCLIData.appendColumn(COL_TARGET_HOST, sMTopologyEntityDataArray[n].getTargetHost());
                clCLIData.appendColumn(COL_TARGET_IP, sMTopologyEntityDataArray[n].getTargetIP());
                clCLIData.appendColumn(COL_TYPE, sMTopologyEntityDataArray[n].getType());
                clCLIData.appendColumn(COL_WRITE_INFO, sMTopologyEntityDataArray[n].getWriteInfo());
                clCLIData.appendColumn(COL_X_COORD, sMTopologyEntityDataArray[n].getXCoord());
                clCLIData.appendColumn(COL_Y_COORD, sMTopologyEntityDataArray[n].getYCoord());
            }
            ++n;
        }
    }
}

