/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.cli.base;

import com.sun.symon.base.cli.base.ClCLIData;
import com.sun.symon.base.cli.base.ClCLIException;
import com.sun.symon.base.cli.base.ClSession;
import com.sun.symon.base.cli.base.ClThreadInfo;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ClCLIBaseCommand
extends Thread {
    protected ClSession session_;
    private String command_;
    private ClCLIData in_;
    private ClCLIData out_;
    private String sNonHTMLHelp_ = null;
    private Vector vHelp_ = null;
    private volatile ClThreadInfo oThreadInfo_ = null;

    public ClCLIBaseCommand(ClSession clSession, String string, ClCLIData clCLIData, ClCLIData clCLIData2) {
        this.session_ = clSession;
        this.command_ = string;
        this.in_ = clCLIData;
        this.out_ = clCLIData2;
        Hashtable hashtable = this.in_.getHashtable();
        String string2 = (String)hashtable.get("columns");
        if (string2 != null) {
            this.out_.setColumns(string2);
        }
        this.setHelp(this.session_.getHelp(this.command_, 200));
    }

    public void checkForUnknownParameters(ClCLIData clCLIData, String[] stringArray) throws Exception {
        this.session_.checkForUnknownParameters(clCLIData, stringArray);
    }

    public String getCommand() {
        return this.command_;
    }

    public String getHelp() {
        return this.session_.getHelp(this.command_, 200);
    }

    public ClCLIData getInput() {
        return this.in_;
    }

    public ClCLIData getOutput() {
        return this.out_;
    }

    public String getUnknownParameters(ClCLIData clCLIData, String[] stringArray) {
        return this.session_.getUnknownParameters(clCLIData, stringArray);
    }

    public void handleException(Exception exception, String string) {
        this.handleException(exception, string, true);
    }

    public void handleException(Exception exception, String string, boolean bl) {
        this.out_.appendRow(ClCLIData.ROW_TYPE_ERROR);
        this.out_.appendColumn("state", this.session_.getI18NMessage("State.Fail"));
        if (exception instanceof ClCLIException) {
            this.out_.appendColumn("message", exception.getMessage());
        } else {
            this.out_.appendColumn("message", string);
            System.err.println(String.valueOf(this.command_) + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        if (bl) {
            this.session_.setError(true);
        }
    }

    public boolean isRunning() {
        if (this.oThreadInfo_ == null) {
            return true;
        }
        return this.oThreadInfo_.getState() == 2;
    }

    public void printHelp() {
        if (this.sNonHTMLHelp_ == null) {
            this.session_.printI18NMessage("Base.HelpNotAvailable");
        } else {
            this.session_.println(this.sNonHTMLHelp_);
        }
    }

    public final void run() {
        try {
            this.runCommand();
            this.session_.print("thread", this.in_, new ClCLIData(this.session_));
            this.oThreadInfo_.setState(4);
        }
        catch (Exception exception) {
            String string = exception.getMessage() == null ? exception.toString() : exception.getMessage();
            this.oThreadInfo_.setMessage(string);
            this.oThreadInfo_.setState(5);
        }
        this.oThreadInfo_.recordLog();
    }

    public abstract void runCommand();

    private void setHelp(String string) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2;
            int n3 = string.indexOf("&nbsp;", n);
            if (n3 == -1) {
                n3 = string.length();
            }
            if ((n2 = string.indexOf("<", n)) == -1) {
                n2 = string.length();
            }
            int n4 = n3 > n2 ? n2 : n3;
            stringBuffer.append(string.substring(n, n4));
            int n5 = n = n4 == n3 ? n3 + 6 : string.indexOf(">", n2) + 1;
        }
        this.sNonHTMLHelp_ = stringBuffer.toString();
    }

    public final void start() {
    }

    public final void startCommand(ClThreadInfo clThreadInfo) throws Exception {
        this.oThreadInfo_ = clThreadInfo;
        if (this.oThreadInfo_ == null) {
            this.runCommand();
        } else {
            this.oThreadInfo_.setMessage("START OF THREAD");
            this.oThreadInfo_.recordLog();
            this.oThreadInfo_.setMessage(null);
            super.start();
        }
    }
}

